<?php
$rhodos_slider_sc = rhodos_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $rhodos_slider_sc ) && strpos( $rhodos_slider_sc, '[' ) !== false && strpos( $rhodos_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider">
	<?php
		// Add anchor
		$rhodos_anchor_icon = rhodos_get_theme_option( 'front_page_title_anchor_icon' );
		$rhodos_anchor_text = rhodos_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $rhodos_anchor_icon ) || ! empty( $rhodos_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $rhodos_anchor_icon ) ? ' icon="' . esc_attr( $rhodos_anchor_icon ) . '"' : '' )
									. ( ! empty( $rhodos_anchor_text ) ? ' title="' . esc_attr( $rhodos_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $rhodos_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$rhodos_scheme = rhodos_get_theme_option( 'front_page_title_scheme' );
		if ( ! rhodos_is_inherit( $rhodos_scheme ) ) {
			echo ' scheme_' . esc_attr( $rhodos_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( rhodos_get_theme_option( 'front_page_title_paddings' ) );
		?>
		"
		<?php
		$rhodos_css      = '';
		$rhodos_bg_image = rhodos_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $rhodos_bg_image ) ) {
			$rhodos_css .= 'background-image: url(' . esc_url( rhodos_get_attachment_url( $rhodos_bg_image ) ) . ');';
		}
		if ( ! empty( $rhodos_css ) ) {
			echo ' style="' . esc_attr( $rhodos_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$rhodos_anchor_icon = rhodos_get_theme_option( 'front_page_title_anchor_icon' );
		$rhodos_anchor_text = rhodos_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $rhodos_anchor_icon ) || ! empty( $rhodos_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $rhodos_anchor_icon ) ? ' icon="' . esc_attr( $rhodos_anchor_icon ) . '"' : '' )
									. ( ! empty( $rhodos_anchor_text ) ? ' title="' . esc_attr( $rhodos_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( rhodos_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' rhodos-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$rhodos_css      = '';
			$rhodos_bg_mask  = rhodos_get_theme_option( 'front_page_title_bg_mask' );
			$rhodos_bg_color_type = rhodos_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $rhodos_bg_color_type ) {
				$rhodos_bg_color = rhodos_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $rhodos_bg_color_type ) {
				$rhodos_bg_color = rhodos_get_scheme_color( 'bg_color', $rhodos_scheme );
			} else {
				$rhodos_bg_color = '';
			}
			if ( ! empty( $rhodos_bg_color ) && $rhodos_bg_mask > 0 ) {
				$rhodos_css .= 'background-color: ' . esc_attr(
					1 == $rhodos_bg_mask ? $rhodos_bg_color : rhodos_hex2rgba( $rhodos_bg_color, $rhodos_bg_mask )
				) . ';';
			}
			if ( ! empty( $rhodos_css ) ) {
				echo ' style="' . esc_attr( $rhodos_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$rhodos_caption = rhodos_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $rhodos_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $rhodos_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $rhodos_caption, 'rhodos_kses_content' ); ?></h1>
					<?php
				}

				// Description (text)
				$rhodos_description = rhodos_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $rhodos_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $rhodos_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $rhodos_description ), 'rhodos_kses_content' ); ?></div>
					<?php
				}

				// Buttons
				if ( rhodos_get_theme_option( 'front_page_title_button1_link' ) != '' || rhodos_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						rhodos_show_layout( rhodos_customizer_partial_refresh_front_page_title_button1_link() );
						rhodos_show_layout( rhodos_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
