<?php
/**
 * The template for homepage posts with "Classic" style
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0
 */
rhodos_storage_set( 'blog_archive', true );

get_header();

if ( have_posts() ) {

	rhodos_blog_archive_start();

	$rhodos_classes    = 'posts_container '
						. ( substr( rhodos_get_theme_option( 'blog_style' ), 0, 7 ) == 'classic'
							? 'columns_wrap columns_padding_bottom'
							: 'masonry_wrap'
							);
	$rhodos_stickies   = is_home() ? get_option( 'sticky_posts' ) : false;
	$rhodos_sticky_out = rhodos_get_theme_option( 'sticky_style' ) == 'columns'
							&& is_array( $rhodos_stickies ) && count( $rhodos_stickies ) > 0 && get_query_var( 'paged' ) < 1;
	if ( $rhodos_sticky_out ) {
		?>
		<div class="sticky_wrap columns_wrap">
		<?php
	}
	if ( ! $rhodos_sticky_out ) {
		if ( rhodos_get_theme_option( 'first_post_large' ) && ! is_paged() && ! in_array( rhodos_get_theme_option( 'body_style' ), array( 'fullwide', 'fullscreen' ) ) ) {
			the_post();
			get_template_part( apply_filters( 'rhodos_filter_get_template_part', 'content', 'excerpt' ), 'excerpt' );
		}

		?>
		<div class="<?php echo esc_attr( $rhodos_classes ); ?>">
		<?php
	}
	while ( have_posts() ) {
		the_post();
		if ( $rhodos_sticky_out && ! is_sticky() ) {
			$rhodos_sticky_out = false;
			?>
			</div><div class="<?php echo esc_attr( $rhodos_classes ); ?>">
			<?php
		}
		$rhodos_part = $rhodos_sticky_out && is_sticky() ? 'sticky' : 'classic';
		get_template_part( apply_filters( 'rhodos_filter_get_template_part', 'content', $rhodos_part ), $rhodos_part );
	}

	?>
	</div>
	<?php

	rhodos_show_pagination();

	rhodos_blog_archive_end();

} else {

	if ( is_search() ) {
		get_template_part( apply_filters( 'rhodos_filter_get_template_part', 'content', 'none-search' ), 'none-search' );
	} else {
		get_template_part( apply_filters( 'rhodos_filter_get_template_part', 'content', 'none-archive' ), 'none-archive' );
	}
}

get_footer();
