<?php
/**
 * The template for homepage posts with "Portfolio" style
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0
 */

rhodos_storage_set( 'blog_archive', true );

get_header();

if ( have_posts() ) {

	rhodos_blog_archive_start();

	$rhodos_stickies   = is_home() ? get_option( 'sticky_posts' ) : false;
	$rhodos_sticky_out = rhodos_get_theme_option( 'sticky_style' ) == 'columns'
							&& is_array( $rhodos_stickies ) && count( $rhodos_stickies ) > 0 && get_query_var( 'paged' ) < 1;

	// Show filters
	$rhodos_cat          = rhodos_get_theme_option( 'parent_cat' );
	$rhodos_post_type    = rhodos_get_theme_option( 'post_type' );
	$rhodos_taxonomy     = rhodos_get_post_type_taxonomy( $rhodos_post_type );
	$rhodos_show_filters = rhodos_get_theme_option( 'show_filters' );
	$rhodos_tabs         = array();
	if ( ! rhodos_is_off( $rhodos_show_filters ) ) {
		$rhodos_args           = array(
			'type'         => $rhodos_post_type,
			'child_of'     => $rhodos_cat,
			'orderby'      => 'name',
			'order'        => 'ASC',
			'hide_empty'   => 1,
			'hierarchical' => 0,
			'taxonomy'     => $rhodos_taxonomy,
			'pad_counts'   => false,
		);
		$rhodos_portfolio_list = get_terms( $rhodos_args );
		if ( is_array( $rhodos_portfolio_list ) && count( $rhodos_portfolio_list ) > 0 ) {
			$rhodos_tabs[ $rhodos_cat ] = esc_html__( 'All', 'rhodos' );
			foreach ( $rhodos_portfolio_list as $rhodos_term ) {
				if ( isset( $rhodos_term->term_id ) ) {
					$rhodos_tabs[ $rhodos_term->term_id ] = $rhodos_term->name;
				}
			}
		}
	}
	if ( count( $rhodos_tabs ) > 0 ) {
		$rhodos_portfolio_filters_ajax   = true;
		$rhodos_portfolio_filters_active = $rhodos_cat;
		$rhodos_portfolio_filters_id     = 'portfolio_filters';
		?>
		<div class="portfolio_filters rhodos_tabs rhodos_tabs_ajax">
			<ul class="portfolio_titles rhodos_tabs_titles">
				<?php
				foreach ( $rhodos_tabs as $rhodos_id => $rhodos_title ) {
					?>
					<li><a href="<?php echo esc_url( rhodos_get_hash_link( sprintf( '#%s_%s_content', $rhodos_portfolio_filters_id, $rhodos_id ) ) ); ?>" data-tab="<?php echo esc_attr( $rhodos_id ); ?>"><?php echo esc_html( $rhodos_title ); ?></a></li>
					<?php
				}
				?>
			</ul>
			<?php
			$rhodos_ppp = rhodos_get_theme_option( 'posts_per_page' );
			if ( rhodos_is_inherit( $rhodos_ppp ) ) {
				$rhodos_ppp = '';
			}
			foreach ( $rhodos_tabs as $rhodos_id => $rhodos_title ) {
				$rhodos_portfolio_need_content = $rhodos_id == $rhodos_portfolio_filters_active || ! $rhodos_portfolio_filters_ajax;
				?>
				<div id="<?php echo esc_attr( sprintf( '%s_%s_content', $rhodos_portfolio_filters_id, $rhodos_id ) ); ?>"
					class="portfolio_content rhodos_tabs_content"
					data-blog-template="<?php echo esc_attr( rhodos_storage_get( 'blog_template' ) ); ?>"
					data-blog-style="<?php echo esc_attr( rhodos_get_theme_option( 'blog_style' ) ); ?>"
					data-posts-per-page="<?php echo esc_attr( $rhodos_ppp ); ?>"
					data-post-type="<?php echo esc_attr( $rhodos_post_type ); ?>"
					data-taxonomy="<?php echo esc_attr( $rhodos_taxonomy ); ?>"
					data-cat="<?php echo esc_attr( $rhodos_id ); ?>"
					data-parent-cat="<?php echo esc_attr( $rhodos_cat ); ?>"
					data-need-content="<?php echo ( false === $rhodos_portfolio_need_content ? 'true' : 'false' ); ?>"
				>
					<?php
					if ( $rhodos_portfolio_need_content ) {
						rhodos_show_portfolio_posts(
							array(
								'cat'        => $rhodos_id,
								'parent_cat' => $rhodos_cat,
								'taxonomy'   => $rhodos_taxonomy,
								'post_type'  => $rhodos_post_type,
								'page'       => 1,
								'sticky'     => $rhodos_sticky_out,
							)
						);
					}
					?>
				</div>
				<?php
			}
			?>
		</div>
		<?php
	} else {
		rhodos_show_portfolio_posts(
			array(
				'cat'        => $rhodos_cat,
				'parent_cat' => $rhodos_cat,
				'taxonomy'   => $rhodos_taxonomy,
				'post_type'  => $rhodos_post_type,
				'page'       => 1,
				'sticky'     => $rhodos_sticky_out,
			)
		);
	}

	rhodos_blog_archive_end();

} else {

	if ( is_search() ) {
		get_template_part( apply_filters( 'rhodos_filter_get_template_part', 'content', 'none-search' ), 'none-search' );
	} else {
		get_template_part( apply_filters( 'rhodos_filter_get_template_part', 'content', 'none-archive' ), 'none-archive' );
	}
}

get_footer();
