<?php
/* Contact Form 7 support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'rhodos_cf7_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'rhodos_cf7_theme_setup9', 9 );
	function rhodos_cf7_theme_setup9() {

		add_filter( 'rhodos_filter_merge_scripts', 'rhodos_cf7_merge_scripts' );
		add_filter( 'rhodos_filter_merge_styles', 'rhodos_cf7_merge_styles' );

		if ( rhodos_exists_cf7() ) {
			add_action( 'wp_enqueue_scripts', 'rhodos_cf7_frontend_scripts', 1100 );
		}

		if ( is_admin() ) {
			add_filter( 'rhodos_filter_tgmpa_required_plugins', 'rhodos_cf7_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'rhodos_cf7_tgmpa_required_plugins' ) ) {
	
	function rhodos_cf7_tgmpa_required_plugins( $list = array() ) {
		if ( rhodos_storage_isset( 'required_plugins', 'contact-form-7' ) ) {
			// CF7 plugin
			$list[] = array(
				'name'     => rhodos_storage_get_array( 'required_plugins', 'contact-form-7' ),
				'slug'     => 'contact-form-7',
				'required' => false,
			);
		}
		return $list;
	}
}



// Check if cf7 installed and activated
if ( ! function_exists( 'rhodos_exists_cf7' ) ) {
	function rhodos_exists_cf7() {
		return class_exists( 'WPCF7' );
	}
}

// Enqueue custom scripts
if ( ! function_exists( 'rhodos_cf7_frontend_scripts' ) ) {
	
	function rhodos_cf7_frontend_scripts() {
		if ( rhodos_exists_cf7() ) {
			if ( rhodos_is_on( rhodos_get_theme_option( 'debug_mode' ) ) ) {
				$rhodos_url = rhodos_get_file_url( 'plugins/contact-form-7/contact-form-7.js' );
				if ( '' != $rhodos_url ) {
					wp_enqueue_script( 'rhodos-cf7', $rhodos_url, array( 'jquery' ), null, true );
				}
			}
		}
	}
}

// Merge custom scripts
if ( ! function_exists( 'rhodos_cf7_merge_scripts' ) ) {
	
	function rhodos_cf7_merge_scripts( $list ) {
		if ( rhodos_exists_cf7() ) {
			$list[] = 'plugins/contact-form-7/contact-form-7.js';
		}
		return $list;
	}
}

// Merge custom styles
if ( ! function_exists( 'rhodos_cf7_merge_styles' ) ) {
	
	function rhodos_cf7_merge_styles( $list ) {
		if ( rhodos_exists_cf7() ) {
			$list[] = 'plugins/contact-form-7/_contact-form-7.scss';
		}
		return $list;
	}
}

