<?php
// Add plugin-specific colors and fonts to the custom CSS
if ( ! function_exists( 'rhodos_mailchimp_get_css' ) ) {
	add_filter( 'rhodos_filter_get_css', 'rhodos_mailchimp_get_css', 10, 2 );
	function rhodos_mailchimp_get_css( $css, $args ) {

		if ( isset( $css['fonts'] ) && isset( $args['fonts'] ) ) {
			$fonts         = $args['fonts'];
			$css['fonts'] .= <<<CSS
form.mc4wp-form .mc4wp-form-fields input[type="email"] {
	{$fonts['input_font-family']}
	{$fonts['input_font-size']}
	{$fonts['input_font-weight']}
	{$fonts['input_font-style']}
	{$fonts['input_line-height']}
	{$fonts['input_text-decoration']}
	{$fonts['input_text-transform']}
	{$fonts['input_letter-spacing']}
}
form.mc4wp-form .mc4wp-form-fields input[type="submit"] {
	{$fonts['button_font-family']}
	{$fonts['button_font-size']}
	{$fonts['button_font-weight']}
	{$fonts['button_font-style']}
	{$fonts['button_line-height']}
	{$fonts['button_text-decoration']}
	{$fonts['button_text-transform']}
	{$fonts['button_letter-spacing']}
}

CSS;
		}

		if ( isset( $css['vars'] ) && isset( $args['vars'] ) ) {
			$vars = $args['vars'];

			$css['vars'] .= <<<CSS

form.mc4wp-form .mc4wp-form-fields input[type="email"],
form.mc4wp-form .mc4wp-form-fields input[type="submit"] {
	-webkit-border-radius: {$vars['rad']};
	    -ms-border-radius: {$vars['rad']};
			border-radius: {$vars['rad']};
}

CSS;
		}

		if ( isset( $css['colors'] ) && isset( $args['colors'] ) ) {
			$colors         = $args['colors'];
			$css['colors'] .= <<<CSS


form.mc4wp-form  input[type="email"] {
    color: {$colors['input_dark']};
    background-color: transparent;
    border-color: {$colors['input_bd_color']};
}
form.mc4wp-form input[type="email"].filled,
form.mc4wp-form  input[type="email"]:focus {
    background-color: transparent;
    color: {$colors['input_dark']};
    border-color: {$colors['input_bd_hover']};
}
form.mc4wp-form input[type="email"].filled {
    border-color: {$colors['input_bd_color']};
}

form.mc4wp-form input[placeholder]::-webkit-input-placeholder               	{ color: {$colors['input_dark']};  opacity: 1; }
form.mc4wp-form input[placeholder]::-moz-placeholder                         	{ color: {$colors['input_dark']};  opacity: 1; }
form.mc4wp-form input[placeholder]:-ms-input-placeholder                    	{ color: {$colors['input_dark']};  opacity: 1; }
form.mc4wp-form input[placeholder]::placeholder                 				{ color: {$colors['input_dark']};  opacity: 1; }

form.mc4wp-form input[type="checkbox"] + label {
    color: {$colors['text_dark']};
}

form.mc4wp-form .mc4wp-alert {
	background-color: {$colors['text_link']};
	border-color: {$colors['text_hover']};
	color: {$colors['inverse_link']};
}

form.mc4wp-form .mc4wp-alert a {
	color: {$colors['inverse_link']} !important;	
}
form.mc4wp-form .mc4wp-alert a:hover {
	color: {$colors['inverse_link']} !important;	
}


CSS;
		}

		return $css;
	}
}

