<?php
// Add plugin-specific colors and fonts to the custom CSS
if ( ! function_exists( 'rhodos_tribe_events_get_css' ) ) {
	add_filter( 'rhodos_filter_get_css', 'rhodos_tribe_events_get_css', 10, 2 );
	function rhodos_tribe_events_get_css( $css, $args ) {
		if ( isset( $css['fonts'] ) && isset( $args['fonts'] ) ) {
			$fonts         = $args['fonts'];
			$css['fonts'] .= <<<CSS
			
.tribe-events-list .tribe-events-list-event-title {
	{$fonts['h3_font-family']}
}
.tribe-common--breakpoint-medium.tribe-common .tribe-common-form-control-text__input,
.tribe-common .tribe-common-form-control-text__input {
	{$fonts['input_font-family']}
	{$fonts['input_font-size']}
	{$fonts['input_font-weight']}
	{$fonts['input_font-style']}
	{$fonts['input_line-height']}
	{$fonts['input_text-decoration']}
	{$fonts['input_text-transform']}
	{$fonts['input_letter-spacing']}
}

.single-tribe_events a.tribe-events-gcal, 
.single-tribe_events a.tribe-events-gcal:hover, 
.single-tribe_events a.tribe-events-ical,
.single-tribe_events a.tribe-events-ical:hover,
.tribe-events .tribe-events-c-ical__link,
.tribe-common .tribe-common-c-btn, 
.tribe-common a.tribe-common-c-btn,
.tribe-common .tribe-common-c-btn-border,
.tribe-common a.tribe-common-c-btn-border,
#tribe-events .tribe-events-button,
.tribe-events-button,
.tribe-events-cal-links a,
.tribe-events-sub-nav li a {
	{$fonts['button_font-family']}
	{$fonts['button_font-size']}
	{$fonts['button_font-weight']}
	{$fonts['button_font-style']}
	{$fonts['button_line-height']}
	{$fonts['button_text-decoration']}
	{$fonts['button_text-transform']}
	{$fonts['button_letter-spacing']}
}
.tribe-events .tribe-events-c-view-selector__list-item-text,
#tribe-bar-form button, #tribe-bar-form a,
.tribe-events-read-more {
	{$fonts['button_font-family']}
	{$fonts['button_letter-spacing']}
}

.tribe-events .tribe-events-calendar-list__event-date-tag-weekday,
.tribe-common .tribe-common-b3,
.tribe-common .tribe-common-h4,
.tribe-common .tribe-common-h5, .tribe-common .tribe-common-h6,
.tribe-common .tribe-common-h7, .tribe-common .tribe-common-h8,
.tribe-events .datepicker .dow,
.tribe-events .datepicker .datepicker-switch,
.tribe-common .tribe-common-h3,
.tribe-events-calendar td div[id*="tribe-events-daynum-"],
#tribe-bar-views .tribe-bar-views-list .tribe-bar-views-option,
.tribe-bar-mini #tribe-bar-views .tribe-bar-views-list .tribe-bar-views-option,
#tribe-bar-form input, #tribe-bar-form label,
.tribe-events-list .tribe-events-list-separator-month,
.tribe-events-calendar thead th,
.tribe-events-schedule, .tribe-events-schedule h2 {
	{$fonts['h5_font-family']}
}
.tribe-events-calendar-month__day-date,
.tribe-events-calendar-month__day-date-daynum,
.tribe-events .tribe-events-calendar-month__calendar-event-tooltip-datetime,
.tribe-events .tribe-events-calendar-month__multiday-event-hidden-title,
.tribe-common .tribe-common-b2,
.tribe-events .tribe-events-c-messages__message,
.tribe-events .datepicker .day,
.tribe-events .datepicker .month, 
.tribe-events .datepicker .year,
.single-tribe_events #tribe-events-content .tribe-events-event-meta dt,
#tribe-mobile-container .type-tribe_events .tribe-event-date-start,
#tribe-events-content.tribe-events-month,
.tribe-events-notices, .tribe-events-loop .tribe-event-schedule-details,
#tribe-events-content .tribe-events-calendar div[id*="tribe-events-event-"] h3.tribe-events-month-event-title,
#tribe-mobile-container .type-tribe_events, .tribe-events-single-event-description p,
.tribe-events-meta-group dt, .tribe-events-meta-group dd,
.tribe-events-list-widget ol li .tribe-event-title {
	{$fonts['p_font-family']}
}


CSS;
		}

		if ( isset( $css['vars'] ) && isset( $args['vars'] ) ) {
			$vars         = $args['vars'];
			$css['vars'] .= <<<CSS

#tribe-bar-form .tribe-bar-submit input[type="submit"],
#tribe-bar-form button,
#tribe-bar-form a,
#tribe-events .tribe-events-button,
#tribe-bar-views .tribe-bar-views-list,
.tribe-events-button,
.tribe-events-cal-links a,
#tribe-events-footer ~ a.tribe-events-ical.tribe-events-button,
.tribe-events-sub-nav li a {

}

CSS;
		}

		if ( isset( $css['colors'] ) && isset( $args['colors'] ) ) {
			$colors         = $args['colors'];
			$css['colors'] .= <<<CSS


.tribe-events-read-more:after {
   background-color: {$colors['bg_color']};
}
/* Filters bar */
#tribe-bar-form {
	color: {$colors['text_dark']};
}
#tribe-bar-form input[type="text"] {
	color: {$colors['input_text']};
	border-color: {$colors['input_bd_color']}!important;
	background-color: {$colors['input_bg_color']};
}
#tribe-bar-form input[type="text"]:focus {
	color: {$colors['input_dark']};
	border-color: {$colors['input_bd_hover']}!important;
	background-color: {$colors['input_bg_hover']};
}
#tribe-bar-views-toggle {
    color: {$colors['inverse_link']};
    background-color: {$colors['inverse_bg_hover']};
}
#tribe-bar-form.tribe-bar-views-open button#tribe-bar-views-toggle:hover, 
#tribe-bar-form button#tribe-bar-views-toggle {
    -webkit-box-shadow: 0 9px 18px {$colors['inverse_dark_018']};
    -moz-box-shadow: 0 9px 18px {$colors['inverse_dark_018']};
    box-shadow:  0 9px 18px {$colors['inverse_dark_018']};
}

#tribe-bar-form button#tribe-bar-views-toggle:hover {
    -webkit-box-shadow: none;
    -moz-box-shadow: none;
    box-shadow:  none;
}

#tribe-bar-form.tribe-bar-views-open #tribe-bar-views-toggle,
#tribe-bar-views-toggle:hover {
    color: {$colors['inverse_link']};
    background-color: {$colors['inverse_bg_hover']};
}
#tribe-bar-form.tribe-bar-views-open #tribe-bar-views .tribe-bar-views-list {
    -webkit-box-shadow: 0 0 6px {$colors['inverse_dark_01']};
    -moz-box-shadow: 0 0 6px {$colors['inverse_dark_01']};
    box-shadow:  0 0 6px {$colors['inverse_dark_01']};
}

#tribe-bar-views .tribe-bar-views-list .tribe-bar-views-option {
    color: {$colors['text_dark']};
    background: {$colors['alter_bg_color']};
}
#tribe-bar-views .tribe-bar-views-option + .tribe-bar-views-option {
    border-top-color: {$colors['bd_color']};;
}
#tribe-bar-views .tribe-bar-views-option + .tribe-bar-views-option:hover {
    border-top-color: {$colors['inverse_bg_hover']};;
}
#tribe-bar-views .tribe-bar-views-list .tribe-bar-views-option:hover {
    color: {$colors['inverse_link']};
    background-color: {$colors['inverse_bg_hover']};
}
.datepicker thead tr:first-child th:hover, .datepicker tfoot tr th:hover {
	color: {$colors['text_link']};
	background: {$colors['text_dark']};
}
.datepicker .datepicker-switch:hover,
.datepicker .next:hover,
.datepicker .prev:hover, .datepicker tfoot tr th:hover {
    color: {$colors['text_hover']};
}
.datepicker table > tbody > tr:nth-child(2n+1) > td {
    background-color: {$colors['bg_color']};
}
.datepicker table tr td.day.focused,
.datepicker table tr td.day:hover {
    background-color: {$colors['alter_bg_color']};
}
.datepicker table tr td span.focused,
.datepicker table tr td span:hover {
    color: {$colors['text']};
    background: {$colors['alter_bg_color']};
}

.datepicker table tr td span.active.active,
.datepicker table tr td span.active.disabled,
.datepicker table tr td span.active.disabled.active,
.datepicker table tr td span.active.disabled.disabled,
.datepicker table tr td span.active.disabled:active,
.datepicker table tr td span.active.disabled:hover,
.datepicker table tr td span.active.disabled:hover.active,
.datepicker table tr td span.active.disabled:hover.disabled,
.datepicker table tr td span.active.disabled:hover:active,
.datepicker table tr td span.active.disabled:hover:hover,
.datepicker table tr td span.active.disabled:hover[disabled],
.datepicker table tr td span.active.disabled[disabled],
.datepicker table tr td span.active:active,
.datepicker table tr td span.active:hover,
.datepicker table tr td span.active:hover.active,
.datepicker table tr td span.active:hover.disabled,
.datepicker table tr td span.active:hover:active,
.datepicker table tr td span.active:hover:hover,
.datepicker table tr td span.active:hover[disabled],
.datepicker table tr td span.active[disabled] {
    color: {$colors['inverse_link']};
    background-color: {$colors['text_link']};;
}
.datepicker table tr td.active.active,
.datepicker table tr td.active.disabled,
.datepicker table tr td.active.disabled.active,
.datepicker table tr td.active.disabled.disabled,
.datepicker table tr td.active.disabled:active,
.datepicker table tr td.active.disabled:hover,
.datepicker table tr td.active.disabled:hover.active,
.datepicker table tr td.active.disabled:hover.disabled,
.datepicker table tr td.active.disabled:hover:active,
.datepicker table tr td.active.disabled:hover:hover,
.datepicker table tr td.active.disabled:hover[disabled],
.datepicker table tr td.active.disabled[disabled],
.datepicker table tr td.active:active,
.datepicker table tr td.active:hover,
.datepicker table tr td.active:hover.active,
.datepicker table tr td.active:hover.disabled,
.datepicker table tr td.active:hover:active,
.datepicker table tr td.active:hover:hover,
.datepicker table tr td.active:hover[disabled],
.datepicker table tr td.active[disabled] {
    color: {$colors['inverse_link']};
    background-color: {$colors['text_link']};;
}

.datepicker table tr td.active,
.datepicker table tr td.active.disabled,
.datepicker table tr td.active.disabled:hover,
.datepicker table tr td.active:hover {
   color: {$colors['inverse_dark']};
}

/* Notice */
.tribe-events-notices {
    color: {$colors['text']};
    background: {$colors['alter_bg_color']};
    border-color: {$colors['alter_bd_color']};
}
/* Content */
#tribe-events .tribe-events-calendar td.tribe-events-othermonth,
#tribe-events .tribe-grid-allday,
#tribe-events .tribe-events-calendar td:hover {
    background-color: transparent;
}

.tribe-events-calendar thead th {
	color: {$colors['inverse_link']};
	background: {$colors['inverse_bg_hover']} !important;
}
.tribe-events-calendar thead th + th:before {
	background: {$colors['extra_dark']};
}
#tribe-events-content table.tribe-events-calendar {
    border-bottom-color: {$colors['bd_color']};
}

#tribe-events-content .tribe-events-calendar td,
#tribe-events-content .tribe-events-calendar th {
    border-color: {$colors['bd_color']} !important;
}
#tribe-events-content table.tribe-events-calendar > tbody > tr:nth-child(2n+1) > td {
	background-color: {$colors['bg_color']};
}
.tribe-events-calendar td.tribe-events-past div[id*="tribe-events-daynum-"],
.tribe-events-calendar td.tribe-events-past div[id*="tribe-events-daynum-"] > a {
	color: {$colors['text']};
}

#tribe-events-content .tribe-events-calendar td.tribe-events-othermonth:hover div[id*="tribe-events-daynum-"],
#tribe-events-content .tribe-events-calendar td div[id*="tribe-events-daynum-"] {
    color: {$colors['text']};
    background-color: {$colors['alter_bg_color']};
}
#tribe-events-content .tribe-events-calendar td:hover div[id*="tribe-events-daynum-"] {
    color: {$colors['inverse_link']};
    background-color: {$colors['inverse_bg_hover']};
}
#tribe-events-content .tribe-events-calendar td.tribe-events-present.tribe-events-othermonth div[id*="tribe-events-daynum-"],
#tribe-events-content .tribe-events-calendar td.tribe-events-present div[id*="tribe-events-daynum-"] { 
    color: {$colors['inverse_link']};
    background-color: {$colors['text_link']};
}

.tribe-events-calendar td div[id*="tribe-events-daynum-"],
.tribe-events-calendar td div[id*="tribe-events-daynum-"] > a {
	color: {$colors['text_dark']};
	background-color: transparent;
}
.tribe-events-calendar td:hover div[id*="tribe-events-daynum-"],
.tribe-events-calendar td:hover div[id*="tribe-events-daynum-"] > a {
    color: {$colors['inverse_link']};
	background-color: transparent;
}

.tribe-events-calendar td.tribe-events-othermonth {
	color: {$colors['alter_light']};
	background: {$colors['bg_color']} !important;
}
.tribe-events-calendar td.tribe-events-othermonth div[id*="tribe-events-daynum-"],
.tribe-events-calendar td.tribe-events-othermonth div[id*="tribe-events-daynum-"] > a {
	color: {$colors['alter_light']};
}

.tribe-events-calendar td.tribe-events-present div[id*="tribe-events-daynum-"],
.tribe-events-calendar td.tribe-events-present div[id*="tribe-events-daynum-"] > a {
	color: {$colors['inverse_link']};
}
.tribe-events-calendar td.tribe-events-present:before {
	border-color: {$colors['bd_color']};
}
.tribe-events-calendar .tribe-events-has-events:after {
	background-color: {$colors['text']};
}
.tribe-events-calendar .mobile-active.tribe-events-has-events:after {
	background-color: {$colors['text_dark']};
}
#tribe-events-content .tribe-events-calendar td,
#tribe-events-content .tribe-events-calendar div[id*="tribe-events-event-"] h3.tribe-events-month-event-title a {
	color: {$colors['text']};
}
#tribe-events-content .tribe-events-calendar div[id*="tribe-events-event-"] h3.tribe-events-month-event-title a:hover {
	color: {$colors['text_dark']};
}
#tribe-events-content .tribe-events-calendar td.mobile-active,
#tribe-events-content .tribe-events-calendar td.mobile-active:hover {
	color: {$colors['inverse_link']};
	background-color: {$colors['bg_color']};
}
#tribe-events-content .tribe-events-calendar td.mobile-active div[id*="tribe-events-daynum-"] {
	color: {$colors['inverse_link']};
	background-color: {$colors['inverse_bg_color']};
}
#tribe-events-content .tribe-events-calendar td.tribe-events-othermonth.mobile-active div[id*="tribe-events-daynum-"] a,
.tribe-events-calendar .mobile-active div[id*="tribe-events-daynum-"] a {
	background-color: transparent;
	color: {$colors['bg_color']};
}
.events-archive.events-gridview #tribe-events-content table .type-tribe_events {
	border-color: {$colors['bd_color']};
}

/* Tooltip */
.recurring-info-tooltip,
.tribe-events-calendar .tribe-events-tooltip,
.tribe-events-week .tribe-events-tooltip,
.tribe-events-shortcode.view-week .tribe-events-tooltip,
.tribe-events-tooltip .tribe-events-arrow {
	color: {$colors['alter_text']};
	background: {$colors['alter_bg_color']};
	border-color: {$colors['alter_bd_color']};
}
#tribe-events-content .tribe-events-tooltip .summary { 
	color: {$colors['inverse_link']};
	background: {$colors['inverse_bg_hover']};
}
.tribe-events-tooltip .tribe-event-duration {
	color: {$colors['inverse_link_08']};
}

/* Events list */
.tribe-events-list-separator-month {
	color: {$colors['text_dark']};
}
.tribe-events-list-separator-month:after {
	border-color: {$colors['bd_color']};
}
.tribe-events-list .type-tribe_events + .type-tribe_events,
.tribe-events-day .tribe-events-day-time-slot + .tribe-events-day-time-slot + .tribe-events-day-time-slot {
	border-color: {$colors['bd_color']};
}
.tribe-events-day .tribe-events-day-time-slot .tribe-events-day-time-slot-heading {
    color: {$colors['inverse_link']};
	background: {$colors['inverse_bg_color']};
}

.tribe-events-list .tribe-events-event-cost span {
	color: {$colors['extra_dark']};
	border-color: {$colors['extra_bg_color']};
	background: {$colors['extra_bg_color']};
}
.tribe-mobile .tribe-events-loop .tribe-events-event-meta {
	color: {$colors['alter_text']};
	border-color: {$colors['alter_bd_color']};
	background-color: {$colors['alter_bg_color']};
}
.tribe-mobile .tribe-events-loop .tribe-events-event-meta a {
	color: {$colors['alter_link']};
}
.tribe-mobile .tribe-events-loop .tribe-events-event-meta a:hover {
	color: {$colors['alter_hover']};
}
.tribe-mobile .tribe-events-list .tribe-events-venue-details {
	border-color: {$colors['alter_bd_color']};
}

.single-tribe_events #tribe-events-footer,
.tribe-events-day #tribe-events-footer,
.events-list #tribe-events-footer,
.tribe-events-map #tribe-events-footer,
.tribe-events-photo #tribe-events-footer {
	border-color: {$colors['bd_color']};	
}
.tribe-events-list-separator-month span {
	background-color: {$colors['bg_color']};
}

#tribe-events-footer .tribe-events-sub-nav li.tribe-events-nav-previous a,
#tribe-events-footer .tribe-events-sub-nav li.tribe-events-nav-next a {
    color: {$colors['inverse_link']};
    background-color: {$colors['text_link2']};
    -webkit-box-shadow: 0 9px 18px {$colors['text_link2_018']};
    -ms-box-shadow: 0 9px 18px {$colors['text_link2_018']};
    box-shadow: 0 9px 18px {$colors['text_link2_018']};
} 
#tribe-events-footer .tribe-events-sub-nav li.tribe-events-nav-previous a:hover,
#tribe-events-footer .tribe-events-sub-nav li.tribe-events-nav-next a:hover {
    color: {$colors['inverse_link']};
    background-color: {$colors['text_hover2']};
    -webkit-box-shadow: none;
    -ms-box-shadow: none ;
    box-shadow: none;
}


/* Events day */
.tribe-events-day .tribe-events-day-time-slot h5 {
	color: {$colors['bg_color']};
	background: {$colors['text_dark']};
}

/* Single Event */
.single-tribe_events .tribe-events-venue-map {
	color: {$colors['alter_text']};
	border-color: {$colors['alter_bd_hover']};
	background: {$colors['alter_bg_hover']};
}
.single-tribe_events .tribe-events-schedule .tribe-events-cost {
	color: {$colors['text_dark']};
}
.single-tribe_events .type-tribe_events {
	border-color: {$colors['bd_color']};
}

#tribe-bar-collapse-toggle, #tribe-bar-collapse-toggle {
    color: {$colors['inverse_link']};
    background: {$colors['inverse_bg_color']};
}

#tribe-bar-form.tribe-bar-collapse .tribe-bar-filters {
    background: {$colors['alter_bg_color']};
}
.tribe-events-tooltip .tribe-events-arrow {
    border-color: {$colors['bd_color']};
}
#tribe-events-content table.tribe-events-calendar .type-tribe_events.tribe-event-featured {
	background-color: {$colors['text_link']};
}
#tribe-events-content table.tribe-events-calendar .type-tribe_events.tribe-event-featured .tribe-events-month-event-title a {
	color: {$colors['inverse_link']};
}
#tribe-events-content table.tribe-events-calendar .type-tribe_events.tribe-event-featured .tribe-events-month-event-title a:hover {
	color: {$colors['inverse_dark']};
}

.tribe-common .tribe-common-b2 {
	color: {$colors['text']};
}
.tribe-common .tribe-common-b3 {
	color: {$colors['text_dark']};
}
.tribe-common .tribe-common-h4,
.tribe-common .tribe-common-h5, .tribe-common .tribe-common-h6,
.tribe-common .tribe-common-h7, .tribe-common .tribe-common-h8 {
	color: {$colors['text_dark']};
}
.tribe-common .tribe-events-calendar-list__event-title-link {
    color: {$colors['text_dark']};
}
.tribe-common .tribe-events-calendar-list__event-title-link:hover {
    color: {$colors['text_link']};
}
.tribe-common .tribe-events-calendar-list__month-separator:after {
	border-color: {$colors['bd_color']};
}
.tribe-common .tribe-events-calendar-day__event-venue,
.tribe-common .tribe-events-calendar-list__event-venue {
    color: {$colors['text_dark']};
}

.tribe-common .tribe-common-c-btn, 
.tribe-common a.tribe-common-c-btn {
	color: {$colors['inverse_link']};
	border-color: {$colors['text_link']};
	background-color: {$colors['text_link']};
}
.tribe-common .tribe-common-c-btn:hover,
.tribe-common a.tribe-common-c-btn:hover {
	color: {$colors['inverse_link']};
	border-color: {$colors['text_hover']};
	background-color: {$colors['text_hover']};
}
.tribe-events .tribe-events-c-ical__link {
	color: {$colors['inverse_link']};
	border-color: {$colors['text_link']};
	background-color: {$colors['text_link']};
	-webkit-box-shadow: 0 9px 18px {$colors['text_link_018']};
    -ms-box-shadow: 0 9px 18px {$colors['text_link_018']};
    box-shadow: 0 9px 18px {$colors['text_link_018']};
}
.tribe-events .tribe-events-c-ical__link:hover {
	color: {$colors['inverse_link']};
	border-color: {$colors['text_hover']};
	background-color: {$colors['text_hover']};
	-webkit-box-shadow: none;
    -ms-box-shadow: none;
    box-shadow: none;
}
button.tribe-events-c-top-bar__datepicker-button {
	color: {$colors['text_dark']};
	background-color: transparent;
}
.tribe-events .tribe-events-c-view-selector__list-item--active .tribe-events-c-view-selector__list-item-text,
.tribe-events .tribe-events-c-view-selector__list-item-link:focus .tribe-events-c-view-selector__list-item-text, 
.tribe-events .tribe-events-c-view-selector__list-item-link:hover .tribe-events-c-view-selector__list-item-text {
	color: {$colors['text_link']};
}
.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-view-selector--tabs .tribe-events-c-view-selector__list-item--active .tribe-events-c-view-selector__list-item-link:after {
	background-color: {$colors['text_link']};
}
.tribe-common .tribe-common-anchor-alt {
	color: {$colors['text_dark']};
	border-bottom-color: {$colors['text_dark']};
}
.tribe-common .tribe-common-anchor-alt:hover {
	color: {$colors['text_link']};
	border-bottom-color: {$colors['text_link']};
}
.tribe-events .tribe-events-c-events-bar__search-button:before,
.tribe-events .tribe-events-c-view-selector__button:before {
	background-color: {$colors['text_link']};
}
.tribe-events .tribe-events-c-view-selector__content {
	background-color: {$colors['bg_color']};
}
.tribe-events .tribe-events-c-events-bar__search-filters-container,
.tribe-events .tribe-events-c-events-bar {
	background-color: {$colors['bg_color']};
}
.tribe-events .tribe-events-calendar-month__multiday-event-bar-inner,
.tribe-events .tribe-events-calendar-month__multiday-event-bar {
	background-color: {$colors['alter_bg_color']};
	color: {$colors['alter_dark']};
}
.tribe-events .tribe-events-calendar-month__multiday-event-bar .tribe-events-calendar-month__multiday-event-bar-title {
	color: {$colors['alter_dark']};
}
.tribe-events .tribe-events-calendar-month__day--current .tribe-events-calendar-month__day-date,
.tribe-events .tribe-events-calendar-month__day--current .tribe-events-calendar-month__day-date-link {
	color: {$colors['text_link2']};
}
.tribe-events .tribe-events-calendar-month__day--current .tribe-events-calendar-month__day-date-link:active, 
.tribe-events .tribe-events-calendar-month__day--current .tribe-events-calendar-month__day-date-link:focus, 
.tribe-events .tribe-events-calendar-month__day--current .tribe-events-calendar-month__day-date-link:hover {
	color: {$colors['text_hover2']};
}
.tribe-common--breakpoint-medium.tribe-events .tribe-events-calendar-month__day:hover:after {
    background-color:  {$colors['text_link2']};
}
.tribe-events .tribe-events-calendar-month__day-date-link:focus, 
.tribe-events .tribe-events-calendar-month__day-date-link:hover,
.tribe-events .tribe-events-calendar-month__day-date-link:active {
    color: {$colors['text_link2']};
}

.tribe-common .tribe-events-calendar-list__event-datetime {
	color: {$colors['text_light']};
}
.tribe-events .tribe-events-calendar-list-nav li button[disabled] {
	color: {$colors['text_light']} !important;;
}
.tribe-events .tribe-events-calendar-list-nav {
    border-color: {$colors['bd_color']};
}
.tribe-events .tribe-events-c-nav__next, 
.tribe-events .tribe-events-c-nav__prev {
	color: {$colors['text_dark']};
}
.tribe-events .tribe-events-c-nav__next:hover, 
.tribe-events .tribe-events-c-nav__prev:hover {
	color: {$colors['text_link']};
}
.tribe-events .tribe-events-calendar-month__mobile-events-icon--event {
	background-color: {$colors['text_link2']};
}
.tribe-events .tribe-events-calendar-month__day-cell--mobile:focus .tribe-events-calendar-month__mobile-events-icon--event,
.tribe-events .tribe-events-calendar-month__day-cell--mobile:hover .tribe-events-calendar-month__mobile-events-icon--event {
	background-color: {$colors['inverse_link']};
}

.tribe-common--breakpoint-medium.tribe-events .tribe-events-calendar-list__event-datetime-featured-text,
.tribe-common--breakpoint-medium.tribe-events .tribe-events-calendar-day__event-datetime-featured-text {
	color: {$colors['text_dark']};
}
.tribe-events .tribe-events-calendar-list__event-row--featured .tribe-events-calendar-list__event-date-tag-datetime:after,
.tribe-events .tribe-events-calendar-day__event--featured:after{
	background-color: {$colors['text_link']};
}

.tribe-common.tribe-events .tribe-common-c-svgicon{
    color: {$colors['text_link']};
}

.tribe-common button[disabled], .tribe-common input[disabled] {
    color: {$colors['text_light']} !important;
    background-color: transparent !important;
}
.tribe-common .tribe-common-c-btn-border,
.tribe-common a.tribe-common-c-btn-border {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']};
	border-color: {$colors['text_link']};
}
.tribe-common .tribe-common-c-btn-border:hover,
.tribe-common a.tribe-common-c-btn-border:hover {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_hover']};
	border-color: {$colors['text_hover']};
}
.tribe-common--breakpoint-medium.tribe-common .tribe-common-h3 {
	color: {$colors['text_dark']};
	background-color: transparent;
}
.tribe-events .tribe-events-c-view-selector__list-item-text {
	color: {$colors['text_dark']};
}
.tribe-events .tribe-events-c-view-selector__list-item-text:hover {
	color: {$colors['text_link']};
}
.tribe-common  .tribe-events-c-search__input-control--keyword .tribe-events-c-search__input {
	color: {$colors['input_text']};
}
.tribe-common   .tribe-events-c-search__input-control--keyword .tribe-events-c-search__input:focus {
	color: {$colors['input_dark']};
}
.tribe-common  .tribe-events-c-search__input-control--keyword .tribe-events-c-search__input::placeholder {
	color: {$colors['input_text']};
	opacity: 0.6;
}
.tribe-common  .tribe-events-c-search__input-control--keyword .tribe-events-c-search__input::-webkit-input-placeholder {
	color: {$colors['input_text']};
	opacity: 0.6;
}
.tribe-common  .tribe-events-c-search__input-control--keyword .tribe-events-c-search__input::-moz-placeholder{
	color: {$colors['input_text']};
	opacity: 0.6;
}
.tribe-common  .tribe-events-c-search__input-control--keyword .tribe-events-c-search__input::-ms-input-placeholder {
	color: {$colors['input_text']};
	opacity: 0.6;
}
.tribe-events .tribe-events-calendar-list__event-date-tag-weekday {
	color: {$colors['text_dark']};
}

/* Messages */
.tribe-events-c-messages__message {
    color: {$colors['alter_dark']};
	background-color: {$colors['alter_bg_color']};
}
.tribe-common .tribe-events-c-messages__message-list-item-link  {
    color: {$colors['text_dark']};
    border-color: {$colors['text_link']};
}
.tribe-common .tribe-events-c-messages__message-list-item-link:hover  {
    color: {$colors['text_link']};
    border-color: {$colors['text_link']};
}
.tribe-events .tribe-events-header {
	background-color: {$colors['bg_color']};
}

/* Preloader */
.tribe-events .tribe-events-view-loader {
	background-color:{$colors['bg_color_08']};
}
.tribe-common .tribe-common-c-loader__dot {
	background-color: {$colors['text_link2']};
}


/* DatePicker 5.0 */
.tribe-events .datepicker {
    border-color: {$colors['bd_color']};
	background-color: {$colors['bg_color']};
}
.tribe-events .datepicker table th {
	background-color: transparent;
}
.tribe-events .datepicker .datepicker-switch {
    color: {$colors['text_dark']};
}
.tribe-events .datepicker .datepicker-switch:focus,
.tribe-events .datepicker .datepicker-switch:hover {
	color: {$colors['text_dark']};
}
.tribe-events .datepicker .datepicker-switch:active,
.tribe-events .datepicker .datepicker-switch:focus,
.tribe-events .datepicker .datepicker-switch:hover,
.tribe-events .datepicker .next:active, 
.tribe-events .datepicker .next:focus, 
.tribe-events .datepicker .next:hover, 
.tribe-events .datepicker .prev:active, 
.tribe-events .datepicker .prev:focus, 
.tribe-events .datepicker .prev:hover {
    background-color: transparent;
}
.tribe-events .datepicker .past {
    opacity: 0.6;
}
.tribe-events .datepicker .day,
.tribe-events .datepicker .month,
.tribe-events .datepicker .year,
.tribe-events .datepicker .dow {
	color: {$colors['text_dark']};
}

.tribe-events .datepicker .day.active,
.tribe-events .datepicker .day.active.focused,
.tribe-events .datepicker .day.active:focus, 
.tribe-events .datepicker .day.active:hover,
.tribe-events .datepicker .month.active, 
.tribe-events .datepicker .month.active.focused, 
.tribe-events .datepicker .month.active:focus, 
.tribe-events .datepicker .month.active:hover, 
.tribe-events .datepicker .year.active, 
.tribe-events .datepicker .year.active.focused, 
.tribe-events .datepicker .year.active:focus, 
.tribe-events .datepicker .year.active:hover {
	background-color: {$colors['text_link']};
}
.tribe-events .datepicker .day.focused, 
.tribe-events .datepicker .day:focus, 
.tribe-events .datepicker .day:hover, 
.tribe-events .datepicker .month.focused, 
.tribe-events .datepicker .month:focus, 
.tribe-events .datepicker .month:hover, 
.tribe-events .datepicker .year.focused, 
.tribe-events .datepicker .year:focus, 
.tribe-events .datepicker .year:hover {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']};
}

.tribe-events .datepicker .day.current, 
.tribe-events .datepicker .day.current.focused,
.tribe-events .datepicker .day.current:focus,
.tribe-events .datepicker .day.current:hover,
.tribe-events .datepicker .month.current, 
.tribe-events .datepicker .month.current.focused, 
.tribe-events .datepicker .month.current:focus, 
.tribe-events .datepicker .month.current:hover,
.tribe-events .datepicker .year.current, 
.tribe-events .datepicker .year.current.focused,
.tribe-events .datepicker .year.current:focus,
.tribe-events .datepicker .year.current:hover {
    color: {$colors['alter_dark']};
	background-color: {$colors['alter_bg_color']};
}

/* Tooltip */
.tooltipster-base.tribe-events-tooltip-theme {
    border-color:  {$colors['bd_color']};
    background-color: {$colors['bg_color']};
}
.tribe-events .tribe-events-calendar-month__calendar-event-tooltip-datetime {
    color: {$colors['text_light']};
}   
.tribe-events  tribe-events-calendar-month__calendar-event-tooltip-title {
    color: {$colors['text_dark']};
}
.tribe-events .tribe-events-calendar-month__calendar-event-tooltip-title-link {
    color: {$colors['text_dark']};
}
.tribe-events .tribe-events-calendar-month__calendar-event-tooltip-title-link:active,
.tribe-events .tribe-events-calendar-month__calendar-event-tooltip-title-link:focus,
.tribe-events .tribe-events-calendar-month__calendar-event-tooltip-title-link:hover {
    color: {$colors['text_link']};
}
.tribe-events .tribe-events-calendar-month__calendar-event-tooltip-description {
    color: {$colors['text']};
}
.tribe-events .tribe-events-c-view-selector__list-item--active .tribe-events-c-view-selector__list-item-link {
	background-color: {$colors['alter_bg_color']};
}
.tribe-events-calendar-month__body button {
    color: {$colors['text_dark']};
	background-color: {$colors['bg_color']};
	border: none;
	box-shadow: none;
}
.tribe-events .tribe-events-calendar-month__day-cell--mobile:focus,
.tribe-events .tribe-events-calendar-month__day-cell--mobile:hover {
    color: {$colors['inverse_link']};
	background-color: {$colors['text_link2']};
}
.tribe-events .tribe-events-calendar-month__day-cell--mobile:focus .tribe-events-calendar-month__day-date-daynum,
.tribe-events .tribe-events-calendar-month__day-cell--mobile:hover .tribe-events-calendar-month__day-date-daynum {
    color: {$colors['inverse_link']};
}
.tribe-events-calendar-month-mobile-events__mobile-event .tribe-events-calendar-month-mobile-events__mobile-event-datetime {
    color: {$colors['text_light']};
}
.tribe-events .tribe-events-calendar-day__event-datetime {
    color: {$colors['text_light']};
}
.tribe-events .tribe-events-calendar-month-mobile-events .tribe-events-calendar-month-nav .tribe-events-c-nav__today {
    color: {$colors['text_dark']};
}
.tribe-events .tribe-events-calendar-month-mobile-events .tribe-events-calendar-month-nav .tribe-events-c-nav__today:hover {
    color: {$colors['text_link']};
}
.tribe-events .tribe-events-c-nav__list-item--today .tribe-events-c-nav__today {
    color: {$colors['text_dark']};
}
.tribe-events .tribe-events-c-nav__list-item--today .tribe-events-c-nav__today:hover {
    color: {$colors['text_link']};
}
.tribe-events .tribe-events-c-nav {
    border-color: {$colors['bd_color']};
}
.tribe-events .tribe-events-calendar-day__time-separator:after, 
.tribe-events .tribe-events-calendar-day__type-separator:after {
    border-color: {$colors['bd_color']};
}
.tribe-events .tribe-events-calendar-month-mobile-events__mobile-event-title-link {
    color: {$colors['text_dark']};
}
.tribe-events .tribe-events-calendar-month-mobile-events__mobile-event-title-link:active, 
.tribe-events .tribe-events-calendar-month-mobile-events__mobile-event-title-link:focus,
.tribe-events .tribe-events-calendar-month-mobile-events__mobile-event-title-link:hover {
    color: {$colors['text_link']};
}

CSS;
		}

		return $css;
	}
}

