<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0
 */

if ( rhodos_sidebar_present() ) {
	ob_start();
	$rhodos_sidebar_name = rhodos_get_theme_option( 'sidebar_widgets' );
	rhodos_storage_set( 'current_sidebar', 'sidebar' );
	if ( is_active_sidebar( $rhodos_sidebar_name ) ) {
		dynamic_sidebar( $rhodos_sidebar_name );
	}
	$rhodos_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $rhodos_out ) ) {
		$rhodos_sidebar_position = rhodos_get_theme_option( 'sidebar_position' );
		?>
		<div class="sidebar widget_area
			<?php
			echo esc_attr( $rhodos_sidebar_position );
			if ( ! rhodos_is_inherit( rhodos_get_theme_option( 'sidebar_scheme' ) ) ) {
				echo ' scheme_' . esc_attr( rhodos_get_theme_option( 'sidebar_scheme' ) );
			}
			?>
		" role="complementary">
		<?php
			// Single posts banner before sidebar
			rhodos_show_post_banner( 'sidebar' ); ?>
			<div class="sidebar_inner">
				<?php
				do_action( 'rhodos_action_before_sidebar' );
				rhodos_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $rhodos_out ) );
				do_action( 'rhodos_action_after_sidebar' );
				?>
			</div><!-- /.sidebar_inner -->
		</div><!-- /.sidebar -->
		<div class="clearfix"></div>
		<?php
	}
}
