<?php
/**
 * Skins support: Main skin file for the skin 'Business Coach'
 *
 * Setup skin-dependent fonts and colors, load scripts and styles,
 * and other operations that affect the appearance and behavior of the theme
 * when the skin is activated
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0.46
 */


// Theme init priorities:
// 3 - add/remove Theme Options elements
if ( ! function_exists( 'rhodos_skin_theme_setup3' ) ) {
	add_action( 'after_setup_theme', 'rhodos_skin_theme_setup3', 3 );
	function rhodos_skin_theme_setup3() {
		// ToDo: Add / Modify theme options, required plugins, etc.

        rhodos_storage_set(
            'schemes', array(

                // Color scheme: 'default'
                'default' => array(
                    'title'    => esc_html__( 'Default', 'rhodos' ),
                    'internal' => true,
                    'colors'   => array(

                        // Whole block border and background
                        'bg_color'         => '#ffffff', 
                        'bd_color'         => '#e0e0e0', 

                        // Text and links colors
                        'text'             => '#646464', 
                        'text_light'       => '#878787', 
                        'text_dark'        => '#121619', 
                        'text_link'        => '#ed6240', 
                        'text_hover'       => '#d43b2a', 
                        'text_link2'       => '#6dc579', 
                        'text_hover2'      => '#5db469', 
                        'text_link3'       => '#b5c2c8', 
                        'text_hover3'      => '#99a8af', 

                        // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                        'alter_bg_color'   => '#f4f7f9', 
                        'alter_bg_hover'   => '#e6e8eb', 
                        'alter_bd_color'   => '#e0e0e0', 
                        'alter_bd_hover'   => '#dadada',
                        'alter_text'       => '#646464', 
                        'alter_light'      => '#878787', 
                        'alter_dark'       => '#121619', 
                        'alter_link'       => '#ed6240', 
                        'alter_hover'      => '#d43b2a', 
                        'alter_link2'      => '#6dc579', 
                        'alter_hover2'     => '#5db469', 
                        'alter_link3'      => '#b5c2c8', 
                        'alter_hover3'     => '#99a8af', 

                        // Extra blocks (submenu, tabs, color blocks, etc.)
                        'extra_bg_color'   => '#121619', 
                        'extra_bg_hover'   => '#28272e',
                        'extra_bd_color'   => '#2e3337', 
                        'extra_bd_hover'   => '#3d3d3d',
                        'extra_text'       => '#646464', 
                        'extra_light'      => '#878787', 
                        'extra_dark'       => '#ffffff', 
                        'extra_link'       => '#121619', 
                        'extra_hover'      => '#ed6240', 
                        'extra_link2'      => '#cacaca', 
                        'extra_hover2'     => '#ed6240', 
                        'extra_link3'      => '#ddb837',
                        'extra_hover3'     => '#eec432',

                        // Input fields (form's fields and textarea)
                        'input_bg_color'   => '#ffffff', 
                        'input_bg_hover'   => '#ffffff', 
                        'input_bd_color'   => '#dfdfdf', 
                        'input_bd_hover'   => '#c5c5c5', 
                        'input_text'       => '#646464', 
                        'input_light'      => '#646464', 
                        'input_dark'       => '#646464', 

                        // Inverse blocks (text and links on the 'text_link' background)
                        'inverse_bg_color' => '#b5c2c8', 
                        'inverse_bg_hover' => '#191d1f', 
                        'inverse_bd_color' => '#e0e0e0', 
                        'inverse_bd_hover' => '#2e3337', 
                        'inverse_text'     => '#ffffff', 
                        'inverse_light'    => '#333333',
                        'inverse_dark'     => '#121619', 
                        'inverse_link'     => '#ffffff', 
                        'inverse_hover'    => '#ffffff', 
                        'inverse_link2'    => '#ffffff', 
                    ),
                ),

                // Color scheme: 'dark'
                'dark'    => array(
                    'title'    => esc_html__( 'Dark', 'rhodos' ),
                    'internal' => true,
                    'colors'   => array(

                        // Whole block border and background
                        'bg_color'         => '#1a1e20', 
                        'bd_color'         => '#232629', 

                        // Text and links colors
                        'text'             => '#eff3f5', 
                        'text_light'       => '#eff3f5', 
                        'text_dark'        => '#ffffff', 
                        'text_link'        => '#ed6240', 
                        'text_hover'       => '#d43b2a', 
                        'text_link2'       => '#6dc579', 
                        'text_hover2'      => '#5db469', 
                        'text_link3'       => '#b5c2c8',
                        'text_hover3'      => '#99a8af', 

                        // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                        'alter_bg_color'   => '#121619', 
                        'alter_bg_hover'   => '#26292b', 
                        'alter_bd_color'   => '#303537', 
                        'alter_bd_hover'   => '#4a4a4a',
                        'alter_text'       => '#cacaca', 
                        'alter_light'      => '#eff3f5', 
                        'alter_dark'       => '#ffffff', 
                        'alter_link'       => '#ed6240', 
                        'alter_hover'      => '#d43b2a', 
                        'alter_link2'      => '#6dc579', 
                        'alter_hover2'     => '#5db469', 
                        'alter_link3'      => '#b5c2c8', 
                        'alter_hover3'     => '#99a8af', 

                        // Extra blocks (submenu, tabs, color blocks, etc.)
                        'extra_bg_color'   => '#121619', 
                        'extra_bg_hover'   => '#f4f5f7', 
                        'extra_bd_color'   => '#ebebeb', 
                        'extra_bd_hover'   => '#4a4a4a',
                        'extra_text'       => '#646464', 
                        'extra_light'      => '#eff3f5', 
                        'extra_dark'       => '#121619', 
                        'extra_link'       => '#ffffff', 
                        'extra_hover'      => '#ffffff', 
                        'extra_link2'      => '#cacaca', 
                        'extra_hover2'     => '#ed6240', 
                        'extra_link3'      => '#ddb837',
                        'extra_hover3'     => '#eec432',

                        // Input fields (form's fields and textarea)
                        'input_bg_color'   => '#1a1e20', 
                        'input_bg_hover'   => '#121619', 
                        'input_bd_color'   => '#b2e4dc', 
                        'input_bd_hover'   => '#c2d6d3', 
                        'input_text'       => '#cacaca', 
                        'input_light'      => '#cacaca', 
                        'input_dark'       => '#ffffff', 

                        // Inverse blocks (text and links on the 'text_link' background)
                        'inverse_bg_color' => '#b5c2c8', 
                        'inverse_bg_hover' => '#ed6240', 
                        'inverse_bd_color' => '#cfd8dc', 
                        'inverse_bd_hover' => '#2c3345', 
                        'inverse_text'     => '#f4f4f4', 
                        'inverse_light'    => '#6f6f6f',
                        'inverse_dark'     => '#121619', 
                        'inverse_link'     => '#ffffff', 
                        'inverse_hover'    => '#121619', 
                        'inverse_link2'    => '#191e2d', 
                    ),
                ),

            )
        );

	}
}

// Shortcodes support
//------------------------------------------------------------------------

// Add new output types (layouts) in the shortcodes
if ( ! function_exists( 'rhodos_skin_trx_addons_sc_type' ) ) {
    add_filter( 'trx_addons_sc_type', 'rhodos_skin_trx_addons_sc_type', 10, 2 );
    function rhodos_skin_trx_addons_sc_type( $list, $sc ) {      
        if ( 'trx_sc_services' == $sc ) {
            $list['extra'] = 'Extra';
        }
        if ( 'trx_sc_icons' == $sc ) {
            $list['extra'] = 'Extra';
        }
        return $list;
    }
}
// Add new params to the default shortcode's atts
if ( ! function_exists( 'rhodos_skin_trx_addons_sc_atts' ) ) {
    add_filter( 'trx_addons_sc_atts', 'rhodos_skin_trx_addons_sc_atts', 10, 2 );
    function rhodos_skin_trx_addons_sc_atts( $atts, $sc ) {
        // Param 'icon_button'
        if ( 'trx_sc_services' == $sc ) {
            $atts['icon_button'] = '';
        }
        if ('trx_sc_icons' == $sc ) {
            $atts['alter_icon_bg'] = '';
        }

        return $atts;
    }
}

// Add theme-specific controls to sections and columns
if ( ! function_exists( 'rhodos_skin_elm_add_icon_button_control' ) ) {
    add_action( 'elementor/element/before_section_end', 'rhodos_skin_elm_add_icon_button_control', 10, 3 );
    function rhodos_skin_elm_add_icon_button_control( $element, $section_id ) {
        if (!is_object($element)) return;
        $el_name = $element->get_name();

        if ( 'trx_sc_services' == $el_name && 'section_sc_services_details' === $section_id ) {
            $element->add_control(
                'icon_button', array(
                    'type'         => \Elementor\Controls_Manager::SWITCHER,
                    'label'        => esc_html__( 'Icon Button', 'rhodos' ),
                    'description' => wp_kses_data( __('If the option is enabled, the button will be displayed instead of More text', 'rhodos') ),
                    'label_off'    => esc_html__( 'Off', 'rhodos' ),
                    'label_on'     => esc_html__( 'On', 'rhodos' ),
                    'return_value' => '1',
                    'condition' => [
                        'type' => ['extra'],
                    ],
                )
            );
        }
    }
}
// Add theme-specific controls to sections and columns
if ( ! function_exists( 'rhodos_skin_elm_add_alter_icon_bg_control' ) ) {
    add_action( 'elementor/element/after_section_start', 'rhodos_skin_elm_add_alter_icon_bg_control', 10, 3 );
    function rhodos_skin_elm_add_alter_icon_bg_control( $element, $section_id ) {
        if (!is_object($element)) return;
        $el_name = $element->get_name();

        if ( 'trx_sc_icons' == $el_name && 'section_sc_icons' === $section_id ) {
            $element->add_control(
                'alter_icon_bg', array(
                    'type'         => \Elementor\Controls_Manager::SWITCHER,
                    'label'        => esc_html__( 'Alternative Icon Background', 'rhodos' ),
                    'description' => wp_kses_data( __('If the option is enabled, use alternative icon background', 'rhodos') ),
                    'label_off'    => esc_html__( 'Off', 'rhodos' ),
                    'label_on'     => esc_html__( 'On', 'rhodos' ),
                    'return_value' => '1',
                    'condition' => [
                        'type' => ['extra'],
                    ],
                )
            );
        }

    }
}



//------------------------------------------------------------------------
// One-click import support
//------------------------------------------------------------------------

// Set theme specific importer options
if ( ! function_exists( 'rhodos_skin_importer_set_options' ) ) {
    add_filter('trx_addons_filter_importer_options', 'rhodos_skin_importer_set_options', 9);
    function rhodos_skin_importer_set_options($options = array()) {
        if (is_array($options)) {
            // Business Coach demo
            $options['demo_type'] = 'business-coach';
            $options['files']['business-coach'] = $options['files']['default'];
            $options['files']['business-coach']['title'] = esc_html__('Business Coach Demo', 'rhodos');
            $options['files']['business-coach']['domain_demo'] = esc_url( rhodos_get_protocol() . '://business-coach.rhodos.axiomthemes.com' );   // Demo-site domain
            unset($options['files']['default']);
        }
        return $options;
    }
}

// Filter to add in the required plugins list
if ( ! function_exists( 'rhodos_skin_tgmpa_required_plugins' ) ) {
	add_filter( 'rhodos_filter_tgmpa_required_plugins', 'rhodos_skin_tgmpa_required_plugins' );
	function rhodos_skin_tgmpa_required_plugins( $list = array() ) {
		// ToDo: Check if plugin is in the 'required_plugins' and add his parameters to the TGMPA-list
		//       Replace 'skin-specific-plugin-slug' to the real slug of the plugin
		if ( rhodos_storage_isset( 'required_plugins', 'skin-specific-plugin-slug' ) ) {
			$list[] = array(
				'name'     => rhodos_storage_get_array( 'required_plugins', 'skin-specific-plugin-slug' ),
				'slug'     => 'skin-specific-plugin-slug',
				'required' => false,
			);
		}
		return $list;
	}
}

// Enqueue skin-specific styles and scripts
// Priority 1150 - after plugins-specific (1100), but before child theme (1200)
if ( ! function_exists( 'rhodos_skin_frontend_scripts' ) ) {
	add_action( 'wp_enqueue_scripts', 'rhodos_skin_frontend_scripts', 1150 );
	function rhodos_skin_frontend_scripts() {
		$rhodos_url = rhodos_get_file_url( RHODOS_SKIN_DIR . 'skin.css' );
		if ( '' != $rhodos_url ) {
			wp_enqueue_style( 'rhodos-skin-' . esc_attr( RHODOS_SKIN_NAME ), $rhodos_url, array(), null );
		}
		if ( rhodos_is_on( rhodos_get_theme_option( 'debug_mode' ) ) ) {
			$rhodos_url = rhodos_get_file_url( RHODOS_SKIN_DIR . 'skin.js' );
			if ( '' != $rhodos_url ) {
				wp_enqueue_script( 'rhodos-skin-' . esc_attr( RHODOS_SKIN_NAME ), $rhodos_url, array( 'jquery' ), null, true );
			}
		}
	}
}

// Enqueue skin-specific responsive styles
// Priority 2050 - after theme responsive 2000
if ( ! function_exists( 'rhodos_skin_styles_responsive' ) ) {
	add_action( 'wp_enqueue_scripts', 'rhodos_skin_styles_responsive', 2050 );
	function rhodos_skin_styles_responsive() {
		$rhodos_url = rhodos_get_file_url( RHODOS_SKIN_DIR . 'skin-responsive.css' );
		if ( '' != $rhodos_url ) {
			wp_enqueue_style( 'rhodos-skin-' . esc_attr( RHODOS_SKIN_NAME ) . '-responsive', $rhodos_url, array(), null );
		}
	}
}

// Merge custom scripts
if ( ! function_exists( 'rhodos_skin_merge_scripts' ) ) {
	add_filter( 'rhodos_filter_merge_scripts', 'rhodos_skin_merge_scripts' );
	function rhodos_skin_merge_scripts( $list ) {
		if ( rhodos_get_file_dir( RHODOS_SKIN_DIR . 'skin.js' ) != '' ) {
			$list[] = RHODOS_SKIN_DIR . 'skin.js';
		}
		return $list;
	}
}


// Add slin-specific colors and fonts to the custom CSS
require_once RHODOS_THEME_DIR . RHODOS_SKIN_DIR . 'skin-styles.php';

