<?php
// Add skin-specific colors and fonts to the custom CSS
if ( ! function_exists( 'rhodos_skin_get_css' ) ) {
	add_filter( 'rhodos_filter_get_css', 'rhodos_skin_get_css', 10, 2 );
	function rhodos_skin_get_css( $css, $args ) {

		if ( isset( $css['fonts'] ) && isset( $args['fonts'] ) ) {
			$fonts         = $args['fonts'];
			$css['fonts'] .= <<<CSS
			.sc_skills_decoration_counter .sc_skills_item_title,
			.sc_skills_decoration_counter .sc_skills_total  {
			    	{$fonts['h5_font-family']}
			}

CSS;
		}

		if ( isset( $css['vars'] ) && isset( $args['vars'] ) ) {
			$vars         = $args['vars'];
			$css['vars'] .= <<<CSS

CSS;
		}

		if ( isset( $css['colors'] ) && isset( $args['colors'] ) ) {
			$colors         = $args['colors'];
			$css['colors'] .= <<<CSS
			
			
		/* Icons */	
		.sc_icons_extra .sc_icons_item {
		    border-color: {$colors['inverse_bd_color']};
		}
		/* Skills */
		.sc_skills_decoration_counter .sc_skills_icon {
		     color: {$colors['text_link']};
		}
	    .sc_skills_decoration_counter  .sc_skills_item_title {
	         border-color: {$colors['bd_color']};
	    }
					
		/* Revolution Slider */	
		/* bullets */
		rs-module .custom .tp-bullet {
		   background: {$colors['inverse_link']}!important;
		}
		rs-module .custom .tp-bullet:hover,
		rs-module .custom .tp-bullet.selected {
		    background: {$colors['text_link']}!important;
		}
		
		/* arrows */
		rs-module .custom.tparrows {
            background: {$colors['bg_color']}!important;
        }
		rs-module .custom.tp-leftarrow.tparrows {
            background: {$colors['alter_bg_color']}!important;
        }
        rs-module .custom.tparrows:hover {
            background: {$colors['text_link3']}!important;
        }
		rs-module .custom.tparrows:before {
            color: {$colors['text_dark']}!important;
        }
        rs-module .custom.tparrows:hover:before {
            color: {$colors['inverse_link']}!important;
        }
				
		/* MailChimp */	
		.mc4wp-form input[type="checkbox"] + label > a {
		    color: {$colors['text_dark']};
		}
		
		/* Single */	
		.scheme_self.author_info {
            color: {$colors['text_dark']};
            background-color: {$colors['text_link3']};
        }
        .scheme_self.author_info a  {
            color: {$colors['inverse_link']};
        }
        .scheme_self.author_info a:hover  {
            color: {$colors['inverse_link_08']};
        }
        /* Messages */
        .trx_addons_field_error, .wpcf7-not-valid {
             border-color: {$colors['text_link']} !important;
        }
        span.wpcf7-not-valid-tip {
            color: {$colors['text_link']};
        }
        div.wpcf7-validation-errors, div.wpcf7-acceptance-missing {
            border-color: {$colors['text_link']};
        }
        div.wpcf7-mail-sent-ok {
            border-color: {$colors['text_link2']};
        }
        .trx_addons_message_box_error {
            border-color: {$colors['text_link']};
        }
        .trx_addons_message_box_success {
            border-color: {$colors['text_link2']};
        }
        form .error_field {
            border-color: {$colors['text_link']} !important;
        }
        /* Wooc Message */
        .woocommerce .woocommerce-error {
	        border-top-color: {$colors['alter_link']};
        }
        .woocommerce .woocommerce-error:before {
	        color: {$colors['alter_link']};
        }       
        
}
        

CSS;
		}

		return $css;
	}
}

