<?php
// Add skin-specific colors and fonts to the custom CSS
if ( ! function_exists( 'rhodos_skin_get_css' ) ) {
	add_filter( 'rhodos_filter_get_css', 'rhodos_skin_get_css', 10, 2 );
	function rhodos_skin_get_css( $css, $args ) {

		if ( isset( $css['fonts'] ) && isset( $args['fonts'] ) ) {
			$fonts         = $args['fonts'];
			$css['fonts'] .= <<<CSS

CSS;
		}

		if ( isset( $css['vars'] ) && isset( $args['vars'] ) ) {
			$vars         = $args['vars'];
			$css['vars'] .= <<<CSS

CSS;
		}

		if ( isset( $css['colors'] ) && isset( $args['colors'] ) ) {
			$colors         = $args['colors'];
			$css['colors'] .= <<<CSS
			
			
			/* Revolution Slider */	
			/* bullets */
            rs-module .custom .tp-bullet {
               background: {$colors['inverse_link']};
            }
            rs-module .custom .tp-bullet:hover,
            rs-module .custom .tp-bullet.selected {
                background: {$colors['text_link']};
            }
		
			/* Services */
			.sc_services_hover .sc_services_item_number,
			.sc_services_hover .sc_services_item_subtitle {
			    color: {$colors['inverse_light']};
			}
			.sc_services_hover .sc_services_item_icon {
			    color: {$colors['inverse_link']};
			}
			.sc_services_hover .sc_services_item_price {
			    color: {$colors['inverse_link']};
			}
			.sc_services_hover .sc_services_item_link:after {
			    border-color: {$colors['inverse_link']};
			}
			.sc_services_hover .sc_services_item.with_image .sc_services_item_header:before,
			.sc_services_hover .sc_services_item.with_image .sc_services_item_content:before {
                background: transparent;
            }
			.sc_services_hover .sc_services_item.with_image:hover .sc_services_item_header:before,
			.sc_services_hover .sc_services_item.with_image:hover .sc_services_item_content:before {
                background: transparent;
            }
            .sc_services_hover .sc_services_item.with_image .sc_services_item_header:after,
            .sc_services_hover .sc_services_item.with_image:hover .sc_services_item_header:after {
                background: {$colors['text_link']};
            }`
            /* Specific Color */
            .sc_services_hover [class*="trx_addons_column-"]:nth-child(2n+1) .sc_services_item_header.specific_color:after {
                background: {$colors['text_link2']}; !important;
                color: {$colors['inverse_link']}; !important;;
            }
            
            /* MailChimp */
            form.mc4wp-form input[type="email"] {
                color: {$colors['input_text']};
                background-color:  {$colors['input_bg_color']};
                border-color: {$colors['input_bd_color']};
            }
            form.mc4wp-form input[type="email"].filled,
            form.mc4wp-form input[type="email"]:focus {
                color: {$colors['input_dark']};
                background-color: {$colors['input_bg_hover']};
                border-color:  {$colors['input_bd_hover']};
            }
            
            form.mc4wp-form input[type="checkbox"] + label:before {
                border-color:  {$colors['bd_color']} !important;
            }
            form.mc4wp-form input[type="checkbox"] + label {
                color: {$colors['text_dark']};
            }
            form.mc4wp-form input[type="checkbox"] + label > a {
                color: {$colors['text_dark']};
            }
            form.mc4wp-form input[type="checkbox"] + label > a:hover {
                color: {$colors['text_dark']};
            }
            
            .light_text_gdpr form.mc4wp-form input[type="checkbox"] + label:before {
              border-color:  {$colors['inverse_link']} !important;
            }
            .light_text_gdpr form.mc4wp-form input[type="checkbox"] + label {
                color: {$colors['inverse_link']};
            }
            .light_text_gdpr form.mc4wp-form input[type="checkbox"] + label > a {
                color: {$colors['inverse_link']};
            }
            .light_text_gdpr form.mc4wp-form input[type="checkbox"] + label > a:hover {
                color: {$colors['inverse_link']};
            }
            
            form.mc4wp-form .mc4wp_button {
                color: {$colors['text_dark']};
                background-color: transparent;
            }
            form.mc4wp-form .mc4wp_button:before {
                border-color:  {$colors['bd_color']};
            }
            form.mc4wp-form .mc4wp_button:after {
               color: {$colors['text_dark']};
            }
            form.mc4wp-form .mc4wp_button:hover:after {
               color: {$colors['text_link']};
            }
            /* Elementor Toggle */
            .elementor-toggle .elementor-tab-content {
                color: {$colors['text']};
            }
            .elementor-toggle .elementor-tab-title {
                color: {$colors['text_dark']};
                border-color: {$colors['alter_bg_color']};
                background-color: {$colors['alter_bg_color']};
            }
            .elementor-toggle .elementor-tab-title.elementor-active {
                color: {$colors['inverse_link']};
                border-color: {$colors['extra_bg_color']};
                background-color: {$colors['extra_bg_color']};
            }

            
		
CSS;
		}

		return $css;
	}
}

