<?php
// Add skin-specific colors and fonts to the custom CSS
if ( ! function_exists( 'rhodos_skin_get_css' ) ) {
	add_filter( 'rhodos_filter_get_css', 'rhodos_skin_get_css', 10, 2 );
	function rhodos_skin_get_css( $css, $args ) {

		if ( isset( $css['fonts'] ) && isset( $args['fonts'] ) ) {
			$fonts         = $args['fonts'];
			$css['fonts'] .= <<<CSS
			
			.sc_skills_extra_counter .sc_skills_item_title,
			.sc_skills_extra_counter .sc_skills_total  {
			    	{$fonts['h5_font-family']}
			}

CSS;
		}

		if ( isset( $css['vars'] ) && isset( $args['vars'] ) ) {
			$vars         = $args['vars'];
			$css['vars'] .= <<<CSS

CSS;
		}

		if ( isset( $css['colors'] ) && isset( $args['colors'] ) ) {
			$colors         = $args['colors'];
			$css['colors'] .= <<<CSS
			
			/* Revolution Slider */
            /* bullets */
            rs-module .custom .tp-bullet {
                background: {$colors['inverse_link']};
            }
            rs-module .custom .tp-bullet:hover,
            rs-module .custom .tp-bullet.selected {
                background: {$colors['text_link']};
            }
            /* Icons */
            .sc_icons_extra .sc_icons_item {
                border-color: {$colors['bd_color']};
            }
            /* Testimonials */
            .color_style_link2 .sc_testimonials_item_author_title {
                color: {$colors['text_dark']};
            }
            /* Toggle */
             .elementor-toggle .elementor-tab-title.elementor-active {
                color: {$colors['text_dark']};
                background-color: transparent;
                border-color: transparent;
             }
             .elementor-toggle .elementor-toggle-item + .elementor-toggle-item .elementor-tab-title {
                 border-color: {$colors['inverse_bd_color']};
             }
             /* Contact Form 7 */
             .wpcf7 .extra_form input[type="text"],
             .wpcf7 .extra_form input[type="email"],
             .wpcf7 .extra_form input[type="tel"],
             .wpcf7 .extra_form input[type="url"],
             .wpcf7 .extra_form input[type="number"],
             .wpcf7 .extra_form textarea {
                color: {$colors['input_text']};
                background-color: {$colors['input_bg_color']};
                border-color: {$colors['input_bg_color']};
                -webkit-box-shadow: 0 0 28px {$colors['inverse_bg_color_008']};
                -moz-box-shadow: 0 0 28px {$colors['inverse_bg_color_008']};
                box-shadow: 0 0 28px {$colors['inverse_bg_color_008']};
              }
             .wpcf7 .extra_form input[type="text"]:focus,
             .wpcf7 .extra_form input[type="email"]:focus,
             .wpcf7 .extra_form input[type="tel"]:focus,
             .wpcf7 .extra_form input[type="url"]:focus,
             .wpcf7 .extra_form input[type="number"]:focus,
             .wpcf7 .extra_form textarea:focus {
                color: {$colors['input_text']};
                background-color: {$colors['input_bg_color']};
                border-color: {$colors['input_bg_color']};
                -webkit-box-shadow: 0 0 28px {$colors['inverse_bg_color_01']};
                -moz-box-shadow: 0 0 28px {$colors['inverse_bg_color_01']};
                box-shadow: 0 0 28px {$colors['inverse_bg_color_01']};
              }
     
             	
CSS;
		}

		return $css;
	}
}

