<?php
// Add skin-specific colors and fonts to the custom CSS
if ( ! function_exists( 'rhodos_skin_get_css' ) ) {
	add_filter( 'rhodos_filter_get_css', 'rhodos_skin_get_css', 10, 2 );
	function rhodos_skin_get_css( $css, $args ) {

		if ( isset( $css['fonts'] ) && isset( $args['fonts'] ) ) {
			$fonts         = $args['fonts'];
			$css['fonts'] .= <<<CSS
			
			.sc_skills_extra_counter .sc_skills_item_title {
			    {$fonts['p_font-family']}
			}
			.sc_skills_extra_counter .sc_skills_total {
			     {$fonts['h5_font-family']}
			}

CSS;
		}

		if ( isset( $css['vars'] ) && isset( $args['vars'] ) ) {
			$vars         = $args['vars'];
			$css['vars'] .= <<<CSS

CSS;
		}

		if ( isset( $css['colors'] ) && isset( $args['colors'] ) ) {
			$colors         = $args['colors'];
			$css['colors'] .= <<<CSS
			
			/* MailChimp */
			form.mc4wp-form input[type="checkbox"] + label > a {
			    color: {$colors['inverse_link']};
			}
			
			/* Elementor Toggle */
            .elementor-toggle .elementor-tab-content {
                color: {$colors['text']};
            }
            .elementor-toggle .elementor-tab-title {
                color: {$colors['text_dark']};
                border-color: {$colors['alter_bg_color']};
                background-color: {$colors['alter_bg_color']};
            }
            .elementor-toggle .elementor-tab-title.elementor-active {
                color: {$colors['inverse_link']};
                border-color: {$colors['inverse_bg_color']};
                background-color: {$colors['inverse_bg_color']};
            }
            
            /* Testimonials */
            .sc_testimonials_alter .sc_testimonials_item_content {
                background-color: {$colors['bg_color']};
            }
            .sc_testimonials_alter  .sc_testimonials_item_content:after {
                border-top-color: {$colors['bg_color']};
            }
            .sc_testimonials_alter .slider_container .sc_testimonials_item_content:before {
                color: {$colors['bd_color']};
            }
            .sc_testimonials_alter .slider_container .slider-slide.swiper-slide-active + .swiper-slide .sc_testimonials_item_content:before {
                color: {$colors['text_link']};
            }
            .sc_testimonials_alter.color_style_link2 .slider_container .slider-slide.swiper-slide-active + .swiper-slide .sc_testimonials_item_content:before {
                color: {$colors['text_link2']};
            }
            .sc_testimonials_alter.color_style_link2  .sc_testimonials_item_author_title {
                color: {$colors['text_dark']};
            }
            .sc_testimonials_alter.color_style_link3 .slider_container .slider-slide.swiper-slide-active + .swiper-slide .sc_testimonials_item_content:before {
                color: {$colors['text_link3']};
            }
            .sc_testimonials_alter.color_style_dark .slider_container .slider-slide.swiper-slide-active + .swiper-slide .sc_testimonials_item_content:before {
                color: {$colors['text_dark']};
            }
            /* List Style */
            ul[class*="trx_addons_list"] > li:before {
                 color: {$colors['text_link3']};
            }
            /* Counter */
            .sc_skills_extra_counter .sc_skills_item_title { 
                 color: {$colors['text']};
            }
            /* Blogger */
            .sc_blogger_extra .sc_blogger_item {
                background-color: transparent;
            }
            .sc_blogger_extra .sc_blogger_item .sc_blogger_item_content_wrapper {
                background-color: {$colors['bg_color']};
            }
            /* Form Messages */
            span.wpcf7-not-valid-tip {
                color: {$colors['text_link']};
            }
             div.wpcf7-validation-errors, 
             div.wpcf7-acceptance-missing {
              border-color: {$colors['text_link']};
            }
            .trx_addons_field_error, 
            .wpcf7-not-valid {
                 border-color: {$colors['text_link']} !important;
            }  
            div.wpcf7-mail-sent-ok {
                 border-color: {$colors['text_link3']}
            }
            .trx_addons_message_box_error {
                border-color: {$colors['text_link']};
            }
            .trx_addons_message_box_success {
                border-color: {$colors['text_link3']};
            }
            form .error_field {
                border-color: {$colors['text_link']} !important;
            }
           

CSS;
		}

		return $css;
	}
}

