<?php
/**
 * The template to display Admin notices
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0.1
 */

$rhodos_theme_obj = wp_get_theme();
?>
<div class="rhodos_admin_notice rhodos_welcome_notice update-nag">
	<?php
	// Theme image
	$rhodos_theme_img = rhodos_get_file_url( 'screenshot.jpg' );
	if ( '' != $rhodos_theme_img ) {
		?>
		<div class="rhodos_notice_image"><img src="<?php echo esc_url( $rhodos_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'rhodos' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="rhodos_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'rhodos' ),
				$rhodos_theme_obj->name . ( RHODOS_THEME_FREE ? ' ' . __( 'Free', 'rhodos' ) : '' ),
				$rhodos_theme_obj->version
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="rhodos_notice_text">
		<p class="rhodos_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $rhodos_theme_obj->description ) );
			?>
		</p>
		<p class="rhodos_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'rhodos' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="rhodos_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=rhodos_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'rhodos' );
			?>
		</a>
		<?php		
		// Dismiss this notice
		?>
		<a href="#" class="rhodos_hide_notice"><i class="dashicons dashicons-dismiss"></i> <span class="rhodos_hide_notice_text"><?php esc_html_e( 'Dismiss', 'rhodos' ); ?></span></a>
	</div>
</div>
