<?php
/**
 * The template to display default site footer
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0.10
 */

$rhodos_footer_id = rhodos_get_custom_footer_id();
$rhodos_footer_meta = get_post_meta( $rhodos_footer_id, 'trx_addons_options', true );
if ( ! empty( $rhodos_footer_meta['margin'] ) ) {
	rhodos_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( rhodos_prepare_css_value( $rhodos_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $rhodos_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $rhodos_footer_id ) ) ); ?>
						<?php
						if ( ! rhodos_is_inherit( rhodos_get_theme_option( 'footer_scheme' ) ) ) {
							echo ' scheme_' . esc_attr( rhodos_get_theme_option( 'footer_scheme' ) );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'rhodos_action_show_layout', $rhodos_footer_id );
	?>
</footer><!-- /.footer_wrap -->
