<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0.10
 */

// Footer sidebar
$rhodos_footer_name    = rhodos_get_theme_option( 'footer_widgets' );
$rhodos_footer_present = ! rhodos_is_off( $rhodos_footer_name ) && is_active_sidebar( $rhodos_footer_name );
if ( $rhodos_footer_present ) {
	rhodos_storage_set( 'current_sidebar', 'footer' );
	$rhodos_footer_wide = rhodos_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $rhodos_footer_name ) ) {
		dynamic_sidebar( $rhodos_footer_name );
	}
	$rhodos_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $rhodos_out ) ) {
		$rhodos_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $rhodos_out );
		$rhodos_need_columns = true;  
		if ( $rhodos_need_columns ) {
			$rhodos_columns = max( 0, (int) rhodos_get_theme_option( 'footer_columns' ) );
			if ( 0 == $rhodos_columns ) {
				$rhodos_columns = min( 4, max( 1, substr_count( $rhodos_out, '<aside ' ) ) );
			}
			if ( $rhodos_columns > 1 ) {
				$rhodos_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $rhodos_columns ) . ' widget', $rhodos_out );
			} else {
				$rhodos_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $rhodos_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $rhodos_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $rhodos_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'rhodos_action_before_sidebar' );
				rhodos_show_layout( $rhodos_out );
				do_action( 'rhodos_action_after_sidebar' );
				if ( $rhodos_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $rhodos_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
