<?php
/**
 * The template to display default site header
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0
 */

$rhodos_header_css   = '';
$rhodos_header_image = get_header_image();
$rhodos_header_video = rhodos_get_header_video();
if ( ! empty( $rhodos_header_image ) && rhodos_trx_addons_featured_image_override( is_singular() || rhodos_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$rhodos_header_image = rhodos_get_current_mode_image( $rhodos_header_image );
}

?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $rhodos_header_image ) || ! empty( $rhodos_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $rhodos_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $rhodos_header_image ) {
		echo ' ' . esc_attr( rhodos_add_inline_css_class( 'background-image: url(' . esc_url( $rhodos_header_image ) . ');' ) );
	}
	if ( is_single() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	if ( rhodos_is_on( rhodos_get_theme_option( 'header_fullheight' ) ) ) {
		echo ' header_fullheight rhodos-full-height';
	}
	if ( ! rhodos_is_inherit( rhodos_get_theme_option( 'header_scheme' ) ) ) {
		echo ' scheme_' . esc_attr( rhodos_get_theme_option( 'header_scheme' ) );
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $rhodos_header_video ) ) {
		get_template_part( apply_filters( 'rhodos_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	if ( rhodos_get_theme_option( 'menu_style' ) == 'top' ) {
		get_template_part( apply_filters( 'rhodos_filter_get_template_part', 'templates/header-navi' ) );
	}

	// Mobile header
	if ( rhodos_is_on( rhodos_get_theme_option( 'header_mobile_enabled' ) ) ) {
		get_template_part( apply_filters( 'rhodos_filter_get_template_part', 'templates/header-mobile' ) );
	}

	// Page title and breadcrumbs area
	get_template_part( apply_filters( 'rhodos_filter_get_template_part', 'templates/header-title' ) );

	// Header widgets area
	get_template_part( apply_filters( 'rhodos_filter_get_template_part', 'templates/header-widgets' ) );

	// Display featured image in the header on the single posts
	// Comment next line to prevent show featured image in the header area
	// and display it in the post's content
	get_template_part( apply_filters( 'rhodos_filter_get_template_part', 'templates/header-single' ) );

	?>
</header>
