<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0
 */

// Page (category, tag, archive, author) title

if ( rhodos_need_page_title() ) {
	rhodos_sc_layouts_showed( 'title', true );
	rhodos_sc_layouts_showed( 'postmeta', false );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( false && is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								rhodos_show_post_meta(
									apply_filters(
										'rhodos_filter_post_meta_args', array(
											'components' => rhodos_array_get_keys_by_value( rhodos_get_theme_option( 'meta_parts' ) ),
											'counters'   => rhodos_array_get_keys_by_value( rhodos_get_theme_option( 'counters' ) ),
											'seo'        => rhodos_is_on( rhodos_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$rhodos_blog_title           = rhodos_get_blog_title();
							$rhodos_blog_title_text      = '';
							$rhodos_blog_title_class     = '';
							$rhodos_blog_title_link      = '';
							$rhodos_blog_title_link_text = '';
							if ( is_array( $rhodos_blog_title ) ) {
								$rhodos_blog_title_text      = $rhodos_blog_title['text'];
								$rhodos_blog_title_class     = ! empty( $rhodos_blog_title['class'] ) ? ' ' . $rhodos_blog_title['class'] : '';
								$rhodos_blog_title_link      = ! empty( $rhodos_blog_title['link'] ) ? $rhodos_blog_title['link'] : '';
								$rhodos_blog_title_link_text = ! empty( $rhodos_blog_title['link_text'] ) ? $rhodos_blog_title['link_text'] : '';
							} else {
								$rhodos_blog_title_text = $rhodos_blog_title;
							}
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr( $rhodos_blog_title_class ); ?>">
								<?php
								$rhodos_top_icon = rhodos_get_category_icon();
								if ( ! empty( $rhodos_top_icon ) ) {
									$rhodos_attr = rhodos_getimagesize( $rhodos_top_icon );
									?>
									<img src="<?php echo esc_url( $rhodos_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'rhodos' ); ?>"
										<?php
										if ( ! empty( $rhodos_attr[3] ) ) {
											rhodos_show_layout( $rhodos_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_post( $rhodos_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $rhodos_blog_title_link ) && ! empty( $rhodos_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $rhodos_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $rhodos_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( is_category() || is_tag() || is_tax() ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

                        // Breadcrumbs
                        if (rhodos_exists_trx_addons()) {
                            ?><div class="sc_layouts_title_breadcrumbs"><?php
                            do_action( 'rhodos_action_breadcrumbs');
                            ?></div><?php
                        }?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
?>
