<?php
/**
 * The template to display the background video in the header
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0.14
 */
$rhodos_header_video = rhodos_get_header_video();
$rhodos_embed_video  = '';
if ( ! empty( $rhodos_header_video ) && ! rhodos_is_from_uploads( $rhodos_header_video ) ) {
	if ( rhodos_is_youtube_url( $rhodos_header_video ) && preg_match( '/[=\/]([^=\/]*)$/', $rhodos_header_video, $matches ) && ! empty( $matches[1] ) ) {
		?><div id="background_video" data-youtube-code="<?php echo esc_attr( $matches[1] ); ?>"></div>
		<?php
	} else {
		global $wp_embed;
		if ( false && is_object( $wp_embed ) ) {
			$rhodos_embed_video = do_shortcode( $wp_embed->run_shortcode( '[embed]' . trim( $rhodos_header_video ) . '[/embed]' ) );
			$rhodos_embed_video = rhodos_make_video_autoplay( $rhodos_embed_video );
		} else {
			$rhodos_header_video = str_replace( '/watch?v=', '/embed/', $rhodos_header_video );
			$rhodos_header_video = rhodos_add_to_url(
				$rhodos_header_video, array(
					'feature'        => 'oembed',
					'controls'       => 0,
					'autoplay'       => 1,
					'showinfo'       => 0,
					'modestbranding' => 1,
					'wmode'          => 'transparent',
					'enablejsapi'    => 1,
					'origin'         => home_url(),
					'widgetid'       => 1,
				)
			);
			$rhodos_embed_video  = '<iframe src="' . esc_url( $rhodos_header_video ) . '" width="1170" height="658" allowfullscreen="0" frameborder="0"></iframe>';
		}
		?>
		<div id="background_video"><?php rhodos_show_layout( $rhodos_embed_video ); ?></div>
		<?php
	}
}
