<?php
/**
 * Setup theme-specific fonts and colors
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0.22
 */

// If this theme is a free version of premium theme
if ( ! defined( 'RHODOS_THEME_FREE' ) ) {
	define( 'RHODOS_THEME_FREE', false );
}
if ( ! defined( 'RHODOS_THEME_FREE_WP' ) ) {
	define( 'RHODOS_THEME_FREE_WP', false );
}

// If this theme uses multiple skins
if ( ! defined( 'RHODOS_ALLOW_SKINS' ) ) {
	define( 'RHODOS_ALLOW_SKINS', true );
}
if ( ! defined( 'RHODOS_DEFAULT_SKIN' ) ) {
	define( 'RHODOS_DEFAULT_SKIN', 'default' );
}

// Theme storage
// Attention! Must be in the global namespace to compatibility with WP CLI
$GLOBALS['RHODOS_STORAGE'] = array(

	// Theme required plugin's slugs
	'required_plugins'   => array_merge(

		// List of plugins for both - FREE and PREMIUM versions
		//-----------------------------------------------------
		array(
			// Required plugins
			// DON'T COMMENT OR REMOVE NEXT LINES!
			'trx_addons'         => esc_html__( 'ThemeREX Addons', 'rhodos' ),
			'trx_updater'         => esc_html__( 'ThemeREX Updater', 'rhodos' ),

			// Recommended (supported) plugins for both (lite and full) versions
			// If plugin not need - comment (or remove) it
			'elementor'          => esc_html__( 'Elementor', 'rhodos' ),
			'contact-form-7'     => esc_html__( 'Contact Form 7', 'rhodos' ),
			'mailchimp-for-wp'   => esc_html__( 'MailChimp for WP', 'rhodos' ),
			'woocommerce'        => esc_html__( 'WooCommerce', 'rhodos' ),
			'elegro-payment'     => esc_html__( 'Elegro Crypto Payment', 'rhodos' ),
			'wp-gdpr-compliance' => esc_html__( 'WP GDPR Compliance', 'rhodos' ),
		),
		// List of plugins for the FREE version only
		//-----------------------------------------------------
		RHODOS_THEME_FREE
			? array(
				// Recommended (supported) plugins for the FREE (lite) version
			)

		// List of plugins for the PREMIUM version only
		//-----------------------------------------------------
			: array(
				// Recommended (supported) plugins for the PRO (full) version
				// If plugin not need - comment (or remove) it
				'essential-grid'             => esc_html__( 'Essential Grid', 'rhodos' ),
			    'the-events-calendar'        => esc_html__( 'The Events Calendar', 'rhodos' ),
                'booked'                     => esc_html__( 'Booked Appointments', 'rhodos' ),
                'revslider'                  => esc_html__( 'Revolution Slider', 'rhodos' ),
			)
	),

	// Theme-specific blog layouts
	'blog_styles'        => array_merge(
		// Layouts for both - FREE and PREMIUM versions
		//-----------------------------------------------------
		array(
			'excerpt' => array(
				'title'   => esc_html__( 'Standard', 'rhodos' ),
				'archive' => 'index-excerpt',
				'item'    => 'content-excerpt',
				'styles'  => 'excerpt',
			),
			'classic' => array(
				'title'   => esc_html__( 'Classic', 'rhodos' ),
				'archive' => 'index-classic',
				'item'    => 'content-classic',
				'columns' => array( 2, 3 ),
				'styles'  => 'classic',
			),
		),
		// Layouts for the FREE version only
		//-----------------------------------------------------
		RHODOS_THEME_FREE
		? array()

		// Layouts for the PREMIUM version only
		//-----------------------------------------------------
		: array(
			'masonry'   => array(
				'title'   => esc_html__( 'Masonry', 'rhodos' ),
				'archive' => 'index-classic',
				'item'    => 'content-classic',
				'columns' => array( 2, 3 ),
				'styles'  => 'masonry',
			),
			'portfolio' => array(
				'title'   => esc_html__( 'Portfolio', 'rhodos' ),
				'archive' => 'index-portfolio',
				'item'    => 'content-portfolio',
				'columns' => array( 2, 3, 4 ),
				'styles'  => 'portfolio',
			),
			'gallery'   => array(
				'title'   => esc_html__( 'Gallery', 'rhodos' ),
				'archive' => 'index-portfolio',
				'item'    => 'content-portfolio-gallery',
				'columns' => array( 2, 3, 4 ),
				'styles'  => array( 'portfolio', 'gallery' ),
			),
			'chess'     => array(
				'title'   => esc_html__( 'Chess', 'rhodos' ),
				'archive' => 'index-chess',
				'item'    => 'content-chess',
				'columns' => array( 1, 2, 3 ),
				'styles'  => 'chess',
			),
		)
	),

	// Key validator: market[env|loc]-vendor[axiom|ancora|themerex]
	'theme_pro_key'      => 'env-axiom',

	// Theme-specific URLs (will be escaped in place of the output)
	'theme_demo_url'     => rhodos_get_protocol() . '://rhodos.axiomthemes.com/',
	'theme_doc_url'      => rhodos_get_protocol() . '://rhodos.axiomthemes.com/doc',
	'theme_download_url' => rhodos_get_protocol() . '://1.envato.market/c/1262870/275988/4415?subId1=axioma&u=themeforest.net/item/rhodos-a-colossal-multipurpose-wordpress-theme-for-business-portfolio/23113690',
	'theme_support_url'  => rhodos_get_protocol() . '://themerex.net/support/',                                   // Axiom
	'theme_video_url'    => rhodos_get_protocol() . '://www.youtube.com/channel/UCBjqhuwKj3MfE3B6Hg2oA8Q',  // Axiom
	
	// Comma separated slugs of theme-specific categories (for get relevant news in the dashboard widget)
	// (i.e. 'children,kindergarten')
	'theme_categories'   => '',

	// Responsive resolutions
	// Parameters to create css media query: min, max
	'responsive'         => array(
		// By device
		'wide'     => array(
			'min' => 2160
		),
		'desktop'  => array(
			'min' => 1680,
			'max' => 2159,
		),
		'notebook' => array(
			'min' => 1280,
			'max' => 1679,
		),
		'tablet'   => array(
			'min' => 768,
			'max' => 1279,
		),
		'mobile'   => array( 'max' => 767 ),
		// By size
        'xxxl'     => array( 'min' => 1979 ),
		'xxl'      => array( 'max' => 1679 ),
		'xl'       => array( 'max' => 1439 ),
		'lg'       => array( 'max' => 1279 ),
		'bg'       => array( 'max' => 1139 ),
		'md'       => array( 'max' => 1023 ),
		'sm'       => array( 'max' => 767 ),
		'sm_wp'    => array( 'max' => 600 ),
		'xs'       => array( 'max' => 479 ),
	),
);

// Theme init priorities:
// Action 'after_setup_theme'
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options. Attention! After this step you can use only basic options (not overriden)
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
// Action 'wp_loaded'
// 1 - detect override mode. Attention! Only after this step you can use overriden options (separate values for the shop, courses, etc.)

if ( ! function_exists( 'rhodos_customizer_theme_setup1' ) ) {
	add_action( 'after_setup_theme', 'rhodos_customizer_theme_setup1', 1 );
	function rhodos_customizer_theme_setup1() {

		// -----------------------------------------------------------------
		// -- ONLY FOR PROGRAMMERS, NOT FOR CUSTOMER
		// -- Internal theme settings
		// -----------------------------------------------------------------
		rhodos_storage_set(
			'settings', array(

				'duplicate_options'      => 'child',            // none  - use separate options for the main and the child-theme
																// child - duplicate theme options from the main theme to the child-theme only
																// both  - sinchronize changes in the theme options between main and child themes

				'customize_refresh'      => 'auto',             // Refresh method for preview area in the Appearance - Customize:
																// auto - refresh preview area on change each field with Theme Options
																// manual - refresh only obn press button 'Refresh' at the top of Customize frame

				'max_load_fonts'         => 5,                  // Max fonts number to load from Google fonts or from uploaded fonts

				'comment_after_name'     => true,               // Place 'comment' field after the 'name' and 'email'

				'icons_selector'         => 'internal',         // Icons selector in the shortcodes:
																// internal - internal popup with plugin's or theme's icons list (fast and support images and svg)

				'icons_type'             => 'icons',            // Type of icons (if 'icons_selector' is 'internal'):
																// icons  - use font icons to present icons
																// images - use images from theme's folder trx_addons/css/icons.png
																// svg    - use svg from theme's folder trx_addons/css/icons.svg

				'socials_type'           => 'icons',            // Type of socials icons (if 'icons_selector' is 'internal'):
																// icons  - use font icons to present social networks
																// images - use images from theme's folder trx_addons/css/icons.png
																// svg    - use svg from theme's folder trx_addons/css/icons.svg

				'check_min_version'      => true,               // Check if exists a .min version of .css and .js and return path to it
																// instead the path to the original file
																// (if debug_mode is off and modification time of the original file < time of the .min file)

				'autoselect_menu'        => false,              // Show any menu if no menu selected in the location 'main_menu'
																// (for example, the theme is just activated)

				'disable_jquery_ui'      => false,              // Prevent loading custom jQuery UI libraries in the third-party plugins

				'use_mediaelements'      => true,               // Load script "Media Elements" to play video and audio

				'tgmpa_upload'           => false,              // Allow upload not pre-packaged plugins via TGMPA

				'allow_no_image'         => false,              // Allow use image placeholder if no image present in the blog, related posts, post navigation, etc.

				'separate_schemes'       => true,               // Save color schemes to the separate files __color_xxx.css (true) or append its to the __custom.css (false)

				'allow_fullscreen'       => false,              // Allow cases 'fullscreen' and 'fullwide' for the body style in the Theme Options
																// In the Page Options this styles are present always
																// (can be removed if filter 'rhodos_filter_allow_fullscreen' return false)

				'attachments_navigation' => false,              // Add arrows on the single attachment page to navigate to the prev/next attachment
				
				'gutenberg_safe_mode'    => array('elementor'), // vc,elementor - Prevent simultaneous editing of posts for Gutenberg and other PageBuilders (VC, Elementor)

				'allow_gutenberg_blocks' => false,              // Allow our shortcodes and widgets as blocks in the Gutenberg (not ready yet - in the development now)

				'subtitle_above_title'   => true,               // Put subtitle above the title in the shortcodes

				'add_hide_on_xxx' => 'replace',                 // Add our breakpoints to the Responsive section of each element
																// 'add' - add our breakpoints after Elementor's
																// 'replace' - add our breakpoints instead Elementor's
																// 'none' - don't add our breakpoints (using only Elementor's)
			)
		);

		// -----------------------------------------------------------------
		// -- Theme fonts (Google and/or custom fonts)
		// -----------------------------------------------------------------

		// Fonts to load when theme start
		// It can be Google fonts or uploaded fonts, placed in the folder /css/font-face/font-name inside the theme folder
		// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
		// For example: font name 'TeX Gyre Termes', folder 'TeX-Gyre-Termes'
		rhodos_storage_set(
			'load_fonts', array(
				// Google font
				array(
                    'name'   => 'Hind',
                    'family' => 'sans-serif',
                    'styles' => '300,400,500,600,700',   // Parameter 'style' used only for the Google fonts
                ),
                array(
                    'name'   => 'Barlow',
                    'family' => 'sans-serif',
                    'styles' => '300,300italic,400,400italic,500,500italic,600,600italic,700,700italic', // Parameter 'style' used only for the Google fonts
                ),
			)
		);

		// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
		rhodos_storage_set( 'load_fonts_subset', 'latin,latin-ext' );

		rhodos_storage_set(
			'theme_fonts', array(
				'p'       => array(
					'title'           => esc_html__( 'Main text', 'rhodos' ),
					'description'     => esc_html__( 'Font settings of the main text of the site. Attention! For correct display of the site on mobile devices, use only units "rem", "em" or "ex"', 'rhodos' ),
					'font-family'     => '"Hind",sans-serif',
					'font-size'       => '1rem',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.822em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '',
					'margin-top'      => '0em',
					'margin-bottom'   => '1.8em',
				),
				'h1'      => array(
					'title'           => esc_html__( 'Heading 1', 'rhodos' ),
					'font-family'     => '"Barlow",sans-serif',
					'font-size'       => '2.529em',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '1em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '-1px',
					'margin-top'      => '1.8417em',
					'margin-bottom'   => '0.9255em',
				),
				'h2'      => array(
					'title'           => esc_html__( 'Heading 2', 'rhodos' ),
					'font-family'     => '"Barlow",sans-serif',
					'font-size'       => '2.176em',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '0.988em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '-0.8px',
					'margin-top'      => '1.6255em',
					'margin-bottom'   => '0.7619em',
				),
				'h3'      => array(
					'title'           => esc_html__( 'Heading 3', 'rhodos' ),
					'font-family'     => '"Barlow",sans-serif',
					'font-size'       => '2.000em',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '1.025em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '-0.7px',
					'margin-top'      => '1.5125em',
					'margin-bottom'   => '0.7879em',
				),
				'h4'      => array(
					'title'           => esc_html__( 'Heading 4', 'rhodos' ),
					'font-family'     => '"Barlow",sans-serif',
					'font-size'       => '1.588em',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '0.988em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '2em',
					'margin-bottom'   => '0.9288em',
				),
				'h5'      => array(
					'title'           => esc_html__( 'Heading 5', 'rhodos' ),
					'font-family'     => '"Barlow",sans-serif',
					'font-size'       => '1.294em',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '1.145em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '2.455em',
					'margin-bottom'   => '1.3em',
				),
				'h6'      => array(
					'title'           => esc_html__( 'Heading 6', 'rhodos' ),
					'font-family'     => '"Barlow",sans-serif',
					'font-size'       => '1.059em',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '1.2706em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '-0.4px',
					'margin-top'      => '2.3255em',
					'margin-bottom'   => '0.8699em',
				),
				'logo'    => array(
					'title'           => esc_html__( 'Logo text', 'rhodos' ),
					'description'     => esc_html__( 'Font settings of the text case of the logo', 'rhodos' ),
					'font-family'     => '"Barlow",sans-serif',
					'font-size'       => '1.588em',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '1.25em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '0px',
				),
				'button'  => array(
					'title'           => esc_html__( 'Buttons', 'rhodos' ),
					'font-family'     => '"Barlow",sans-serif',
					'font-size'       => '15px',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '23px',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0',
				),
				'input'   => array(
					'title'           => esc_html__( 'Input fields', 'rhodos' ),
					'description'     => esc_html__( 'Font settings of the input fields, dropdowns and textareas', 'rhodos' ),
					'font-family'     => '"Barlow",sans-serif',
					'font-size'       => '12px',
					'font-weight'     => '500',
					'font-style'      => 'normal',
					'line-height'     => '1.5em', 
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '1.5px',
				),
				'info'    => array(
					'title'           => esc_html__( 'Post meta', 'rhodos' ),
					'description'     => esc_html__( 'Font settings of the post meta: date, counters, share, etc.', 'rhodos' ),
					'font-family'     => '"Barlow",sans-serif',
					'font-size'       => '12px',
					'font-weight'     => '500',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '1px',
					'margin-top'      => '',
					'margin-bottom'   => '2em',
				),
				'menu'    => array(
					'title'           => esc_html__( 'Main menu', 'rhodos' ),
					'description'     => esc_html__( 'Font settings of the main menu items', 'rhodos' ),
					'font-family'     => '"Barlow",sans-serif',
					'font-size'       => '1em',
					'font-weight'     => '500',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'submenu' => array(
					'title'           => esc_html__( 'Dropdown menu', 'rhodos' ),
					'description'     => esc_html__( 'Font settings of the dropdown menu items', 'rhodos' ),
					'font-family'     => '"Barlow",sans-serif',
					'font-size'       => '0.941em',
					'font-weight'     => '500',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
			)
		);

		// -----------------------------------------------------------------
		// -- Theme colors for customizer
		// -- Attention! Inner scheme must be last in the array below
		// -----------------------------------------------------------------
		rhodos_storage_set(
			'scheme_color_groups', array(
				'main'    => array(
					'title'       => esc_html__( 'Main', 'rhodos' ),
					'description' => esc_html__( 'Colors of the main content area', 'rhodos' ),
				),
				'alter'   => array(
					'title'       => esc_html__( 'Alter', 'rhodos' ),
					'description' => esc_html__( 'Colors of the alternative blocks (sidebars, etc.)', 'rhodos' ),
				),
				'extra'   => array(
					'title'       => esc_html__( 'Extra', 'rhodos' ),
					'description' => esc_html__( 'Colors of the extra blocks (dropdowns, price blocks, table headers, etc.)', 'rhodos' ),
				),
				'inverse' => array(
					'title'       => esc_html__( 'Inverse', 'rhodos' ),
					'description' => esc_html__( 'Colors of the inverse blocks - when link color used as background of the block (dropdowns, blockquotes, etc.)', 'rhodos' ),
				),
				'input'   => array(
					'title'       => esc_html__( 'Input', 'rhodos' ),
					'description' => esc_html__( 'Colors of the form fields (text field, textarea, select, etc.)', 'rhodos' ),
				),
			)
		);
		rhodos_storage_set(
			'scheme_color_names', array(
				'bg_color'    => array(
					'title'       => esc_html__( 'Background color', 'rhodos' ),
					'description' => esc_html__( 'Background color of this block in the normal state', 'rhodos' ),
				),
				'bg_hover'    => array(
					'title'       => esc_html__( 'Background hover', 'rhodos' ),
					'description' => esc_html__( 'Background color of this block in the hovered state', 'rhodos' ),
				),
				'bd_color'    => array(
					'title'       => esc_html__( 'Border color', 'rhodos' ),
					'description' => esc_html__( 'Border color of this block in the normal state', 'rhodos' ),
				),
				'bd_hover'    => array(
					'title'       => esc_html__( 'Border hover', 'rhodos' ),
					'description' => esc_html__( 'Border color of this block in the hovered state', 'rhodos' ),
				),
				'text'        => array(
					'title'       => esc_html__( 'Text', 'rhodos' ),
					'description' => esc_html__( 'Color of the plain text inside this block', 'rhodos' ),
				),
				'text_dark'   => array(
					'title'       => esc_html__( 'Text dark', 'rhodos' ),
					'description' => esc_html__( 'Color of the dark text (bold, header, etc.) inside this block', 'rhodos' ),
				),
				'text_light'  => array(
					'title'       => esc_html__( 'Text light', 'rhodos' ),
					'description' => esc_html__( 'Color of the light text (post meta, etc.) inside this block', 'rhodos' ),
				),
				'text_link'   => array(
					'title'       => esc_html__( 'Link', 'rhodos' ),
					'description' => esc_html__( 'Color of the links inside this block', 'rhodos' ),
				),
				'text_hover'  => array(
					'title'       => esc_html__( 'Link hover', 'rhodos' ),
					'description' => esc_html__( 'Color of the hovered state of links inside this block', 'rhodos' ),
				),
				'text_link2'  => array(
					'title'       => esc_html__( 'Link 2', 'rhodos' ),
					'description' => esc_html__( 'Color of the accented texts (areas) inside this block', 'rhodos' ),
				),
				'text_hover2' => array(
					'title'       => esc_html__( 'Link 2 hover', 'rhodos' ),
					'description' => esc_html__( 'Color of the hovered state of accented texts (areas) inside this block', 'rhodos' ),
				),
				'text_link3'  => array(
					'title'       => esc_html__( 'Link 3', 'rhodos' ),
					'description' => esc_html__( 'Color of the other accented texts (buttons) inside this block', 'rhodos' ),
				),
				'text_hover3' => array(
					'title'       => esc_html__( 'Link 3 hover', 'rhodos' ),
					'description' => esc_html__( 'Color of the hovered state of other accented texts (buttons) inside this block', 'rhodos' ),
				),
			)
		);
		rhodos_storage_set(
			'schemes', array(

				// Color scheme: 'default'
				'default' => array(
					'title'    => esc_html__( 'Default', 'rhodos' ),
					'internal' => true,
					'colors'   => array(

						// Whole block border and background
						'bg_color'         => '#ffffff', //ok
						'bd_color'         => '#e0e0e0', //ok

						// Text and links colors
						'text'             => '#646464', //ok
						'text_light'       => '#878787', //ok
						'text_dark'        => '#121619', //ok
						'text_link'        => '#16d08e', //ok light green
						'text_hover'       => '#13b078', //ok dark green
						'text_link2'       => '#2131b6', //ok light blue
						'text_hover2'      => '#17238c', //ok dark blue
						'text_link3'       => '#191e2d', //ok
						'text_hover3'      => '#07090e', //ok

						// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
						'alter_bg_color'   => '#f7f4f2', //ok
						'alter_bg_hover'   => '#e6e8eb', //ok
						'alter_bd_color'   => '#e0e0e0', //ok
						'alter_bd_hover'   => '#dadada',
						'alter_text'       => '#646464', //ok
						'alter_light'      => '#878787', //ok
						'alter_dark'       => '#121619', //ok
						'alter_link'       => '#16d08e', //ok light green
						'alter_hover'      => '#13b078', //ok dark green
						'alter_link2'      => '#2131b6', //ok light blue
						'alter_hover2'     => '#17238c', //ok dark blue
						'alter_link3'      => '#191e2d', //ok
						'alter_hover3'     => '#07090e', //ok

						// Extra blocks (submenu, tabs, color blocks, etc.)
						'extra_bg_color'   => '#121619', //ok dropdown bg
						'extra_bg_hover'   => '#28272e',
						'extra_bd_color'   => '#2e3337', //ok
						'extra_bd_hover'   => '#3d3d3d',
						'extra_text'       => '#646464', //ok
						'extra_light'      => '#878787', //ok
						'extra_dark'       => '#ffffff', //ok
						'extra_link'       => '#121619', //ok menu main
						'extra_hover'      => '#16d08e', //ok menu main
						'extra_link2'      => '#cacaca', //ok menu dropdown
						'extra_hover2'     => '#16d08e', //ok menu dropdown
						'extra_link3'      => '#ddb837',
						'extra_hover3'     => '#eec432',

						// Input fields (form's fields and textarea)
						'input_bg_color'   => '#ffffff', //ok
						'input_bg_hover'   => '#ffffff', //ok
						'input_bd_color'   => '#dfdfdf', //ok
						'input_bd_hover'   => '#c5c5c5', //ok
						'input_text'       => '#646464', //ok
						'input_light'      => '#646464', //ok
						'input_dark'       => '#646464', //ok

						// Inverse blocks (text and links on the 'text_link' background)
                        'inverse_bg_color' => '#191e2d', //ok audio
                        'inverse_bg_hover' => '#191e2d', //ok pagination
						'inverse_bd_color' => '#e0e0e0', //ok toggle border
						'inverse_bd_hover' => '#2e3337', //ok table
						'inverse_text'     => '#ffffff', //ok
						'inverse_light'    => '#333333',
						'inverse_dark'     => '#121619', //ok
						'inverse_link'     => '#ffffff', //ok
						'inverse_hover'    => '#ffffff', //ok
                        'inverse_link2'    => '#ffffff', //ok
					),
				),

				// Color scheme: 'dark'
				'dark'    => array(
					'title'    => esc_html__( 'Dark', 'rhodos' ),
					'internal' => true,
					'colors'   => array(

						// Whole block border and background
						'bg_color'         => '#07090e', //ok
						'bd_color'         => '#2c3345', //ok

						// Text and links colors
						'text'             => '#cfd0dc', //ok
						'text_light'       => '#eff3f5', //ok
						'text_dark'        => '#ffffff', //ok
						'text_link'        => '#16d08e', //ok light green
						'text_hover'       => '#13b078', //ok dark green
						'text_link2'       => '#2131b6', //ok light blue
						'text_hover2'      => '#17238c', //ok dark blue
						'text_link3'       => '#b5c2c8 ',//ok
						'text_hover3'      => '#7f898d', //ok

						// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
						'alter_bg_color'   => '#191e2d', //ok
						'alter_bg_hover'   => '#26292b', //ok
						'alter_bd_color'   => '#2c3345', //ok
						'alter_bd_hover'   => '#4a4a4a',
						'alter_text'       => '#cfd0dc', //ok
						'alter_light'      => '#eff3f5', //ok
						'alter_dark'       => '#ffffff', //ok
						'alter_link'       => '#16d08e', //ok light green
						'alter_hover'      => '#13b078', //ok dark green
						'alter_link2'      => '#2131b6', //ok light blue
						'alter_hover2'     => '#17238c', //ok dark blue
						'alter_link3'      => '#b5c2c8', //ok
						'alter_hover3'     => '#7f898d', //ok

						// Extra blocks (submenu, tabs, color blocks, etc.)
						'extra_bg_color'   => '#121619', //ok dropdown bg
						'extra_bg_hover'   => '#f4f5f7', //ok
						'extra_bd_color'   => '#ebebeb', //ok
						'extra_bd_hover'   => '#4a4a4a',
						'extra_text'       => '#646464', //ok
						'extra_light'      => '#eff3f5', //ok
						'extra_dark'       => '#121619', //ok
						'extra_link'       => '#ffffff', //ok menu main
						'extra_hover'      => '#ffffff', //ok menu main
						'extra_link2'      => '#cacaca', //ok menu dropdown
						'extra_hover2'     => '#16d08e', //ok menu dropdown
						'extra_link3'      => '#ddb837',
						'extra_hover3'     => '#eec432',

						// Input fields (form's fields and textarea)
						'input_bg_color'   => '#191e2d', //ok
						'input_bg_hover'   => '#07090e', //ok
						'input_bd_color'   => '#aae3dc', //ok
						'input_bd_hover'   => '#c2d6d3', //ok
						'input_text'       => '#cfd0dc', //ok
						'input_light'      => '#cfd0dc', //ok
						'input_dark'       => '#ffffff', //ok

						// Inverse blocks (text and links on the 'text_link' background)
                        'inverse_bg_color' => '#191e2d', //ok audio
                        'inverse_bg_hover' => '#16d08e', //ok pagination
						'inverse_bd_color' => '#cfd8dc', //ok toggle border
						'inverse_bd_hover' => '#2c3345', //ok table
						'inverse_text'     => '#f4f4f4', //ok
						'inverse_light'    => '#6f6f6f',
						'inverse_dark'     => '#121619', //ok
						'inverse_link'     => '#ffffff', //ok
						'inverse_hover'    => '#121619', //ok
                        'inverse_link2'    => '#191e2d', //ok
					),
				),

			)
		);
        rhodos_storage_set( 'schemes_original', rhodos_storage_get( 'schemes' ) );
		// Simple schemes substitution
		// Lists the colors and brightness factors that are used to generate other colors in the color scheme
		// Leave this array empty if your scheme does not have a color dependency
		rhodos_storage_set(
			'schemes_simple', array(
				// Main color => List the slave elements and it's brightness factors
				'text_link'   => array(),
				'text_hover'  => array(),
				'text_link2'  => array(),
				'text_hover2' => array(),
				'text_link3'  => array(),
				'text_hover3' => array(),

                'alter_link'       => array(),
                'alter_hover'      => array(),
                'alter_link2'      => array(),
                'alter_hover2'     => array(),
                'alter_link3'      => array(),
                'alter_hover3'     => array(),
                'extra_link'       => array(),
                'extra_hover'      => array(),
                'extra_link2'      => array(),
                'extra_hover2'     => array(),
                'extra_link3'      => array(),
                'extra_hover3'     => array(),
                'inverse_bd_color' => array(),
                'inverse_bd_hover' => array(),
			)
		);

		// Additional colors for each scheme
		// Parameters:	'color' - name of the color from the scheme that should be used as source for the transformation
		//				'alpha' - to make color transparent (0.0 - 1.0)
		//				'hue', 'saturation', 'brightness' - inc/dec value for each color's component
		rhodos_storage_set(
			'scheme_colors_add', array(
				'bg_color_0'        => array(
					'color' => 'bg_color',
					'alpha' => 0,
				),
				'bg_color_02'       => array(
					'color' => 'bg_color',
					'alpha' => 0.2,
				),
				'bg_color_07'       => array(
					'color' => 'bg_color',
					'alpha' => 0.7,
				),
				'bg_color_08'       => array(
					'color' => 'bg_color',
					'alpha' => 0.8,
				),
				'bg_color_09'       => array(
					'color' => 'bg_color',
					'alpha' => 0.9,
				),
				'alter_bg_color_07' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.7,
				),
				'alter_bg_color_04' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.4,
				),
				'alter_bg_color_02' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.2,
				),
				'alter_bd_color_02' => array(
					'color' => 'alter_bd_color',
					'alpha' => 0.2,
				),
                'alter_dark_01'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.1,
                ),
                'alter_dark_015'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.15,
                ),
				'alter_link_02'     => array(
					'color' => 'alter_link',
					'alpha' => 0.2,
				),
				'alter_link_07'     => array(
					'color' => 'alter_link',
					'alpha' => 0.7,
				),
				'extra_bg_color_07' => array(
					'color' => 'extra_bg_color',
					'alpha' => 0.7,
				),
                'extra_bg_color_09' => array(
                    'color' => 'extra_bg_color',
                    'alpha' => 0.9,
                ),
				'extra_link_02'     => array(
					'color' => 'extra_link',
					'alpha' => 0.2,
				),
				'extra_link_07'     => array(
					'color' => 'extra_link',
					'alpha' => 0.7,
				),
                'text_dark_018'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.18,
                ),
                'text_dark_05'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.5,
                ),
				'text_dark_07'      => array(
					'color' => 'text_dark',
					'alpha' => 0.7,
				),
                'text_link_018'      => array(
                    'color' => 'text_link',
                    'alpha' => 0.18,
                ),
                'text_link2_018'    => array(
                    'color' => 'text_link2',
                    'alpha' => 0.18,
                ),
                'text_link3_018'    => array(
                    'color' => 'text_link3',
                    'alpha' => 0.18,
                ),
				'text_link_02'      => array(
					'color' => 'text_link',
					'alpha' => 0.2,
				),
				'text_link_07'      => array(
					'color' => 'text_link',
					'alpha' => 0.7,
				),
                'text_link_092'      => array(
                    'color' => 'text_link',
                    'alpha' => 0.92,
                ),
                'text_hover_092'      => array(
                    'color' => 'text_hover',
                    'alpha' => 0.92,
                ),
                'text_link2_00'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0,
                ),
                'text_link2_08'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0.8,
                ),
                'text_link2_095'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0.95,
                ),
                'inverse_link_03'      => array(
                    'color' => 'inverse_link',
                    'alpha' => 0.3,
                ),
                'inverse_link_05'      => array(
                    'color' => 'inverse_link',
                    'alpha' => 0.5,
                ),
                'inverse_link_08'      => array(
                    'color' => 'inverse_link',
                    'alpha' => 0.8,
                ),
                'inverse_link_09'      => array(
                    'color' => 'inverse_link',
                    'alpha' => 0.9,
                ),
                'inverse_hover_07'      => array(
                    'color' => 'inverse_hover',
                    'alpha' => 0.7,
                ),
                'inverse_dark_01'      => array(
                    'color' => 'inverse_dark',
                    'alpha' => 0.1,
                ),
                'inverse_dark_018'      => array(
                    'color' => 'inverse_dark',
                    'alpha' => 0.18,
                ),
                'inverse_bg_color_008'      => array(
                    'color' => 'inverse_bg_color',
                    'alpha' => 0.08,
                ),
                'inverse_bg_color_01'      => array(
                    'color' => 'inverse_bg_color',
                    'alpha' => 0.1,
                ),
				'text_link_blend'   => array(
					'color'      => 'text_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
				'alter_link_blend'  => array(
					'color'      => 'alter_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
			)
		);

		// Parameters to set order of schemes in the css
		rhodos_storage_set(
			'schemes_sorted', array(
				'color_scheme',
				'header_scheme',
				'menu_scheme',
				'sidebar_scheme',
				'footer_scheme',
			)
		);

		// -----------------------------------------------------------------
		// -- Theme specific thumb sizes
		// -----------------------------------------------------------------
		rhodos_storage_set(
			'theme_thumbs', apply_filters(
				'rhodos_filter_add_thumb_sizes', array(
					// Width of the image is equal to the content area width (without sidebar)
					// Height is fixed
					'rhodos-thumb-huge'        => array(
						'size'  => array( 1230, 692, true ),  // default 1170 x 658
						'title' => esc_html__( 'Huge image', 'rhodos' ),
						'subst' => 'trx_addons-thumb-huge',
					),
					// Width of the image is equal to the content area width (with sidebar)
					// Height is fixed
					'rhodos-thumb-big'         => array(
						'size'  => array( 800, 451, true ),   // default 760 x 428
						'title' => esc_html__( 'Large image', 'rhodos' ),
						'subst' => 'trx_addons-thumb-big',
					),

					// Width of the image is equal to the 1/3 of the content area width (without sidebar)
					// Height is fixed
					'rhodos-thumb-med'         => array(
						'size'  => array( 390, 219, true ),    // default 370 x 208
						'title' => esc_html__( 'Medium image', 'rhodos' ),
						'subst' => 'trx_addons-thumb-medium',
					),

					// Small square image (for avatars in comments, etc.)
					'rhodos-thumb-tiny'        => array(
						'size'  => array( 90, 90, true ),
						'title' => esc_html__( 'Small square avatar', 'rhodos' ),
						'subst' => 'trx_addons-thumb-tiny',
					),

					// Width of the image is equal to the content area width (with sidebar)
					// Height is proportional (only downscale, not crop)
					'rhodos-thumb-masonry-big' => array(
						'size'  => array( 800, 0, false ),     // Only downscale, not crop
						'title' => esc_html__( 'Masonry Large (scaled)', 'rhodos' ),
						'subst' => 'trx_addons-thumb-masonry-big',
					),

					// Width of the image is equal to the 1/3 of the full content area width (without sidebar)
					// Height is proportional (only downscale, not crop)
					'rhodos-thumb-masonry'     => array(
						'size'  => array( 390, 0, false ),     // Only downscale, not crop
						'title' => esc_html__( 'Masonry (scaled)', 'rhodos' ),
						'subst' => 'trx_addons-thumb-masonry',
					),

                    // Square image (for avatars in testimonials, etc.)
                    'rhodos-thumb-square'       => array(
                        'size'  => array( 150, 150, true ),
                        'title' => esc_html__( 'Medium square avatar', 'rhodos' ),
                        'subst' => 'trx_addons-thumb-square',
                    ),

                    // Quadratic image (for image in team, etc.)
                    'rhodos-thumb-quadratic'       => array(
                        'size'  => array( 780, 780, true ),
                        'title' => esc_html__( 'Quadratic Image', 'rhodos' ),
                        'subst' => 'trx_addons-thumb-quadratic',
                    ),

                    // Portrait image  (for image in team, etc.)
                    'rhodos-thumb-portrait'       => array(
                        'size'  => array( 490, 554, true ),
                        'title' => esc_html__( 'Portrait Image', 'rhodos' ),
                        'subst' => 'trx_addons-thumb-portrait',
                    ),
                    // Extra image  (for image in blogger, etc.)
                    'rhodos-thumb-extra'       => array(
                        'size'  => array( 570, 446, true ),
                        'title' => esc_html__( 'Extra Image', 'rhodos' ),
                        'subst' => 'trx_addons-thumb-extra',
                    ),
				)
			)
		);
	}
}




//------------------------------------------------------------------------
// One-click import support
//------------------------------------------------------------------------

// Set theme specific importer options
if ( ! function_exists( 'rhodos_importer_set_options' ) ) {
	add_filter( 'trx_addons_filter_importer_options', 'rhodos_importer_set_options', 9 );
	function rhodos_importer_set_options( $options = array() ) {
		if ( is_array( $options ) ) {
			// Save or not installer's messages to the log-file
			$options['debug'] = false;
			// Allow import/export functionality
			$options['allow_import'] = true;
			$options['allow_export'] = false;
			// Prepare demo data
			$options['demo_url'] = esc_url( rhodos_get_protocol() . '://demofiles.axiomthemes.com/rhodos/' );
			// Required plugins
			$options['required_plugins'] = array_keys( rhodos_storage_get( 'required_plugins' ) );
			// Set number of thumbnails (usually 3 - 5) to regenerate when its imported (if demo data was zipped without cropped images)
			// Set 0 to prevent regenerate thumbnails (if demo data archive is already contain cropped images)
			$options['regenerate_thumbnails'] = 3;
			// Default demo
			$options['files']['default']['title']       = esc_html__( 'Default Demo', 'rhodos' );
			$options['files']['default']['domain_dev']  =  '';                                                                  // Developers domain
			$options['files']['default']['domain_demo'] = esc_url( rhodos_get_protocol() . '://rhodos.axiomthemes.com' );       // Demo-site domain
			// Banners
			$options['banners'] = array(
				array(
					'image'        => rhodos_get_file_url( 'theme-specific/theme-about/images/frontpage.png' ),
					'title'        => esc_html__( 'Front Page Builder', 'rhodos' ),
					'content'      => wp_kses( __( "Create your front page right in the WordPress Customizer. There's no need in any page builder. Simply enable/disable sections, fill them out with content, and customize to your liking.", 'rhodos' ), 'rhodos_kses_content' ),
					'link_url'     => esc_url( '//www.youtube.com/watch?v=VT0AUbMl_KA' ),
					'link_caption' => esc_html__( 'Watch Video Introduction', 'rhodos' ),
					'duration'     => 20,
				),
				array(
					'image'        => rhodos_get_file_url( 'theme-specific/theme-about/images/layouts.png' ),
					'title'        => esc_html__( 'Layouts Builder', 'rhodos' ),
					'content'      => wp_kses( __( 'Use Layouts Builder to create and customize header and footer styles for your website. With a flexible page builder interface and custom shortcodes, you can create as many header and footer layouts as you want with ease.', 'rhodos' ), 'rhodos_kses_content' ),
					'link_url'     => esc_url( '//www.youtube.com/watch?v=pYhdFVLd7y4' ),
					'link_caption' => esc_html__( 'Learn More', 'rhodos' ),
					'duration'     => 20,
				),
				array(
					'image'        => rhodos_get_file_url( 'theme-specific/theme-about/images/documentation.png' ),
					'title'        => esc_html__( 'Read Full Documentation', 'rhodos' ),
					'content'      => wp_kses( __( 'Need more details? Please check our full online documentation for detailed information on how to use Rhodos.', 'rhodos' ), 'rhodos_kses_content' ),
					'link_url'     => esc_url( rhodos_storage_get( 'theme_doc_url' ) ),
					'link_caption' => esc_html__( 'Online Documentation', 'rhodos' ),
					'duration'     => 15,
				),
				array(
					'image'        => rhodos_get_file_url( 'theme-specific/theme-about/images/video-tutorials.png' ),
					'title'        => esc_html__( 'Video Tutorials', 'rhodos' ),
					'content'      => wp_kses( __( 'No time for reading documentation? Check out our video tutorials and learn how to customize Rhodos in detail.', 'rhodos' ), 'rhodos_kses_content' ),
					'link_url'     => esc_url( rhodos_storage_get( 'theme_video_url' ) ),
					'link_caption' => esc_html__( 'Video Tutorials', 'rhodos' ),
					'duration'     => 15,
				),
				array(
					'image'        => rhodos_get_file_url( 'theme-specific/theme-about/images/studio.png' ),
					'title'        => esc_html__( 'Website Customization', 'rhodos' ),
					'content'      => wp_kses( __( "Need a website fast? Order our custom service, and we'll build a website based on this theme for a very fair price. We can also implement additional functionality such as website translation, setting up WPML, and much more.", 'rhodos' ), 'rhodos_kses_content' ),
					'link_url'     => esc_url( '//themerex.net/offers/?utm_source=offers&utm_medium=click&utm_campaign=themedash' ),
					'link_caption' => esc_html__( 'Contact Us', 'rhodos' ),
					'duration'     => 25,
				),
			);
		}
		return $options;
	}
}


//------------------------------------------------------------------------
// OCDI support
//------------------------------------------------------------------------

// Set theme specific OCDI options
if ( ! function_exists( 'rhodos_ocdi_set_options' ) ) {
	add_filter( 'trx_addons_filter_ocdi_options', 'rhodos_ocdi_set_options', 9 );
	function rhodos_ocdi_set_options( $options = array() ) {
		if ( is_array( $options ) ) {
			// Prepare demo data
			$options['demo_url'] = esc_url( rhodos_get_protocol() . '://demofiles.axiomthemes.com/rhodos/' );
			// Required plugins
			$options['required_plugins'] = array_keys( rhodos_storage_get( 'required_plugins' ) );
			// Demo-site domain
			$options['files']['ocdi']['title']       = esc_html__( 'Rhodos OCDI Demo', 'rhodos' );
			$options['files']['ocdi']['domain_demo'] = esc_url( rhodos_get_protocol() . '://rhodos.axiomthemes.com' );
		}
		return $options;
	}
}


// -----------------------------------------------------------------
// -- Theme options for customizer
// -----------------------------------------------------------------
if ( ! function_exists( 'rhodos_create_theme_options' ) ) {

	function rhodos_create_theme_options() {

		// Message about options override.
		// Attention! Not need esc_html() here, because this message put in wp_kses_data() below
		$msg_override = __( 'Attention! Some of these options can be overridden in the following sections (Blog, Plugins settings, etc.) or in the settings of individual pages. If you changed such parameter and nothing happened on the page, this option may be overridden in the corresponding section or in the Page Options of this page. These options are marked with an asterisk (*) in the title.', 'rhodos' );

		// Color schemes number: if < 2 - hide fields with selectors
		$hide_schemes = count( rhodos_storage_get( 'schemes' ) ) < 2;

		rhodos_storage_set(
			'options', array(

				// 'Logo & Site Identity'
				'title_tagline'                 => array(
					'title'    => esc_html__( 'Logo & Site Identity', 'rhodos' ),
					'desc'     => '',
					'priority' => 10,
					'type'     => 'section',
				),
				'logo_info'                     => array(
					'title'    => esc_html__( 'Logo Settings', 'rhodos' ),
					'desc'     => '',
					'priority' => 20,
					'qsetup'   => esc_html__( 'General', 'rhodos' ),
					'type'     => 'info',
				),
				'logo_text'                     => array(
					'title'    => esc_html__( 'Use Site Name as Logo', 'rhodos' ),
					'desc'     => wp_kses_data( __( 'Use the site title and tagline as a text logo if no image is selected', 'rhodos' ) ),
					'class'    => 'rhodos_column-1_2 rhodos_new_row',
					'priority' => 30,
					'std'      => 1,
					'qsetup'   => esc_html__( 'General', 'rhodos' ),
					'type'     => RHODOS_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'logo_retina_enabled'           => array(
					'title'    => esc_html__( 'Allow retina display logo', 'rhodos' ),
					'desc'     => wp_kses_data( __( 'Show fields to select logo images for Retina display', 'rhodos' ) ),
					'class'    => 'rhodos_column-1_2',
					'priority' => 40,
					'refresh'  => false,
					'std'      => 0,
					'type'     => RHODOS_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'logo_zoom'                     => array(
					'title'   => esc_html__( 'Logo zoom', 'rhodos' ),
					'desc'    => wp_kses_data( __( 'Zoom the logo. 1 - original size. Maximum size of logo depends on the actual size of the picture', 'rhodos' ) ),
					'std'     => 1,
					'min'     => 0.2,
					'max'     => 2,
					'step'    => 0.1,
					'refresh' => false,
					'type'    => RHODOS_THEME_FREE ? 'hidden' : 'slider',
				),
				// Parameter 'logo' was replaced with standard WordPress 'custom_logo'
				'logo_retina'                   => array(
					'title'      => esc_html__( 'Logo for Retina', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'rhodos' ) ),
					'class'      => 'rhodos_column-1_2',
					'priority'   => 70,
					'dependency' => array(
						'logo_retina_enabled' => array( 1 ),
					),
					'std'        => '',
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'image',
				),
				'logo_mobile_header'            => array(
					'title' => esc_html__( 'Logo for the mobile header', 'rhodos' ),
					'desc'  => wp_kses_data( __( 'Select or upload site logo to display it in the mobile header (if enabled in the section "Header - Header mobile"', 'rhodos' ) ),
					'class' => 'rhodos_column-1_2 rhodos_new_row',
					'std'   => '',
					'type'  => 'image',
				),
				'logo_mobile_header_retina'     => array(
					'title'      => esc_html__( 'Logo for the mobile header on Retina', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'rhodos' ) ),
					'class'      => 'rhodos_column-1_2',
					'dependency' => array(
						'logo_retina_enabled' => array( 1 ),
					),
					'std'        => '',
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'image',
				),
				'logo_mobile'                   => array(
					'title' => esc_html__( 'Logo for the mobile menu', 'rhodos' ),
					'desc'  => wp_kses_data( __( 'Select or upload site logo to display it in the mobile menu', 'rhodos' ) ),
					'class' => 'rhodos_column-1_2 rhodos_new_row',
					'std'   => '',
					'type'  => 'image',
				),
				'logo_mobile_retina'            => array(
					'title'      => esc_html__( 'Logo mobile on Retina', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'rhodos' ) ),
					'class'      => 'rhodos_column-1_2',
					'dependency' => array(
						'logo_retina_enabled' => array( 1 ),
					),
					'std'        => '',
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'image',
				),
				'logo_side'                     => array(
					'title' => esc_html__( 'Logo for the side menu', 'rhodos' ),
					'desc'  => wp_kses_data( __( 'Select or upload site logo (with vertical orientation) to display it in the side menu', 'rhodos' ) ),
					'class' => 'rhodos_column-1_2 rhodos_new_row',
					'std'   => '',
					'type'  => 'hidden', //image
				),
				'logo_side_retina'              => array(
					'title'      => esc_html__( 'Logo for the side menu on Retina', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Select or upload site logo (with vertical orientation) to display it in the side menu on Retina displays (if empty - use default logo from the field above)', 'rhodos' ) ),
					'class'      => 'rhodos_column-1_2',
					'dependency' => array(
						'logo_retina_enabled' => array( 1 ),
					),
					'std'        => '',
					'type'       => 'hidden',
				),

				// 'General settings'
				'general'                       => array(
					'title'    => esc_html__( 'General Settings', 'rhodos' ),
					'desc'     => wp_kses_data( $msg_override ),
					'priority' => 20,
					'type'     => 'section',
				),

				'general_layout_info'           => array(
					'title'  => esc_html__( 'Layout', 'rhodos' ),
					'desc'   => '',
					'qsetup' => esc_html__( 'General', 'rhodos' ),
					'type'   => 'info',
				),
				'body_style'                    => array(
					'title'    => esc_html__( 'Body style', 'rhodos' ),
					'desc'     => wp_kses_data( __( 'Select width of the body content', 'rhodos' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Content', 'rhodos' ),
					),
					'qsetup'   => esc_html__( 'General', 'rhodos' ),
					'refresh'  => false,
					'std'      => 'wide',
					'options'  => rhodos_get_list_body_styles( false ),
					'type'     => 'select',
				),
				'page_width'                    => array(
					'title'      => esc_html__( 'Page width', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Total width of the site content and sidebar (in pixels). If empty - use default width', 'rhodos' ) ),
					'dependency' => array(
						'body_style' => array( 'boxed', 'wide' ),
					),
					'std'        => 1230,
					'min'        => 1000,
					'max'        => 1400,
					'step'       => 10,
					'refresh'    => false,
					'customizer' => 'page',         // SASS variable's name to preview changes 'on fly'
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'slider',
				),
				'boxed_bg_image'                => array(
					'title'      => esc_html__( 'Boxed bg image', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Select or upload image, used as background in the boxed body', 'rhodos' ) ),
					'dependency' => array(
						'body_style' => array( 'boxed' ),
					),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Content', 'rhodos' ),
					),
					'std'        => '',
					'qsetup'     => esc_html__( 'General', 'rhodos' ),
					'type'       => 'image',
				),
				'remove_margins'                => array(
					'title'    => esc_html__( 'Remove margins', 'rhodos' ),
					'desc'     => wp_kses_data( __( 'Remove margins above and below the content area', 'rhodos' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Content', 'rhodos' ),
					),
					'refresh'  => false,
					'std'      => 0,
					'type'     => 'checkbox',
				),

				'general_sidebar_info'          => array(
					'title' => esc_html__( 'Sidebar', 'rhodos' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'sidebar_position'              => array(
					'title'    => esc_html__( 'Sidebar position', 'rhodos' ),
					'desc'     => wp_kses_data( __( 'Select position to show sidebar', 'rhodos' ) ),
					'override' => array(
						'mode'    => 'page,post,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'rhodos' ),
					),
					'std'      => 'right',
					'qsetup'   => esc_html__( 'General', 'rhodos' ),
					'options'  => array(),
					'type'     => 'switch',
				),
				'sidebar_widgets'               => array(
					'title'      => esc_html__( 'Sidebar widgets', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Select default widgets to show in the sidebar', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'rhodos' ),
					),
					'dependency' => array(
						'sidebar_position' => array( 'left', 'right' ),
					),
					'std'        => 'sidebar_widgets',
					'options'    => array(),
					'qsetup'     => esc_html__( 'General', 'rhodos' ),
					'type'       => 'select',
				),
				'sidebar_width'                 => array(
					'title'      => esc_html__( 'Sidebar width', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Width of the sidebar (in pixels). If empty - use default width', 'rhodos' ) ),
					'std'        => 390,
					'min'        => 150,
					'max'        => 500,
					'step'       => 10,
					'refresh'    => false,
					'customizer' => 'sidebar',      // SASS variable's name to preview changes 'on fly'
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'slider',
				),
				'sidebar_gap'                   => array(
					'title'      => esc_html__( 'Sidebar gap', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Gap between content and sidebar (in pixels). If empty - use default gap', 'rhodos' ) ),
					'std'        => 40,
					'min'        => 0,
					'max'        => 100,
					'step'       => 1,
					'refresh'    => false,
					'customizer' => 'gap',          // SASS variable's name to preview changes 'on fly'
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'slider',
				),
				'expand_content'                => array(
					'title'   => esc_html__( 'Expand content', 'rhodos' ),
					'desc'    => wp_kses_data( __( 'Expand the content width if the sidebar is hidden', 'rhodos' ) ),
					'refresh' => false,
					'std'     => 1,
					'type'    => 'checkbox',
				),

				'general_widgets_info'          => array(
					'title' => esc_html__( 'Additional widgets', 'rhodos' ),
					'desc'  => '',
					'type'  => RHODOS_THEME_FREE ? 'hidden' : 'info',
				),
				'widgets_above_page'            => array(
					'title'    => esc_html__( 'Widgets at the top of the page', 'rhodos' ),
					'desc'     => wp_kses_data( __( 'Select widgets to show at the top of the page (above content and sidebar)', 'rhodos' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'rhodos' ),
					),
					'std'      => 'hide',
					'options'  => array(),
					'type'     => RHODOS_THEME_FREE ? 'hidden' : 'select',
				),
				'widgets_above_content'         => array(
					'title'    => esc_html__( 'Widgets above the content', 'rhodos' ),
					'desc'     => wp_kses_data( __( 'Select widgets to show at the beginning of the content area', 'rhodos' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'rhodos' ),
					),
					'std'      => 'hide',
					'options'  => array(),
					'type'     => RHODOS_THEME_FREE ? 'hidden' : 'select',
				),
				'widgets_below_content'         => array(
					'title'    => esc_html__( 'Widgets below the content', 'rhodos' ),
					'desc'     => wp_kses_data( __( 'Select widgets to show at the ending of the content area', 'rhodos' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'rhodos' ),
					),
					'std'      => 'hide',
					'options'  => array(),
					'type'     => RHODOS_THEME_FREE ? 'hidden' : 'select',
				),
				'widgets_below_page'            => array(
					'title'    => esc_html__( 'Widgets at the bottom of the page', 'rhodos' ),
					'desc'     => wp_kses_data( __( 'Select widgets to show at the bottom of the page (below content and sidebar)', 'rhodos' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'rhodos' ),
					),
					'std'      => 'hide',
					'options'  => array(),
					'type'     => RHODOS_THEME_FREE ? 'hidden' : 'select',
				),

				'general_effects_info'          => array(
					'title' => esc_html__( 'Design & Effects', 'rhodos' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'border_radius'                 => array(
					'title'      => esc_html__( 'Border radius', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Specify the border radius of the form fields and buttons in pixels', 'rhodos' ) ),
					'std'        => 0,
					'min'        => 0,
					'max'        => 20,
					'step'       => 1,
					'refresh'    => false,
					'customizer' => 'rad',      // SASS name to preview changes 'on fly'
					'type'       => 'hidden',  
				),

				'general_misc_info'             => array(
					'title' => esc_html__( 'Miscellaneous', 'rhodos' ),
					'desc'  => '',
					'type'  => RHODOS_THEME_FREE ? 'hidden' : 'info',
				),
				'seo_snippets'                  => array(
					'title' => esc_html__( 'SEO snippets', 'rhodos' ),
					'desc'  => wp_kses_data( __( 'Add structured data markup to the single posts and pages', 'rhodos' ) ),
					'std'   => 0,
					'type'  => RHODOS_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'privacy_text' => array(
					"title" => esc_html__("Text with Privacy Policy link", 'rhodos'),
					"desc"  => wp_kses_data( __("Specify text with Privacy Policy link for the checkbox 'I agree ...'", 'rhodos') ),
					"std"   => wp_kses( __( 'I agree that my submitted data is being collected and stored.', 'rhodos'), 'rhodos_kses_content' ),
					"type"  => "text"
				),

				// 'Header'
				'header'                        => array(
					'title'    => esc_html__( 'Header', 'rhodos' ),
					'desc'     => wp_kses_data( $msg_override ),
					'priority' => 30,
					'type'     => 'section',
				),

				'header_style_info'             => array(
					'title' => esc_html__( 'Header style', 'rhodos' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'header_type'                   => array(
					'title'    => esc_html__( 'Header style', 'rhodos' ),
					'desc'     => wp_kses_data( __( 'Choose whether to use the default header or header Layouts (available only if the ThemeREX Addons is activated)', 'rhodos' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'rhodos' ),
					),
					'std'      => 'default',
					'options'  => rhodos_get_list_header_footer_types(),
					'type'     => RHODOS_THEME_FREE || ! rhodos_exists_trx_addons() ? 'hidden' : 'switch',
				),
				'header_style'                  => array(
					'title'      => esc_html__( 'Select custom layout', 'rhodos' ),
					'desc'       => wp_kses( __( 'Select custom header from Layouts Builder', 'rhodos' ), 'rhodos_kses_content' ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'rhodos' ),
					),
					'dependency' => array(
						'header_type' => array( 'custom' ),
					),
					'std'        => RHODOS_THEME_FREE ? 'header-custom-elementor-header-default' : 'header-custom-header-default',
					'options'    => array(),
					'type'       => 'select',
				),
				'header_position'               => array(
					'title'    => esc_html__( 'Header position', 'rhodos' ),
					'desc'     => wp_kses_data( __( 'Select position to display the site header', 'rhodos' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'rhodos' ),
					),
					'std'      => 'default',
					'options'  => array(),
					'type'     => RHODOS_THEME_FREE ? 'hidden' : 'switch',
				),
				'header_fullheight'             => array(
					'title'    => esc_html__( 'Header fullheight', 'rhodos' ),
					'desc'     => wp_kses_data( __( 'Enlarge header area to fill whole screen. Used only if header have a background image', 'rhodos' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'rhodos' ),
					),
					'std'      => 0,
					'type'     => RHODOS_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_zoom'                   => array(
					'title'   => esc_html__( 'Header zoom', 'rhodos' ),
					'desc'    => wp_kses_data( __( 'Zoom the header title. 1 - original size', 'rhodos' ) ),
					'std'     => 1,
					'min'     => 0.3,
					'max'     => 2,
					'step'    => 0.1,
					'refresh' => false,
					'type'    => RHODOS_THEME_FREE ? 'hidden' : 'slider',
				),
				'header_wide'                   => array(
					'title'      => esc_html__( 'Header fullwidth', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Do you want to stretch the header widgets area to the entire window width?', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'rhodos' ),
					),
					'dependency' => array(
						'header_type' => array( 'default' ),
					),
					'std'        => 1,
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'checkbox',
				),

				'header_widgets_info'           => array(
					'title' => esc_html__( 'Header widgets', 'rhodos' ),
					'desc'  => wp_kses_data( __( 'Here you can place a widget slider, advertising banners, etc.', 'rhodos' ) ),
					'type'  => 'info',
				),
				'header_widgets'                => array(
					'title'    => esc_html__( 'Header widgets', 'rhodos' ),
					'desc'     => wp_kses_data( __( 'Select set of widgets to show in the header on each page', 'rhodos' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'rhodos' ),
						'desc'    => wp_kses_data( __( 'Select set of widgets to show in the header on this page', 'rhodos' ) ),
					),
					'std'      => 'hide',
					'options'  => array(),
					'type'     => 'select',
				),
				'header_columns'                => array(
					'title'      => esc_html__( 'Header columns', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Select number columns to show widgets in the Header. If 0 - autodetect by the widgets count', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'rhodos' ),
					),
					'dependency' => array(
						'header_type'    => array( 'default' ),
						'header_widgets' => array( '^hide' ),
					),
					'std'        => 0,
					'options'    => rhodos_get_list_range( 0, 6 ),
					'type'       => 'select',
				),

				'menu_info'                     => array(
					'title' => esc_html__( 'Main menu', 'rhodos' ),
					'desc'  => wp_kses_data( __( 'Main menu parameters', 'rhodos' ) ),
					'type'  => RHODOS_THEME_FREE ? 'hidden' : 'info',
				),
				'menu_style'                    => array(
					'title'    => esc_html__( 'Menu position', 'rhodos' ),
					'desc'     => wp_kses_data( __( 'Select position of the main menu', 'rhodos' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'rhodos' ),
					),
					'std'      => 'top',
					'options'  => array(
						'top'   => esc_html__( 'Top', 'rhodos' ),
						'left'  => esc_html__( 'Left', 'rhodos' ),
						'right' => esc_html__( 'Right', 'rhodos' ),
					),
					'type'     =>  'hidden',      
				),
				'menu_side_stretch'             => array(
					'title'      => esc_html__( 'Stretch sidemenu', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Stretch sidemenu to window height (if menu items number >= 5)', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'rhodos' ),
					),
					'dependency' => array(
						'menu_style' => array( 'left', 'right' ),
					),
					'std'        => 0,
					'type'       => 'hidden', 
				),
				'menu_side_icons'               => array(
					'title'      => esc_html__( 'Iconed sidemenu', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Get icons from anchors and display it in the sidemenu or mark sidemenu items with simple dots', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'rhodos' ),
					),
					'dependency' => array(
						'menu_style' => array( 'left', 'right' ),
					),
					'std'        => 1,
					'type'       => 'hidden', 
				),
				'menu_mobile_fullscreen'        => array(
					'title' => esc_html__( 'Mobile menu fullscreen', 'rhodos' ),
					'desc'  => wp_kses_data( __( 'Display mobile menu on full screen (if checked)', 'rhodos' ) ),
					'std'   => 1,
					'type'  => RHODOS_THEME_FREE ? 'hidden' : 'checkbox',
				),

				'header_image_info'             => array(
					'title' => esc_html__( 'Header image', 'rhodos' ),
					'desc'  => '',
					'type'  => RHODOS_THEME_FREE ? 'hidden' : 'info',
				),
				'header_image_override'         => array(
					'title'    => esc_html__( 'Header image override', 'rhodos' ),
					'desc'     => wp_kses_data( __( "Allow override the header image with the page's/post's/product's/etc. featured image", 'rhodos' ) ),
					'override' => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Header', 'rhodos' ),
					),
					'std'      => 0,
					'type'     => RHODOS_THEME_FREE ? 'hidden' : 'checkbox',
				),

				'header_mobile_info'            => array(
					'title'      => esc_html__( 'Mobile header', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Configure the mobile version of the header', 'rhodos' ) ),
					'priority'   => 500,
					'dependency' => array(
						'header_type' => array( 'default' ),
					),
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'info',
				),
				'header_mobile_enabled'         => array(
					'title'      => esc_html__( 'Enable the mobile header', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Use the mobile version of the header (if checked) or relayout the current header on mobile devices', 'rhodos' ) ),
					'dependency' => array(
						'header_type' => array( 'default' ),
					),
					'std'        => 0,
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_mobile_additional_info' => array(
					'title'      => esc_html__( 'Additional info', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Additional info to show at the top of the mobile header', 'rhodos' ) ),
					'std'        => '',
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'refresh'    => false,
					'teeny'      => false,
					'rows'       => 20,
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'text_editor',
				),
				'header_mobile_hide_info'       => array(
					'title'      => esc_html__( 'Hide additional info', 'rhodos' ),
					'std'        => 0,
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_mobile_hide_logo'       => array(
					'title'      => esc_html__( 'Hide logo', 'rhodos' ),
					'std'        => 0,
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_mobile_hide_login'      => array(
					'title'      => esc_html__( 'Hide login/logout', 'rhodos' ),
					'std'        => 0,
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_mobile_hide_search'     => array(
					'title'      => esc_html__( 'Hide search', 'rhodos' ),
					'std'        => 0,
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_mobile_hide_cart'       => array(
					'title'      => esc_html__( 'Hide cart', 'rhodos' ),
					'std'        => 0,
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'checkbox',
				),

				// 'Footer'
				'footer'                        => array(
					'title'    => esc_html__( 'Footer', 'rhodos' ),
					'desc'     => wp_kses_data( $msg_override ),
					'priority' => 50,
					'type'     => 'section',
				),
				'footer_type'                   => array(
					'title'    => esc_html__( 'Footer style', 'rhodos' ),
					'desc'     => wp_kses_data( __( 'Choose whether to use the default footer or footer Layouts (available only if the ThemeREX Addons is activated)', 'rhodos' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Footer', 'rhodos' ),
					),
					'std'      => 'default',
					'options'  => rhodos_get_list_header_footer_types(),
					'type'     => RHODOS_THEME_FREE || ! rhodos_exists_trx_addons() ? 'hidden' : 'switch',
				),
				'footer_style'                  => array(
					'title'      => esc_html__( 'Select custom layout', 'rhodos' ),
					'desc'       => wp_kses( __( 'Select custom footer from Layouts Builder', 'rhodos' ), 'rhodos_kses_content' ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Footer', 'rhodos' ),
					),
					'dependency' => array(
						'footer_type' => array( 'custom' ),
					),
					'std'        => RHODOS_THEME_FREE ? 'footer-custom-elementor-footer-default' : 'footer-custom-footer-default',
					'options'    => array(),
					'type'       => 'select',
				),
				'footer_widgets'                => array(
					'title'      => esc_html__( 'Footer widgets', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Select set of widgets to show in the footer', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Footer', 'rhodos' ),
					),
					'dependency' => array(
						'footer_type' => array( 'default' ),
					),
					'std'        => 'footer_widgets',
					'options'    => array(),
					'type'       => 'select',
				),
				'footer_columns'                => array(
					'title'      => esc_html__( 'Footer columns', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Footer', 'rhodos' ),
					),
					'dependency' => array(
						'footer_type'    => array( 'default' ),
						'footer_widgets' => array( '^hide' ),
					),
					'std'        => 0,
					'options'    => rhodos_get_list_range( 0, 6 ),
					'type'       => 'select',
				),
				'footer_wide'                   => array(
					'title'      => esc_html__( 'Footer fullwidth', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Do you want to stretch the footer to the entire window width?', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Footer', 'rhodos' ),
					),
					'dependency' => array(
						'footer_type' => array( 'default' ),
					),
					'std'        => 0,
					'type'       => 'checkbox',
				),
				'logo_in_footer'                => array(
					'title'      => esc_html__( 'Show logo', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Show logo in the footer', 'rhodos' ) ),
					'refresh'    => false,
					'dependency' => array(
						'footer_type' => array( 'default' ),
					),
					'std'        => 0,
					'type'       => 'checkbox',
				),
				'logo_footer'                   => array(
					'title'      => esc_html__( 'Logo for footer', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Select or upload site logo to display it in the footer', 'rhodos' ) ),
					'dependency' => array(
						'footer_type'    => array( 'default' ),
						'logo_in_footer' => array( 1 ),
					),
					'std'        => '',
					'type'       => 'image',
				),
				'logo_footer_retina'            => array(
					'title'      => esc_html__( 'Logo for footer (Retina)', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Select or upload logo for the footer area used on Retina displays (if empty - use default logo from the field above)', 'rhodos' ) ),
					'dependency' => array(
						'footer_type'         => array( 'default' ),
						'logo_in_footer'      => array( 1 ),
						'logo_retina_enabled' => array( 1 ),
					),
					'std'        => '',
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'image',
				),
				'socials_in_footer'             => array(
					'title'      => esc_html__( 'Show social icons', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Show social icons in the footer (under logo or footer widgets)', 'rhodos' ) ),
					'dependency' => array(
						'footer_type' => array( 'default' ),
					),
					'std'        => 0,
					'type'       => ! rhodos_exists_trx_addons() ? 'hidden' : 'checkbox',
				),
				'copyright'                     => array(
					'title'      => esc_html__( 'Copyright', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Copyright text in the footer. Use {Y} to insert current year and press "Enter" to create a new line', 'rhodos' ) ),
					'translate'  => true,
					'std'        => esc_html__( 'Copyright &copy; {Y} by AxiomThemes. All rights reserved.', 'rhodos' ),
					'dependency' => array(
						'footer_type' => array( 'default' ),
					),
					'refresh'    => false,
					'type'       => 'textarea',
				),

				// 'Blog'
				'blog'                          => array(
					'title'    => esc_html__( 'Blog', 'rhodos' ),
					'desc'     => wp_kses_data( __( 'Options of the the blog archive', 'rhodos' ) ),
					'priority' => 70,
					'type'     => 'panel',
				),
				// Blog - Posts page
				'blog_general'                  => array(
					'title' => esc_html__( 'Posts page', 'rhodos' ),
					'desc'  => wp_kses_data( __( 'Style and components of the blog archive', 'rhodos' ) ),
					'type'  => 'section',
				),
				'blog_general_info'             => array(
					'title'  => esc_html__( 'Posts page settings', 'rhodos' ),
					'desc'   => '',
					'qsetup' => esc_html__( 'General', 'rhodos' ),
					'type'   => 'info',
				),
				'blog_style'                    => array(
					'title'      => esc_html__( 'Blog style', 'rhodos' ),
					'desc'       => '',
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'rhodos' ),
					),
                    'dependency' => array(
                        'compare' => 'or',
                        '#page_template' => array( 'blog.php' ),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
                    ),
					'std'        => 'excerpt',
					'qsetup'     => esc_html__( 'General', 'rhodos' ),
					'options'    => array(),
					'type'       => 'select',
				),
				'first_post_large'              => array(
					'title'      => esc_html__( 'First post large', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Make your first post stand out by making it bigger', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'rhodos' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
						'blog_style'     => array( 'classic', 'masonry' ),
					),
					'std'        => 0,
					'type'       => 'checkbox',
				),
				'blog_content'                  => array(
					'title'      => esc_html__( 'Posts content', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Display either post excerpts or the full post content', 'rhodos' ) ),
					'std'        => 'excerpt',
					'dependency' => array(
						'blog_style' => array( 'excerpt' ),
					),
					'options'    => array(
						'excerpt'  => esc_html__( 'Excerpt', 'rhodos' ),
						'fullpost' => esc_html__( 'Full post', 'rhodos' ),
					),
					'type'       => 'switch',
				),
				'excerpt_length'                => array(
					'title'      => esc_html__( 'Excerpt length', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Length (in words) to generate excerpt from the post content. Attention! If the post excerpt is explicitly specified - it appears unchanged', 'rhodos' ) ),
					'dependency' => array(
						'blog_style'   => array( 'excerpt' ),
						'blog_content' => array( 'excerpt' ),
					),
					'std'        => 60,
					'type'       => 'text',
				),
				'blog_columns'                  => array(
					'title'   => esc_html__( 'Blog columns', 'rhodos' ),
					'desc'    => wp_kses_data( __( 'How many columns should be used in the blog archive (from 2 to 4)?', 'rhodos' ) ),
					'std'     => 2,
					'options' => rhodos_get_list_range( 2, 4 ),
					'type'    => 'hidden',      // This options is available and must be overriden only for some modes (for example, 'shop')
				),
				'post_type'                     => array(
					'title'      => esc_html__( 'Post type', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Select post type to show in the blog archive', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'rhodos' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					'linked'     => 'parent_cat',
					'refresh'    => false,
					'hidden'     => true,
					'std'        => 'post',
					'options'    => array(),
					'type'       => 'select',
				),
				'parent_cat'                    => array(
					'title'      => esc_html__( 'Category to show', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Select category to show in the blog archive', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'rhodos' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					'refresh'    => false,
					'hidden'     => true,
					'std'        => '0',
					'options'    => array(),
					'type'       => 'select',
				),
				'posts_per_page'                => array(
					'title'      => esc_html__( 'Posts per page', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'How many posts will be displayed on this page', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'rhodos' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					'hidden'     => true,
					'std'        => '',
					'type'       => 'text',
				),
				'blog_pagination'               => array(
					'title'      => esc_html__( 'Pagination style', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Show Older/Newest posts or Page numbers below the posts list', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'rhodos' ),
					),
					'std'        => 'pages',
					'qsetup'     => esc_html__( 'General', 'rhodos' ),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					'options'    => array(
						'pages'    => esc_html__( 'Page numbers', 'rhodos' ),
						'links'    => esc_html__( 'Older/Newest', 'rhodos' ),
						'more'     => esc_html__( 'Load more', 'rhodos' ),
						'infinite' => esc_html__( 'Infinite scroll', 'rhodos' ),
					),
					'type'       => 'select',
				),
				'blog_animation'                => array(
					'title'      => esc_html__( 'Animation for the posts', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Select animation to show posts in the blog. Attention! Do not use any animation on pages with the "wheel to the anchor" behaviour (like a "Chess 2 columns")!', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'rhodos' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					'std'        => 'none',
					'options'    => array(),
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'select',
				),
				'show_filters'                  => array(
					'title'      => esc_html__( 'Show filters', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Show categories as tabs to filter posts', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'rhodos' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
						'blog_style'     => array( 'portfolio', 'gallery' ),
					),
					'hidden'     => true,
					'std'        => 0,
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'checkbox',
				),

               	'blog_sidebar_info'             => array(
					'title' => esc_html__( 'Sidebar', 'rhodos' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'sidebar_position_blog'         => array(
					'title'   => esc_html__( 'Sidebar position', 'rhodos' ),
					'desc'    => wp_kses_data( __( 'Select position to show sidebar', 'rhodos' ) ),
					'std'     => 'right',
					'options' => array(),
					'qsetup'     => esc_html__( 'General', 'rhodos' ),
					'type'    => 'switch',
				),
				'sidebar_widgets_blog'          => array(
					'title'      => esc_html__( 'Sidebar widgets', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Select default widgets to show in the sidebar', 'rhodos' ) ),
					'dependency' => array(
						'sidebar_position_blog' => array( 'left', 'right' ),
					),
					'std'        => 'sidebar_widgets',
					'options'    => array(),
					'qsetup'     => esc_html__( 'General', 'rhodos' ),
					'type'       => 'select',
				),
				'expand_content_blog'           => array(
					'title'   => esc_html__( 'Expand content', 'rhodos' ),
					'desc'    => wp_kses_data( __( 'Expand the content width if the sidebar is hidden', 'rhodos' ) ),
					'refresh' => false,
					'std'     => 1,
					'type'    => 'checkbox',
				),

				'blog_widgets_info'             => array(
					'title' => esc_html__( 'Additional widgets', 'rhodos' ),
					'desc'  => '',
					'type'  => RHODOS_THEME_FREE ? 'hidden' : 'info',
				),
				'widgets_above_page_blog'       => array(
					'title'   => esc_html__( 'Widgets at the top of the page', 'rhodos' ),
					'desc'    => wp_kses_data( __( 'Select widgets to show at the top of the page (above content and sidebar)', 'rhodos' ) ),
					'std'     => 'hide',
					'options' => array(),
					'type'    => RHODOS_THEME_FREE ? 'hidden' : 'select',
				),
				'widgets_above_content_blog'    => array(
					'title'   => esc_html__( 'Widgets above the content', 'rhodos' ),
					'desc'    => wp_kses_data( __( 'Select widgets to show at the beginning of the content area', 'rhodos' ) ),
					'std'     => 'hide',
					'options' => array(),
					'type'    => RHODOS_THEME_FREE ? 'hidden' : 'select',
				),
				'widgets_below_content_blog'    => array(
					'title'   => esc_html__( 'Widgets below the content', 'rhodos' ),
					'desc'    => wp_kses_data( __( 'Select widgets to show at the ending of the content area', 'rhodos' ) ),
					'std'     => 'hide',
					'options' => array(),
					'type'    => RHODOS_THEME_FREE ? 'hidden' : 'select',
				),
				'widgets_below_page_blog'       => array(
					'title'   => esc_html__( 'Widgets at the bottom of the page', 'rhodos' ),
					'desc'    => wp_kses_data( __( 'Select widgets to show at the bottom of the page (below content and sidebar)', 'rhodos' ) ),
					'std'     => 'hide',
					'options' => array(),
					'type'    => RHODOS_THEME_FREE ? 'hidden' : 'select',
				),

				'blog_advanced_info'            => array(
					'title' => esc_html__( 'Advanced settings', 'rhodos' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'no_image'                      => array(
					'title' => esc_html__( 'Image placeholder', 'rhodos' ),
					'desc'  => wp_kses_data( __( 'Select or upload an image used as placeholder for posts without a featured image', 'rhodos' ) ),
					'std'   => '',
					'type'  => 'image',
				),
				'time_diff_before'              => array(
					'title' => esc_html__( 'Easy Readable Date Format', 'rhodos' ),
					'desc'  => wp_kses_data( __( "For how many days to show the easy-readable date format (e.g. '3 days ago') instead of the standard publication date", 'rhodos' ) ),
					'std'   => 5,
					'type'  => 'text',
				),
				'sticky_style'                  => array(
					'title'   => esc_html__( 'Sticky posts style', 'rhodos' ),
					'desc'    => wp_kses_data( __( 'Select style of the sticky posts output', 'rhodos' ) ),
					'std'     => 'inherit',
					'options' => array(
						'inherit' => esc_html__( 'Decorated posts', 'rhodos' ),
						'columns' => esc_html__( 'Mini-cards', 'rhodos' ),
					),
					'type'    => RHODOS_THEME_FREE ? 'hidden' : 'select',
				),
				'meta_parts'                    => array(
					'title'      => esc_html__( 'Post meta', 'rhodos' ),
					'desc'       => wp_kses_data( __( "If your blog page is created using the 'Blog archive' page template, set up the 'Post Meta' settings in the 'Theme Options' section of that page. Post counters and Share Links are available only if plugin ThemeREX Addons is active", 'rhodos' ) )
								. '<br>'
								. wp_kses_data( __( '<b>Tip:</b> Drag items to change their order.', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'rhodos' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					'dir'        => 'vertical',
					'sortable'   => true,
					'std'        => 'categories=1|author=1|date=1|counters=1|share=0|edit=0',
					'options'    => rhodos_get_list_meta_parts(),
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'checklist',
				),
				'counters'                      => array(
					'title'      => esc_html__( 'Post counters', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Show only selected counters. Attention! Likes and Views are available only if ThemeREX Addons is active', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'rhodos' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					'dir'        => 'vertical',
					'sortable'   => true,
					'std'        => 'comments=1|likes=0|views=0',
					'options'    => rhodos_get_list_counters(),
					'type'       => RHODOS_THEME_FREE || ! rhodos_exists_trx_addons() ? 'hidden' : 'checklist',
				),

				// Blog - Single posts
				'blog_single'                   => array(
					'title' => esc_html__( 'Single posts', 'rhodos' ),
					'desc'  => wp_kses_data( __( 'Settings of the single post', 'rhodos' ) ),
					'type'  => 'section',
				),
				'hide_featured_on_single'       => array(
					'title'    => esc_html__( 'Hide featured image on the single post', 'rhodos' ),
					'desc'     => wp_kses_data( __( "Hide featured image on the single post's pages", 'rhodos' ) ),
					'override' => array(
						'mode'    => 'page,post',
						'section' => esc_html__( 'Content', 'rhodos' ),
					),
					'std'      => 0,
					'type'     => 'checkbox',
				),
                'header_type_post'                   => array(
                    'title'    => esc_html__( 'Header style', 'rhodos' ),
                    'desc'     => wp_kses_data( __( 'Choose whether to use the default header or header Layouts (available only if the ThemeREX Addons is activated)', 'rhodos' ) ),
                    'std'      => 'default',
                    'options'  => rhodos_get_list_header_footer_types(),
                    'type'     => RHODOS_THEME_FREE || ! rhodos_exists_trx_addons() ? 'hidden' : 'switch',
                ),
                'header_style_post'                  => array(
                    'title'      => esc_html__( 'Select custom layout', 'rhodos' ),
                    'desc'       => wp_kses( __( 'Select custom header from Layouts Builder', 'rhodos' ), 'rhodos_kses_content' ),
                    'dependency' => array(
                        'header_type_post' => array( 'custom' ),
                    ),
                    'std'        => RHODOS_THEME_FREE ? 'header-custom-elementor-header-default' : 'header-custom-header-default',
                    'options'    => array(),
                    'type'       => 'select',
                ),
				'post_thumbnail_type'      => array(
					'title'      => esc_html__( 'Type of post thumbnail', 'rhodos' ),
					'desc'       => wp_kses_data( __( "Select type of post thumbnail on the single post's pages", 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Content', 'rhodos' ),
					),
					'dependency' => array(
						'hide_featured_on_single' => array( 0 ),
					),
					'std'        => 'default',
					'options'    => array(
						'fullwidth'   => esc_html__( 'Fullwidth', 'rhodos' ),
						'boxed'       => esc_html__( 'Boxed', 'rhodos' ),
						'default'     => esc_html__( 'Default', 'rhodos' ),
					),
					'type'       =>  'hidden',  
				),
				'post_header_position'          => array(
					'title'      => esc_html__( 'Post header position', 'rhodos' ),
					'desc'       => wp_kses_data( __( "Select post header position on the single post's pages", 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Content', 'rhodos' ),
					),
					'dependency' => array(
						'hide_featured_on_single' => array( 0 ),
					),
					'std'        => 'default',
					'options'    => array(
						'above'      => esc_html__( 'Above the post thumbnail', 'rhodos' ),
						'under'      => esc_html__( 'Under the post thumbnail', 'rhodos' ),
						'on_thumb'   => esc_html__( 'On the post thumbnail', 'rhodos' ),
						'default'    => esc_html__( 'Default', 'rhodos' ),
					),
					'type'       => 'hidden', 
				),
				'post_header_align'             => array(
					'title'      => esc_html__( 'Align of the post header', 'rhodos' ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Content', 'rhodos' ),
					),
					'dependency' => array(
						'post_header_position' => array( 'on_thumb' ),
					),
					'std'        => 'mc',
					'options'    => array(
						'ts' => esc_html__('Top Stick Out', 'rhodos'),
						'tl' => esc_html__('Top Left', 'rhodos'),
						'tc' => esc_html__('Top Center', 'rhodos'),
						'tr' => esc_html__('Top Right', 'rhodos'),
						'ml' => esc_html__('Middle Left', 'rhodos'),
						'mc' => esc_html__('Middle Center', 'rhodos'),
						'mr' => esc_html__('Middle Right', 'rhodos'),
						'bl' => esc_html__('Bottom Left', 'rhodos'),
						'bc' => esc_html__('Bottom Center', 'rhodos'),
						'br' => esc_html__('Bottom Right', 'rhodos'),
						'bs' => esc_html__('Bottom Stick Out', 'rhodos'),
					),
					'type'       => 'hidden', 
				),
				'hide_sidebar_on_single'        => array(
					'title' => esc_html__( 'Hide sidebar on the single post', 'rhodos' ),
					'desc'  => wp_kses_data( __( "Hide sidebar on the single post's pages", 'rhodos' ) ),
					'std'   => 0,
					'type'  => 'checkbox',
				),
				'show_post_excerpt'              => array(
					'title' => esc_html__( 'Show post excerpt', 'rhodos' ),
					'desc'  => wp_kses_data( __( "Display post excerpt under post title.", 'rhodos' ) ),
					'override' => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Content', 'rhodos' ),
					),
					'dependency' => array(
						'hide_featured_on_single' => array( 0 ),
					),
					'std'   => 0,
					'type'  => 'hidden', //checkbox
				),
				'show_post_meta'                => array(
					'title' => esc_html__( 'Show post meta', 'rhodos' ),
					'desc'  => wp_kses_data( __( "Display block with post's meta: date, categories, counters, etc.", 'rhodos' ) ),
					'std'   => 1,
					'type'  => 'checkbox',
				),
				'meta_parts_post'               => array(
					'title'      => esc_html__( 'Post meta', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Meta parts for single posts. Post counters and Share Links are available only if plugin ThemeREX Addons is active', 'rhodos' ) )
								. '<br>'
								. wp_kses_data( __( '<b>Tip:</b> Drag items to change their order.', 'rhodos' ) ),
					'dependency' => array(
						'show_post_meta' => array( 1 ),
					),
					'dir'        => 'vertical',
					'sortable'   => true,
					'std'        => 'categories=1|author=1|date=1|counters=1|share=0|edit=0',
					'options'    => rhodos_get_list_meta_parts(),
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'checklist',
				),
				'counters_post'                 => array(
					'title'      => esc_html__( 'Post counters', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Show only selected counters. Attention! Likes and Views are available only if plugin ThemeREX Addons is active', 'rhodos' ) ),
					'dependency' => array(
						'show_post_meta' => array( 1 ),
					),
					'dir'        => 'vertical',
					'sortable'   => true,
					'std'        => 'comments=1|likes=0|views=0',
					'options'    => rhodos_get_list_counters(),
					'type'       => RHODOS_THEME_FREE || ! rhodos_exists_trx_addons() ? 'hidden' : 'checklist',
				),
				'show_share_links'              => array(
					'title' => esc_html__( 'Show share links', 'rhodos' ),
					'desc'  => wp_kses_data( __( 'Display share links on the single post', 'rhodos' ) ),
					'std'   => 1,
					'type'  => ! rhodos_exists_trx_addons() ? 'hidden' : 'checkbox',
				),
				'show_author_info'              => array(
					'title' => esc_html__( 'Show author info', 'rhodos' ),
					'desc'  => wp_kses_data( __( "Display block with information about post's author", 'rhodos' ) ),
					'std'   => 1,
					'type'  => 'checkbox',
				),
				'blog_single_related_info'      => array(
					'title' => esc_html__( 'Related posts', 'rhodos' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'show_related_posts'            => array(
					'title'    => esc_html__( 'Show related posts', 'rhodos' ),
					'desc'     => wp_kses_data( __( "Show section 'Related posts' on the single post's pages", 'rhodos' ) ),
					'override' => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'rhodos' ),
					),
					'std'      => 1,
					'type'     => 'checkbox',
				),
				'related_posts'                 => array(
					'title'      => esc_html__( 'Related posts', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'How many related posts should be displayed in the single post? If 0 - no related posts are shown.', 'rhodos' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
					),
					'std'        => 2,
					'options'    => rhodos_get_list_range( 1, 9 ),
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'select',
				),
				'related_columns'               => array(
					'title'      => esc_html__( 'Related columns', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'How many columns should be used to output related posts in the single page (from 2 to 4)?', 'rhodos' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
					),
					'std'        => 2,
					'options'    => rhodos_get_list_range( 1, 4 ),
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'switch',
				),
				'related_slider'                => array(
					'title'      => esc_html__( 'Use slider layout', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Use slider layout in case related posts count is more than columns count', 'rhodos' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
					),
					'std'        => 0,
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'related_slider_controls'       => array(
					'title'      => esc_html__( 'Slider controls', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Show arrows in the slider', 'rhodos' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
						'related_slider' => array( 1 ),
					),
					'std'        => 'none',
					'options'    => array(
						'none'    => esc_html__('None', 'rhodos'),
						'side'    => esc_html__('Side', 'rhodos'),
						'outside' => esc_html__('Outside', 'rhodos'),
						'top'     => esc_html__('Top', 'rhodos'),
						'bottom'  => esc_html__('Bottom', 'rhodos')
					),
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'select',
				),
				'related_slider_pagination'       => array(
					'title'      => esc_html__( 'Slider pagination', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Show bullets after the slider', 'rhodos' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
						'related_slider' => array( 1 ),
					),
					'std'        => 'bottom',
					'options'    => array(
						'none'    => esc_html__('None', 'rhodos'),
						'bottom'  => esc_html__('Bottom', 'rhodos')
					),
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'switch',
				),
				'related_slider_space'          => array(
					'title'      => esc_html__( 'Space', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Space between slides', 'rhodos' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
						'related_slider' => array( 1 ),
					),
					'std'        => 30,
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'text',
				),
				'related_position'              => array(
					'title'      => esc_html__( 'Related posts position', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Select position to display the related posts', 'rhodos' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
					),
					'std'        => 'below_content',
					'options'    => array (
						'below_content' => esc_html__( 'After content', 'rhodos' ),
						'below_page'    => esc_html__( 'After content & sidebar', 'rhodos' ),
					),
					'type'       => RHODOS_THEME_FREE ? 'hidden' : 'switch',
				),
				'posts_navigation_info'      => array(
					'title' => esc_html__( 'Posts navigation', 'rhodos' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'show_posts_navigation'		=> array(
					'title'    => esc_html__( 'Show posts navigation', 'rhodos' ),
					'desc'     => wp_kses_data( __( "Show posts navigation on the single post's pages", 'rhodos' ) ),
					'std'      => 1,
					'type'     => 'checkbox',
				),
				'fixed_posts_navigation'		=> array(
					'title'    => esc_html__( 'Fixed posts navigation', 'rhodos' ),
					'desc'     => wp_kses_data( __( "Make posts navigation fixed position. Display them at the bottom of the window.", 'rhodos' ) ),
					'dependency' => array(
						'show_posts_navigation' => array( 1 ),
					),
					'std'      => 0,
					'type'     => 'checkbox',
				),
				'posts_banners_info'      => array(
					'title' => esc_html__( 'Posts banners', 'rhodos' ),
					'desc'  => '',
					'type'  => 'hidden', //info
				),
				'header_banner_link'     => array(
					'title' => esc_html__( 'Header banner link', 'rhodos' ),
					'desc'  => wp_kses_data( __( 'Insert URL of the banner', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'rhodos' ),
					),
					'std'   => '',
					'type'  => 'hidden', //text
				),
				'header_banner_img'     => array(
					'title' => esc_html__( 'Header banner image', 'rhodos' ),
					'desc'  => wp_kses_data( __( 'Select image to display at the backgound', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'rhodos' ),
					),
					'std'        => '',
					'type'       => 'hidden',  //image
				),
				'header_banner_code'     => array(
					'title'      => esc_html__( 'Header banner code', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Embed html code', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'rhodos' ),
					),
					'std'        => '',
					'allow_html' => true,
					'type'       => 'hidden', //textarea
				),
				'footer_banner_link'     => array(
					'title' => esc_html__( 'Footer banner link', 'rhodos' ),
					'desc'  => wp_kses_data( __( 'Insert URL of the banner', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'rhodos' ),
					),
					'std'   => '',
					'type'  => 'hidden', //text
				),
				'footer_banner_img'     => array(
					'title' => esc_html__( 'Footer banner image', 'rhodos' ),
					'desc'  => wp_kses_data( __( 'Select image to display at the backgound', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'rhodos' ),
					),
					'std'        => '',
					'type'       => 'hidden', //image
				),
				'footer_banner_code'     => array(
					'title'      => esc_html__( 'Footer banner code', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Embed html code', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'rhodos' ),
					),
					'std'        => '',
					'allow_html' => true,
					'type'       => 'hidden', //textarea
				),
				'sidebar_banner_link'     => array(
					'title' => esc_html__( 'Sidebar banner link', 'rhodos' ),
					'desc'  => wp_kses_data( __( 'Insert URL of the banner', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'rhodos' ),
					),
					'std'   => '',
					'type'  => 'hidden', //text
				),
				'sidebar_banner_img'     => array(
					'title' => esc_html__( 'Sidebar banner image', 'rhodos' ),
					'desc'  => wp_kses_data( __( 'Select image to display at the backgound', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'rhodos' ),
					),
					'std'        => '',
					'type'       => 'hidden', //image
				),
				'sidebar_banner_code'     => array(
					'title'      => esc_html__( 'Sidebar banner code', 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Embed html code', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'rhodos' ),
					),
					'std'        => '',
					'allow_html' => true,
					'type'       => 'hidden', //textarea
				),
				'background_banner_link'     => array(
					'title' => esc_html__( "Post's background banner link", 'rhodos' ),
					'desc'  => wp_kses_data( __( 'Insert URL of the banner', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'rhodos' ),
					),
					'std'   => '',
					'type'  => 'hidden', //text
				),
				'background_banner_img'     => array(
					'title' => esc_html__( "Post's background banner image", 'rhodos' ),
					'desc'  => wp_kses_data( __( 'Select image to display at the backgound', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'rhodos' ),
					),
					'std'        => '',
					'type'       => 'hidden', //image
				),
				'background_banner_code'     => array(
					'title'      => esc_html__( "Post's background banner code", 'rhodos' ),
					'desc'       => wp_kses_data( __( 'Embed html code', 'rhodos' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'rhodos' ),
					),
					'std'        => '',
					'allow_html' => true,
					'type'       => 'hidden', //textarea
				),
				'blog_end'                      => array(
					'type' => 'panel_end',
				),

				// 'Colors'
				'panel_colors'                  => array(
					'title'    => esc_html__( 'Colors', 'rhodos' ),
					'desc'     => '',
					'priority' => 300,
					'type'     => 'section',
				),

				'color_schemes_info'            => array(
					'title'  => esc_html__( 'Color schemes', 'rhodos' ),
					'desc'   => wp_kses_data( __( 'Color schemes for various parts of the site. "Inherit" means that this block is used the Site color scheme (the first parameter)', 'rhodos' ) ),
					'hidden' => $hide_schemes,
					'type'   => 'info',
				),
				'color_scheme'                  => array(
					'title'    => esc_html__( 'Site Color Scheme', 'rhodos' ),
					'desc'     => '',
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Colors', 'rhodos' ),
					),
					'std'      => 'default',
					'options'  => array(),
					'refresh'  => false,
					'type'     => $hide_schemes ? 'hidden' : 'switch',
				),
				'header_scheme'                 => array(
					'title'    => esc_html__( 'Header Color Scheme', 'rhodos' ),
					'desc'     => '',
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Colors', 'rhodos' ),
					),
					'std'      => 'inherit',
					'options'  => array(),
					'refresh'  => false,
					'type'     => $hide_schemes ? 'hidden' : 'switch',
				),
				'menu_scheme'                   => array(
					'title'    => esc_html__( 'Sidemenu Color Scheme', 'rhodos' ),
					'desc'     => '',
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Colors', 'rhodos' ),
					),
					'std'      => 'inherit',
					'options'  => array(),
					'refresh'  => false,
					'type'     => 'hidden',
				),
				'sidebar_scheme'                => array(
					'title'    => esc_html__( 'Sidebar Color Scheme', 'rhodos' ),
					'desc'     => '',
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Colors', 'rhodos' ),
					),
					'std'      => 'inherit',
					'options'  => array(),
					'refresh'  => false,
					'type'     => $hide_schemes ? 'hidden' : 'switch',
				),
				'footer_scheme'                 => array(
					'title'    => esc_html__( 'Footer Color Scheme', 'rhodos' ),
					'desc'     => '',
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Colors', 'rhodos' ),
					),
					'std'      => 'dark',
					'options'  => array(),
					'refresh'  => false,
					'type'     => $hide_schemes ? 'hidden' : 'switch',
				),

				'color_scheme_editor_info'      => array(
					'title' => esc_html__( 'Color scheme editor', 'rhodos' ),
					'desc'  => wp_kses_data( __( 'Select color scheme to modify. Attention! Only those sections in the site will be changed which this scheme was assigned to', 'rhodos' ) ),
					'type'  => 'info',
				),
				'scheme_storage'                => array(
					'title'       => esc_html__( 'Color scheme editor', 'rhodos' ),
					'desc'        => '',
					'std'         => '$rhodos_get_scheme_storage',
					'refresh'     => false,
					'colorpicker' => 'tiny',
					'type'        => 'scheme_editor',
				),

				// Internal options.
				// Attention! Don't change any options in the section below!
				// Use huge priority to call render this elements after all options!
				'reset_options'                 => array(
					'title'    => '',
					'desc'     => '',
					'std'      => '0',
					'priority' => 10000,
					'type'     => 'hidden',
				),

				'last_option'                   => array(     // Need to manually call action to include Tiny MCE scripts
					'title' => '',
					'desc'  => '',
					'std'   => 1,
					'type'  => 'hidden',
				),

			)
		);

		// Prepare panel 'Fonts'
		// -------------------------------------------------------------
		$fonts = array(

			// 'Fonts'
			'fonts'             => array(
				'title'    => esc_html__( 'Typography', 'rhodos' ),
				'desc'     => '',
				'priority' => 200,
				'type'     => 'panel',
			),

			// Fonts - Load_fonts
			'load_fonts'        => array(
				'title' => esc_html__( 'Load fonts', 'rhodos' ),
				'desc'  => wp_kses_data( __( 'Specify fonts to load when theme start. You can use them in the base theme elements: headers, text, menu, links, input fields, etc.', 'rhodos' ) )
						. '<br>'
						. wp_kses_data( __( 'Attention! Press "Refresh" button to reload preview area after the all fonts are changed', 'rhodos' ) ),
				'type'  => 'section',
			),
			'load_fonts_subset' => array(
				'title'   => esc_html__( 'Google fonts subsets', 'rhodos' ),
				'desc'    => wp_kses_data( __( 'Specify comma separated list of the subsets which will be load from Google fonts', 'rhodos' ) )
						. '<br>'
						. wp_kses_data( __( 'Available subsets are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese', 'rhodos' ) ),
				'class'   => 'rhodos_column-1_3 rhodos_new_row',
				'refresh' => false,
				'std'     => '$rhodos_get_load_fonts_subset',
				'type'    => 'text',
			),
		);

		for ( $i = 1; $i <= rhodos_get_theme_setting( 'max_load_fonts' ); $i++ ) {
			if ( rhodos_get_value_gp( 'page' ) != 'theme_options' ) {
				$fonts[ "load_fonts-{$i}-info" ] = array(
					// Translators: Add font's number - 'Font 1', 'Font 2', etc
					'title' => esc_html( sprintf( __( 'Font %s', 'rhodos' ), $i ) ),
					'desc'  => '',
					'type'  => 'info',
				);
			}
			$fonts[ "load_fonts-{$i}-name" ]   = array(
				'title'   => esc_html__( 'Font name', 'rhodos' ),
				'desc'    => '',
				'class'   => 'rhodos_column-1_3 rhodos_new_row',
				'refresh' => false,
				'std'     => '$rhodos_get_load_fonts_option',
				'type'    => 'text',
			);
			$fonts[ "load_fonts-{$i}-family" ] = array(
				'title'   => esc_html__( 'Font family', 'rhodos' ),
				'desc'    => 1 == $i
							? wp_kses_data( __( 'Select font family to use it if font above is not available', 'rhodos' ) )
							: '',
				'class'   => 'rhodos_column-1_3',
				'refresh' => false,
				'std'     => '$rhodos_get_load_fonts_option',
				'options' => array(
					'inherit'    => esc_html__( 'Inherit', 'rhodos' ),
					'serif'      => esc_html__( 'serif', 'rhodos' ),
					'sans-serif' => esc_html__( 'sans-serif', 'rhodos' ),
					'monospace'  => esc_html__( 'monospace', 'rhodos' ),
					'cursive'    => esc_html__( 'cursive', 'rhodos' ),
					'fantasy'    => esc_html__( 'fantasy', 'rhodos' ),
				),
				'type'    => 'select',
			);
			$fonts[ "load_fonts-{$i}-styles" ] = array(
				'title'   => esc_html__( 'Font styles', 'rhodos' ),
				'desc'    => 1 == $i
							? wp_kses_data( __( 'Font styles used only for the Google fonts. This is a comma separated list of the font weight and styles. For example: 400,400italic,700', 'rhodos' ) )
								. '<br>'
								. wp_kses_data( __( 'Attention! Each weight and style increase download size! Specify only used weights and styles.', 'rhodos' ) )
							: '',
				'class'   => 'rhodos_column-1_3',
				'refresh' => false,
				'std'     => '$rhodos_get_load_fonts_option',
				'type'    => 'text',
			);
		}
		$fonts['load_fonts_end'] = array(
			'type' => 'section_end',
		);

		// Fonts - H1..6, P, Info, Menu, etc.
		$theme_fonts = rhodos_get_theme_fonts();
		foreach ( $theme_fonts as $tag => $v ) {
			$fonts[ "{$tag}_section" ] = array(
				'title' => ! empty( $v['title'] )
								? $v['title']
								// Translators: Add tag's name to make title 'H1 settings', 'P settings', etc.
								: esc_html( sprintf( __( '%s settings', 'rhodos' ), $tag ) ),
				'desc'  => ! empty( $v['description'] )
								? $v['description']
								// Translators: Add tag's name to make description
								: wp_kses( sprintf( __( 'Font settings of the "%s" tag.', 'rhodos' ), $tag ), 'rhodos_kses_content' ),
				'type'  => 'section',
			);

			foreach ( $v as $css_prop => $css_value ) {
				if ( in_array( $css_prop, array( 'title', 'description' ) ) ) {
					continue;
				}
				$options    = '';
				$type       = 'text';
				$load_order = 1;
				$title      = ucfirst( str_replace( '-', ' ', $css_prop ) );
				if ( 'font-family' == $css_prop ) {
					$type       = 'select';
					$options    = array();
					$load_order = 2;        // Load this option's value after all options are loaded (use option 'load_fonts' to build fonts list)
				} elseif ( 'font-weight' == $css_prop ) {
					$type    = 'select';
					$options = array(
						'inherit' => esc_html__( 'Inherit', 'rhodos' ),
						'100'     => esc_html__( '100 (Light)', 'rhodos' ),
						'200'     => esc_html__( '200 (Light)', 'rhodos' ),
						'300'     => esc_html__( '300 (Thin)', 'rhodos' ),
						'400'     => esc_html__( '400 (Normal)', 'rhodos' ),
						'500'     => esc_html__( '500 (Semibold)', 'rhodos' ),
						'600'     => esc_html__( '600 (Semibold)', 'rhodos' ),
						'700'     => esc_html__( '700 (Bold)', 'rhodos' ),
						'800'     => esc_html__( '800 (Black)', 'rhodos' ),
						'900'     => esc_html__( '900 (Black)', 'rhodos' ),
					);
				} elseif ( 'font-style' == $css_prop ) {
					$type    = 'select';
					$options = array(
						'inherit' => esc_html__( 'Inherit', 'rhodos' ),
						'normal'  => esc_html__( 'Normal', 'rhodos' ),
						'italic'  => esc_html__( 'Italic', 'rhodos' ),
					);
				} elseif ( 'text-decoration' == $css_prop ) {
					$type    = 'select';
					$options = array(
						'inherit'      => esc_html__( 'Inherit', 'rhodos' ),
						'none'         => esc_html__( 'None', 'rhodos' ),
						'underline'    => esc_html__( 'Underline', 'rhodos' ),
						'overline'     => esc_html__( 'Overline', 'rhodos' ),
						'line-through' => esc_html__( 'Line-through', 'rhodos' ),
					);
				} elseif ( 'text-transform' == $css_prop ) {
					$type    = 'select';
					$options = array(
						'inherit'    => esc_html__( 'Inherit', 'rhodos' ),
						'none'       => esc_html__( 'None', 'rhodos' ),
						'uppercase'  => esc_html__( 'Uppercase', 'rhodos' ),
						'lowercase'  => esc_html__( 'Lowercase', 'rhodos' ),
						'capitalize' => esc_html__( 'Capitalize', 'rhodos' ),
					);
				}
				$fonts[ "{$tag}_{$css_prop}" ] = array(
					'title'      => $title,
					'desc'       => '',
					'class'      => 'rhodos_column-1_5',
					'refresh'    => false,
					'load_order' => $load_order,
					'std'        => '$rhodos_get_theme_fonts_option',
					'options'    => $options,
					'type'       => $type,
				);
			}

			$fonts[ "{$tag}_section_end" ] = array(
				'type' => 'section_end',
			);
		}

		$fonts['fonts_end'] = array(
			'type' => 'panel_end',
		);

		// Add fonts parameters to Theme Options
		rhodos_storage_set_array_before( 'options', 'panel_colors', $fonts );

		// Add Header Video if WP version < 4.7
		// -----------------------------------------------------
		if ( ! function_exists( 'get_header_video_url' ) ) {
			rhodos_storage_set_array_after(
				'options', 'header_image_override', 'header_video', array(
					'title'    => esc_html__( 'Header video', 'rhodos' ),
					'desc'     => wp_kses_data( __( 'Select video to use it as background for the header', 'rhodos' ) ),
					'override' => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Header', 'rhodos' ),
					),
					'std'      => '',
					'type'     => 'video',
				)
			);
		}

		// Add option 'logo' if WP version < 4.5
		// or 'custom_logo' if current page is 'Theme Options'
		// ------------------------------------------------------
		if ( ! function_exists( 'the_custom_logo' ) || ( isset( $_REQUEST['page'] ) && in_array( $_REQUEST['page'], array( 'theme_options', 'trx_addons_theme_panel' ) ) ) ) {
			rhodos_storage_set_array_before(
				'options', 'logo_retina', function_exists( 'the_custom_logo' ) ? 'custom_logo' : 'logo', array(
					'title'    => esc_html__( 'Logo', 'rhodos' ),
					'desc'     => wp_kses_data( __( 'Select or upload the site logo', 'rhodos' ) ),
					'class'    => 'rhodos_column-1_2 rhodos_new_row',
					'priority' => 60,
					'std'      => '',
					'qsetup'   => esc_html__( 'General', 'rhodos' ),
					'type'     => 'image',
				)
			);
		}

	}
}


// Returns a list of options that can be overridden for CPT
if ( ! function_exists( 'rhodos_options_get_list_cpt_options' ) ) {
	function rhodos_options_get_list_cpt_options( $cpt, $title = '' ) {
		if ( empty( $title ) ) {
			$title = ucfirst( $cpt );
		}
		return array(
			"header_info_{$cpt}"            => array(
				'title' => esc_html__( 'Header', 'rhodos' ),
				'desc'  => '',
				'type'  => 'info',
			),
			"header_type_{$cpt}"            => array(
				'title'   => esc_html__( 'Header style', 'rhodos' ),
				'desc'    => wp_kses_data( __( 'Choose whether to use the default header or header Layouts (available only if the ThemeREX Addons is activated)', 'rhodos' ) ),
				'std'     => 'inherit',
				'options' => rhodos_get_list_header_footer_types( true ),
				'type'    => RHODOS_THEME_FREE ? 'hidden' : 'switch',
			),
			"header_style_{$cpt}"           => array(
				'title'      => esc_html__( 'Select custom layout', 'rhodos' ),
				// Translators: Add CPT name to the description
				'desc'       => wp_kses_data( sprintf( __( 'Select custom layout to display the site header on the %s pages', 'rhodos' ), $title ) ),
				'dependency' => array(
					"header_type_{$cpt}" => array( 'custom' ),
				),
				'std'        => 'inherit',
				'options'    => array(),
				'type'       => RHODOS_THEME_FREE ? 'hidden' : 'select',
			),
			"header_position_{$cpt}"        => array(
				'title'   => esc_html__( 'Header position', 'rhodos' ),
				// Translators: Add CPT name to the description
				'desc'    => wp_kses_data( sprintf( __( 'Select position to display the site header on the %s pages', 'rhodos' ), $title ) ),
				'std'     => 'inherit',
				'options' => array(),
				'type'    => RHODOS_THEME_FREE ? 'hidden' : 'switch',
			),
			"header_image_override_{$cpt}"  => array(
				'title'   => esc_html__( 'Header image override', 'rhodos' ),
				'desc'    => wp_kses_data( __( "Allow override the header image with the post's featured image", 'rhodos' ) ),
				'std'     => 'inherit',
				'options' => array(
					'inherit' => esc_html__( 'Inherit', 'rhodos' ),
					1         => esc_html__( 'Yes', 'rhodos' ),
					0         => esc_html__( 'No', 'rhodos' ),
				),
				'type'    => RHODOS_THEME_FREE ? 'hidden' : 'switch',
			),
			"header_widgets_{$cpt}"         => array(
				'title'   => esc_html__( 'Header widgets', 'rhodos' ),
				// Translators: Add CPT name to the description
				'desc'    => wp_kses_data( sprintf( __( 'Select set of widgets to show in the header on the %s pages', 'rhodos' ), $title ) ),
				'std'     => 'hide',
				'options' => array(),
				'type'    => 'select',
			),

			"sidebar_info_{$cpt}"           => array(
				'title' => esc_html__( 'Sidebar', 'rhodos' ),
				'desc'  => '',
				'type'  => 'info',
			),
			"sidebar_position_{$cpt}"       => array(
				'title'   => esc_html__( 'Sidebar position', 'rhodos' ),
				// Translators: Add CPT name to the description
				'desc'    => wp_kses_data( sprintf( __( 'Select position to show sidebar on the %s pages', 'rhodos' ), $title ) ),
				'std'     => 'left',
				'options' => array(),
				'type'    => 'switch',
			),
			"sidebar_widgets_{$cpt}"        => array(
				'title'      => esc_html__( 'Sidebar widgets', 'rhodos' ),
				// Translators: Add CPT name to the description
				'desc'       => wp_kses_data( sprintf( __( 'Select sidebar to show on the %s pages', 'rhodos' ), $title ) ),
				'dependency' => array(
					"sidebar_position_{$cpt}" => array( 'left', 'right' ),
				),
				'std'        => 'hide',
				'options'    => array(),
				'type'       => 'select',
			),
			"hide_sidebar_on_single_{$cpt}" => array(
				'title'   => esc_html__( 'Hide sidebar on the single pages', 'rhodos' ),
				'desc'    => wp_kses_data( __( 'Hide sidebar on the single page', 'rhodos' ) ),
				'std'     => 'inherit',
				'options' => array(
					'inherit' => esc_html__( 'Inherit', 'rhodos' ),
					1         => esc_html__( 'Hide', 'rhodos' ),
					0         => esc_html__( 'Show', 'rhodos' ),
				),
				'type'    => 'switch',
			),

			"footer_info_{$cpt}"            => array(
				'title' => esc_html__( 'Footer', 'rhodos' ),
				'desc'  => '',
				'type'  => 'info',
			),
			"footer_type_{$cpt}"            => array(
				'title'   => esc_html__( 'Footer style', 'rhodos' ),
				'desc'    => wp_kses_data( __( 'Choose whether to use the default footer or footer Layouts (available only if the ThemeREX Addons is activated)', 'rhodos' ) ),
				'std'     => 'inherit',
				'options' => rhodos_get_list_header_footer_types( true ),
				'type'    => RHODOS_THEME_FREE ? 'hidden' : 'switch',
			),
			"footer_style_{$cpt}"           => array(
				'title'      => esc_html__( 'Select custom layout', 'rhodos' ),
				'desc'       => wp_kses_data( __( 'Select custom layout to display the site footer', 'rhodos' ) ),
				'std'        => 'inherit',
				'dependency' => array(
					"footer_type_{$cpt}" => array( 'custom' ),
				),
				'options'    => array(),
				'type'       => RHODOS_THEME_FREE ? 'hidden' : 'select',
			),
			"footer_widgets_{$cpt}"         => array(
				'title'      => esc_html__( 'Footer widgets', 'rhodos' ),
				'desc'       => wp_kses_data( __( 'Select set of widgets to show in the footer', 'rhodos' ) ),
				'dependency' => array(
					"footer_type_{$cpt}" => array( 'default' ),
				),
				'std'        => 'footer_widgets',
				'options'    => array(),
				'type'       => 'select',
			),
			"footer_columns_{$cpt}"         => array(
				'title'      => esc_html__( 'Footer columns', 'rhodos' ),
				'desc'       => wp_kses_data( __( 'Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'rhodos' ) ),
				'dependency' => array(
					"footer_type_{$cpt}"    => array( 'default' ),
					"footer_widgets_{$cpt}" => array( '^hide' ),
				),
				'std'        => 0,
				'options'    => rhodos_get_list_range( 0, 6 ),
				'type'       => 'select',
			),
			"footer_wide_{$cpt}"            => array(
				'title'      => esc_html__( 'Footer fullwidth', 'rhodos' ),
				'desc'       => wp_kses_data( __( 'Do you want to stretch the footer to the entire window width?', 'rhodos' ) ),
				'dependency' => array(
					"footer_type_{$cpt}" => array( 'default' ),
				),
				'std'        => 0,
				'type'       => 'checkbox',
			),

			"widgets_info_{$cpt}"           => array(
				'title' => esc_html__( 'Additional panels', 'rhodos' ),
				'desc'  => '',
				'type'  => RHODOS_THEME_FREE ? 'hidden' : 'info',
			),
			"widgets_above_page_{$cpt}"     => array(
				'title'   => esc_html__( 'Widgets at the top of the page', 'rhodos' ),
				'desc'    => wp_kses_data( __( 'Select widgets to show at the top of the page (above content and sidebar)', 'rhodos' ) ),
				'std'     => 'hide',
				'options' => array(),
				'type'    => RHODOS_THEME_FREE ? 'hidden' : 'select',
			),
			"widgets_above_content_{$cpt}"  => array(
				'title'   => esc_html__( 'Widgets above the content', 'rhodos' ),
				'desc'    => wp_kses_data( __( 'Select widgets to show at the beginning of the content area', 'rhodos' ) ),
				'std'     => 'hide',
				'options' => array(),
				'type'    => RHODOS_THEME_FREE ? 'hidden' : 'select',
			),
			"widgets_below_content_{$cpt}"  => array(
				'title'   => esc_html__( 'Widgets below the content', 'rhodos' ),
				'desc'    => wp_kses_data( __( 'Select widgets to show at the ending of the content area', 'rhodos' ) ),
				'std'     => 'hide',
				'options' => array(),
				'type'    => RHODOS_THEME_FREE ? 'hidden' : 'select',
			),
			"widgets_below_page_{$cpt}"     => array(
				'title'   => esc_html__( 'Widgets at the bottom of the page', 'rhodos' ),
				'desc'    => wp_kses_data( __( 'Select widgets to show at the bottom of the page (below content and sidebar)', 'rhodos' ) ),
				'std'     => 'hide',
				'options' => array(),
				'type'    => RHODOS_THEME_FREE ? 'hidden' : 'select',
			),
		);
	}
}


// Return lists with choises when its need in the admin mode
if ( ! function_exists( 'rhodos_options_get_list_choises' ) ) {
	add_filter( 'rhodos_filter_options_get_list_choises', 'rhodos_options_get_list_choises', 10, 2 );
	function rhodos_options_get_list_choises( $list, $id ) {
		if ( is_array( $list ) && count( $list ) == 0 ) {
			if ( strpos( $id, 'header_style' ) === 0 ) {
				$list = rhodos_get_list_header_styles( strpos( $id, 'header_style_' ) === 0 );
			} elseif ( strpos( $id, 'header_position' ) === 0 ) {
				$list = rhodos_get_list_header_positions( strpos( $id, 'header_position_' ) === 0 );
			} elseif ( strpos( $id, 'header_widgets' ) === 0 ) {
				$list = rhodos_get_list_sidebars( strpos( $id, 'header_widgets_' ) === 0, true );
			} elseif ( strpos( $id, '_scheme' ) > 0 ) {
				$list = rhodos_get_list_schemes( 'color_scheme' != $id );
			} elseif ( strpos( $id, 'sidebar_widgets' ) === 0 ) {
				$list = rhodos_get_list_sidebars( strpos( $id, 'sidebar_widgets_' ) === 0, true );
			} elseif ( strpos( $id, 'sidebar_position' ) === 0 ) {
				$list = rhodos_get_list_sidebars_positions( strpos( $id, 'sidebar_position_' ) === 0 );
			} elseif ( strpos( $id, 'widgets_above_page' ) === 0 ) {
				$list = rhodos_get_list_sidebars( strpos( $id, 'widgets_above_page_' ) === 0, true );
			} elseif ( strpos( $id, 'widgets_above_content' ) === 0 ) {
				$list = rhodos_get_list_sidebars( strpos( $id, 'widgets_above_content_' ) === 0, true );
			} elseif ( strpos( $id, 'widgets_below_page' ) === 0 ) {
				$list = rhodos_get_list_sidebars( strpos( $id, 'widgets_below_page_' ) === 0, true );
			} elseif ( strpos( $id, 'widgets_below_content' ) === 0 ) {
				$list = rhodos_get_list_sidebars( strpos( $id, 'widgets_below_content_' ) === 0, true );
			} elseif ( strpos( $id, 'footer_style' ) === 0 ) {
				$list = rhodos_get_list_footer_styles( strpos( $id, 'footer_style_' ) === 0 );
			} elseif ( strpos( $id, 'footer_widgets' ) === 0 ) {
				$list = rhodos_get_list_sidebars( strpos( $id, 'footer_widgets_' ) === 0, true );
			} elseif ( strpos( $id, 'blog_style' ) === 0 ) {
				$list = rhodos_get_list_blog_styles( strpos( $id, 'blog_style_' ) === 0 );
			} elseif ( strpos( $id, 'post_type' ) === 0 ) {
				$list = rhodos_get_list_posts_types();
			} elseif ( strpos( $id, 'parent_cat' ) === 0 ) {
				$list = rhodos_array_merge( array( 0 => esc_html__( '- Select category -', 'rhodos' ) ), rhodos_get_list_categories() );
			} elseif ( strpos( $id, 'blog_animation' ) === 0 ) {
				$list = rhodos_get_list_animations_in();
			} elseif ( 'color_scheme_editor' == $id ) {
				$list = rhodos_get_list_schemes();
			} elseif ( strpos( $id, '_font-family' ) > 0 ) {
				$list = rhodos_get_list_load_fonts( true );
			}
		}
		return $list;
	}
}
