<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0
 */

$rhodos_template_args = get_query_var( 'rhodos_template_args' );
if ( is_array( $rhodos_template_args ) ) {
	$rhodos_columns    = empty( $rhodos_template_args['columns'] ) ? 1 : max( 1, min( 3, $rhodos_template_args['columns'] ) );
	$rhodos_blog_style = array( $rhodos_template_args['type'], $rhodos_columns );
} else {
	$rhodos_blog_style = explode( '_', rhodos_get_theme_option( 'blog_style' ) );
	$rhodos_columns    = empty( $rhodos_blog_style[1] ) ? 1 : max( 1, min( 3, $rhodos_blog_style[1] ) );
}
$rhodos_expanded    = ! rhodos_sidebar_present() && rhodos_is_on( rhodos_get_theme_option( 'expand_content' ) );
$rhodos_post_format = get_post_format();
$rhodos_post_format = empty( $rhodos_post_format ) ? 'standard' : str_replace( 'post-format-', '', $rhodos_post_format );
$rhodos_animation   = rhodos_get_theme_option( 'blog_animation' );

?><article id="post-<?php the_ID(); ?>" 
									<?php
									post_class(
										'post_item'
										. ' post_layout_chess'
										. ' post_layout_chess_' . esc_attr( $rhodos_columns )
										. ' post_format_' . esc_attr( $rhodos_post_format )
										. ( ! empty( $rhodos_template_args['slider'] ) ? ' slider-slide swiper-slide' : '' )
									);
									echo ( ! rhodos_is_off( $rhodos_animation ) && empty( $rhodos_template_args['slider'] ) ? ' data-animation="' . esc_attr( rhodos_get_animation_classes( $rhodos_animation ) ) . '"' : '' );
									?>
	>

	<?php
	// Add anchor
	if ( 1 == $rhodos_columns && ! is_array( $rhodos_template_args ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode( '[trx_sc_anchor id="post_' . esc_attr( get_the_ID() ) . '" title="' .  the_title_attribute( array( 'echo' => false ) ) . '" icon="' . esc_attr( rhodos_get_post_icon() ) . '"]' );
	}

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$rhodos_hover = ! empty( $rhodos_template_args['hover'] ) && ! rhodos_is_inherit( $rhodos_template_args['hover'] )
						? $rhodos_template_args['hover']
						: rhodos_get_theme_option( 'image_hover' );
	rhodos_show_post_featured(
		array(
			'class'         => 1 == $rhodos_columns && ! is_array( $rhodos_template_args ) ? 'rhodos-full-height' : '',
			'singular'      => false,
			'hover'         => $rhodos_hover,
			'no_links'      => ! empty( $rhodos_template_args['no_links'] ),
			'show_no_image' => true,
			'thumb_ratio'   => '1:1',
			'thumb_bg'      => true,
			'thumb_size'    => rhodos_get_thumb_size(
				strpos( rhodos_get_theme_option( 'body_style' ), 'full' ) !== false
										? ( 1 < $rhodos_columns ? 'huge' : 'original' )
										: ( 2 < $rhodos_columns ? 'big' : 'huge' )
			),
		)
	);

	?>
	<div class="post_inner"><div class="post_inner_content"><div class="post_header entry-header">
		<?php
			do_action( 'rhodos_action_before_post_title' );

			// Post title
		if ( empty( $rhodos_template_args['no_links'] ) ) {
			the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
		} else {
			the_title( '<h3 class="post_title entry-title">', '</h3>' );
		}

			do_action( 'rhodos_action_before_post_meta' );

			// Post meta
			$rhodos_components = rhodos_array_get_keys_by_value( rhodos_get_theme_option( 'meta_parts' ) );
			$rhodos_counters   = rhodos_array_get_keys_by_value( rhodos_get_theme_option( 'counters' ) );
			$rhodos_post_meta  = empty( $rhodos_components ) || in_array( $rhodos_hover, array( 'border', 'pull', 'slide', 'fade' ) )
										? ''
										: rhodos_show_post_meta(
											apply_filters(
												'rhodos_filter_post_meta_args', array(
													'components' => $rhodos_components,
													'counters' => $rhodos_counters,
													'seo'  => false,
													'echo' => false,
												), $rhodos_blog_style[0], $rhodos_columns
											)
										);
			rhodos_show_layout( $rhodos_post_meta );
			?>
		</div><!-- .entry-header -->

		<div class="post_content entry-content">
		<?php
		if ( empty( $rhodos_template_args['hide_excerpt'] ) ) {
			?>
				<div class="post_content_inner">
				<?php
				if ( has_excerpt() ) {
					the_excerpt();
				} elseif ( strpos( get_the_content( '!--more' ), '!--more' ) !== false ) {
					the_content( '' );
				} elseif ( in_array( $rhodos_post_format, array( 'link', 'aside', 'status' ) ) ) {
					the_content();
				} elseif ( 'quote' == $rhodos_post_format ) {
					$quote = rhodos_get_tag( get_the_content(), '<blockquote>', '</blockquote>' );
					if ( ! empty( $quote ) ) {
						rhodos_show_layout( wpautop( $quote ) );
					} else {
						the_excerpt();
					}
				} elseif ( substr( get_the_content(), 0, 4 ) != '[vc_' ) {
					the_excerpt();
				}
				?>
				</div>
				<?php
		}
			// Post meta
		if ( in_array( $rhodos_post_format, array( 'link', 'aside', 'status', 'quote' ) ) ) {
			rhodos_show_layout( $rhodos_post_meta );
		}
			// More button
		if ( empty( $rhodos_template_args['no_links'] ) && ! in_array( $rhodos_post_format, array( 'link', 'aside', 'status', 'quote' ) ) ) {
			?>
				<p><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e( 'Read more', 'rhodos' ); ?></a></p>
				<?php
		}
		?>
		</div><!-- .entry-content -->

	</div></div><!-- .post_inner -->

</article><?php
// Need opening PHP-tag above, because article is a inline-block element (used as column)!
