<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0.50
 */

$rhodos_template_args = get_query_var( 'rhodos_template_args' );
if ( is_array( $rhodos_template_args ) ) {
	$rhodos_columns    = empty( $rhodos_template_args['columns'] ) ? 2 : max( 1, $rhodos_template_args['columns'] );
	$rhodos_blog_style = array( $rhodos_template_args['type'], $rhodos_columns );
} else {
	$rhodos_blog_style = explode( '_', rhodos_get_theme_option( 'blog_style' ) );
	$rhodos_columns    = empty( $rhodos_blog_style[1] ) ? 2 : max( 1, $rhodos_blog_style[1] );
}
$rhodos_blog_id       = rhodos_get_custom_blog_id( join( '_', $rhodos_blog_style ) );
$rhodos_blog_style[0] = str_replace( 'blog-custom-', '', $rhodos_blog_style[0] );
$rhodos_expanded      = ! rhodos_sidebar_present() && rhodos_is_on( rhodos_get_theme_option( 'expand_content' ) );
$rhodos_animation     = rhodos_get_theme_option( 'blog_animation' );
$rhodos_components    = rhodos_array_get_keys_by_value( rhodos_get_theme_option( 'meta_parts' ) );
$rhodos_counters      = rhodos_array_get_keys_by_value( rhodos_get_theme_option( 'counters' ) );

$rhodos_post_format   = get_post_format();
$rhodos_post_format   = empty( $rhodos_post_format ) ? 'standard' : str_replace( 'post-format-', '', $rhodos_post_format );

$rhodos_blog_meta     = rhodos_get_custom_layout_meta( $rhodos_blog_id );
$rhodos_custom_style  = ! empty( $rhodos_blog_meta['scripts_required'] ) ? $rhodos_blog_meta['scripts_required'] : 'none';

if ( ! empty( $rhodos_template_args['slider'] ) || $rhodos_columns > 1 || ! rhodos_is_off( $rhodos_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $rhodos_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo ( rhodos_is_off( $rhodos_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $rhodos_custom_style ) ) . '-1_' . esc_attr( $rhodos_columns );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" 
<?php
	post_class(
			'post_item post_format_' . esc_attr( $rhodos_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $rhodos_columns )
					. ' post_layout_' . esc_attr( $rhodos_blog_style[0] )
					. ' post_layout_' . esc_attr( $rhodos_blog_style[0] ) . '_' . esc_attr( $rhodos_columns )
					. ( ! rhodos_is_off( $rhodos_custom_style )
						? ' post_layout_' . esc_attr( $rhodos_custom_style )
							. ' post_layout_' . esc_attr( $rhodos_custom_style ) . '_' . esc_attr( $rhodos_columns )
						: ''
						)
		);
	echo ( ! rhodos_is_off( $rhodos_animation ) && empty( $rhodos_template_args['slider'] ) ? ' data-animation="' . esc_attr( rhodos_get_animation_classes( $rhodos_animation ) ) . '"' : '' );
?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom header's layout
	do_action( 'rhodos_action_show_layout', $rhodos_blog_id );
	?>
</article><?php
if ( ! empty( $rhodos_template_args['slider'] ) || $rhodos_columns > 1 || ! rhodos_is_off( $rhodos_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after div, because div is a inline-block element (used as column)!
}
