<div class="front_page_section front_page_section_woocommerce<?php
	$rhodos_scheme = rhodos_get_theme_option( 'front_page_woocommerce_scheme' );
	if ( ! rhodos_is_inherit( $rhodos_scheme ) ) {
		echo ' scheme_' . esc_attr( $rhodos_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( rhodos_get_theme_option( 'front_page_woocommerce_paddings' ) );
?>"
		<?php
		$rhodos_css      = '';
		$rhodos_bg_image = rhodos_get_theme_option( 'front_page_woocommerce_bg_image' );
		if ( ! empty( $rhodos_bg_image ) ) {
			$rhodos_css .= 'background-image: url(' . esc_url( rhodos_get_attachment_url( $rhodos_bg_image ) ) . ');';
		}
		if ( ! empty( $rhodos_css ) ) {
			echo ' style="' . esc_attr( $rhodos_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$rhodos_anchor_icon = rhodos_get_theme_option( 'front_page_woocommerce_anchor_icon' );
	$rhodos_anchor_text = rhodos_get_theme_option( 'front_page_woocommerce_anchor_text' );
if ( ( ! empty( $rhodos_anchor_icon ) || ! empty( $rhodos_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_woocommerce"'
									. ( ! empty( $rhodos_anchor_icon ) ? ' icon="' . esc_attr( $rhodos_anchor_icon ) . '"' : '' )
									. ( ! empty( $rhodos_anchor_text ) ? ' title="' . esc_attr( $rhodos_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_woocommerce_inner
	<?php
	if ( rhodos_get_theme_option( 'front_page_woocommerce_fullheight' ) ) {
		echo ' rhodos-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$rhodos_css      = '';
			$rhodos_bg_mask  = rhodos_get_theme_option( 'front_page_woocommerce_bg_mask' );
			$rhodos_bg_color_type = rhodos_get_theme_option( 'front_page_woocommerce_bg_color_type' );
			if ( 'custom' == $rhodos_bg_color_type ) {
				$rhodos_bg_color = rhodos_get_theme_option( 'front_page_woocommerce_bg_color' );
			} elseif ( 'scheme_bg_color' == $rhodos_bg_color_type ) {
				$rhodos_bg_color = rhodos_get_scheme_color( 'bg_color', $rhodos_scheme );
			} else {
				$rhodos_bg_color = '';
			}
			if ( ! empty( $rhodos_bg_color ) && $rhodos_bg_mask > 0 ) {
				$rhodos_css .= 'background-color: ' . esc_attr(
					1 == $rhodos_bg_mask ? $rhodos_bg_color : rhodos_hex2rgba( $rhodos_bg_color, $rhodos_bg_mask )
				) . ';';
			}
			if ( ! empty( $rhodos_css ) ) {
				echo ' style="' . esc_attr( $rhodos_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_woocommerce_content_wrap content_wrap woocommerce">
			<?php
			// Content wrap with title and description
			$rhodos_caption     = rhodos_get_theme_option( 'front_page_woocommerce_caption' );
			$rhodos_description = rhodos_get_theme_option( 'front_page_woocommerce_description' );
			if ( ! empty( $rhodos_caption ) || ! empty( $rhodos_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				// Caption
				if ( ! empty( $rhodos_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h2 class="front_page_section_caption front_page_section_woocommerce_caption front_page_block_<?php echo ! empty( $rhodos_caption ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( $rhodos_caption, 'rhodos_kses_content' );
					?>
					</h2>
					<?php
				}

				// Description (text)
				if ( ! empty( $rhodos_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_woocommerce_description front_page_block_<?php echo ! empty( $rhodos_description ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( wpautop( $rhodos_description ), 'rhodos_kses_content' );
					?>
					</div>
					<?php
				}
			}

			// Content (widgets)
			?>
			<div class="front_page_section_output front_page_section_woocommerce_output list_products shop_mode_thumbs">
			<?php
				$rhodos_woocommerce_sc = rhodos_get_theme_option( 'front_page_woocommerce_products' );
			if ( 'products' == $rhodos_woocommerce_sc ) {
				$rhodos_woocommerce_sc_ids      = rhodos_get_theme_option( 'front_page_woocommerce_products_per_page' );
				$rhodos_woocommerce_sc_per_page = count( explode( ',', $rhodos_woocommerce_sc_ids ) );
			} else {
				$rhodos_woocommerce_sc_per_page = max( 1, (int) rhodos_get_theme_option( 'front_page_woocommerce_products_per_page' ) );
			}
				$rhodos_woocommerce_sc_columns = max( 1, min( $rhodos_woocommerce_sc_per_page, (int) rhodos_get_theme_option( 'front_page_woocommerce_products_columns' ) ) );
				echo do_shortcode(
					"[{$rhodos_woocommerce_sc}"
									. ( 'products' == $rhodos_woocommerce_sc
											? ' ids="' . esc_attr( $rhodos_woocommerce_sc_ids ) . '"'
											: '' )
									. ( 'product_category' == $rhodos_woocommerce_sc
											? ' category="' . esc_attr( rhodos_get_theme_option( 'front_page_woocommerce_products_categories' ) ) . '"'
											: '' )
									. ( 'best_selling_products' != $rhodos_woocommerce_sc
											? ' orderby="' . esc_attr( rhodos_get_theme_option( 'front_page_woocommerce_products_orderby' ) ) . '"'
												. ' order="' . esc_attr( rhodos_get_theme_option( 'front_page_woocommerce_products_order' ) ) . '"'
											: '' )
									. ' per_page="' . esc_attr( $rhodos_woocommerce_sc_per_page ) . '"'
									. ' columns="' . esc_attr( $rhodos_woocommerce_sc_columns ) . '"'
					. ']'
				);
				?>
			</div>
		</div>
	</div>
</div>
