<?php
// Add skin-specific colors and fonts to the custom CSS
if ( ! function_exists( 'rhodos_skin_get_css' ) ) {
	add_filter( 'rhodos_filter_get_css', 'rhodos_skin_get_css', 10, 2 );
	function rhodos_skin_get_css( $css, $args ) {

		if ( isset( $css['fonts'] ) && isset( $args['fonts'] ) ) {
			$fonts         = $args['fonts'];
			$css['fonts'] .= <<<CSS
			
			.sc_countdown_default .sc_countdown_content {
			    	{$fonts['h5_font-family']}
			}

CSS;
		}

		if ( isset( $css['vars'] ) && isset( $args['vars'] ) ) {
			$vars         = $args['vars'];
			$css['vars'] .= <<<CSS

CSS;
		}

		if ( isset( $css['colors'] ) && isset( $args['colors'] ) ) {
			$colors         = $args['colors'];
			$css['colors'] .= <<<CSS
			
		/* CountDown */	
		.sc_countdown_default .sc_countdown_digits span {
		    color: {$colors['text_dark']};
		    border-color: transparent; 
		    background-color: transparent;
		}
		.sc_countdown_default  .sc_countdown_label {
		    color: {$colors['text_dark']}
		}
		.sc_countdown_default .sc_countdown_separator {
			color: {$colors['text_light']}
		}
		
		/* Row Compact */
		.sc_layouts_row_type_compact .sc_button_default,
		.scheme_self.sc_layouts_row_type_compact .sc_button_default {
			color: {$colors['text_dark']} !important;
			border-color: {$colors['text_dark']} !important;
		    background-color: transparent !important;
		    box-shadow: none !important; 
		}
		.sc_layouts_row_type_compact .sc_button_default:hover,
		.scheme_self.sc_layouts_row_type_compact .sc_button_default:hover {
			color: {$colors['text_link']} !important;
			border-color: {$colors['text_link']} !important;
		    background-color: transparent !important;
		    box-shadow: none !important; 
		}
		/* Testimonials */
        .sc_testimonials_extra.color_style_link2 .sc_slider_controls .slider_controls_wrap > a:hover,
        .sc_testimonials_extra.color_style_link2 .slider_container.slider_controls_side .slider_controls_wrap > a:hover,
        .sc_testimonials_extra.color_style_link2 .slider_outer_controls_side .slider_controls_wrap > a:hover,
        .sc_testimonials_extra.color_style_link2 .slider_outer_controls_outside .slider_controls_wrap > a:hover {
            color: {$colors['text_link2']} !important;
        }
        .color_style_link2 .sc_testimonials_item_author_title {
            color: {$colors['text_dark']} 
        }
        .color_style_link2 .sc_testimonials_item_content {
            color: {$colors['text']} 
        }
        /* Elementor Toggle */
        .elementor-toggle .elementor-tab-content {
            color: {$colors['text']};
        }
        .elementor-toggle .elementor-tab-title {
            color: {$colors['text_dark']};
            border-color: {$colors['alter_bg_color']};
            background-color: {$colors['alter_bg_color']};
        }
        .elementor-toggle .elementor-tab-title.elementor-active {
            color: {$colors['inverse_link']};
            border-color: {$colors['text_link2']};
            background-color: {$colors['text_link2']};
        }
        
        /* Blogger */
        .sc_blogger_extra .sc_blogger_item .sc_blogger_item_content_wrapper {
            background-color: {$colors['bg_color']};
        }

CSS;
		}

		return $css;
	}
}

