<?php
/**
 * Skins support: Main skin file for the skin 'Conference'
 *
 * Setup skin-dependent fonts and colors, load scripts and styles,
 * and other operations that affect the appearance and behavior of the theme
 * when the skin is activated
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0.46
 */


// Theme init priorities:
// 3 - add/remove Theme Options elements
if ( ! function_exists( 'rhodos_skin_theme_setup3' ) ) {
	add_action( 'after_setup_theme', 'rhodos_skin_theme_setup3', 3 );
	function rhodos_skin_theme_setup3() {
		// ToDo: Add / Modify theme options, required plugins, etc.

	}
}

// Shortcodes support
//------------------------------------------------------------------------

// Add new output types (layouts) in the shortcodes
if ( ! function_exists( 'rhodos_skin_trx_addons_sc_type' ) ) {
    add_filter( 'trx_addons_sc_type', 'rhodos_skin_trx_addons_sc_type', 10, 2 );
    function rhodos_skin_trx_addons_sc_type( $list, $sc ) {
        // To do: check shortcode slug and if correct - add new 'key' => 'title' to the list
        if ( 'trx_sc_icons' == $sc ) {
            $list['extra'] = 'Extra';
        }
        return $list;
    }
}


//------------------------------------------------------------------------
// One-click import support
//------------------------------------------------------------------------

// Set theme specific importer options
if ( ! function_exists( 'rhodos_skin_importer_set_options' ) ) {
    add_filter('trx_addons_filter_importer_options', 'rhodos_skin_importer_set_options', 9);
    function rhodos_skin_importer_set_options($options = array()) {
        if (is_array($options)) {
            // Conference demo
            $options['demo_type'] = 'conference';
            $options['files']['conference'] = $options['files']['default'];
            $options['files']['conference']['title'] = esc_html__('Conference Demo', 'rhodos');
            $options['files']['conference']['domain_demo'] = esc_url( rhodos_get_protocol() . '://conference.rhodos.axiomthemes.com' );   // Demo-site domain
            unset($options['files']['default']);
        }
        return $options;
    }
}

// Filter to add in the required plugins list
if ( ! function_exists( 'rhodos_skin_tgmpa_required_plugins' ) ) {
	add_filter( 'rhodos_filter_tgmpa_required_plugins', 'rhodos_skin_tgmpa_required_plugins' );
	function rhodos_skin_tgmpa_required_plugins( $list = array() ) {
		// ToDo: Check if plugin is in the 'required_plugins' and add his parameters to the TGMPA-list
		//       Replace 'skin-specific-plugin-slug' to the real slug of the plugin
		if ( rhodos_storage_isset( 'required_plugins', 'skin-specific-plugin-slug' ) ) {
			$list[] = array(
				'name'     => rhodos_storage_get_array( 'required_plugins', 'skin-specific-plugin-slug' ),
				'slug'     => 'skin-specific-plugin-slug',
				'required' => false,
			);
		}
		return $list;
	}
}

// Enqueue skin-specific styles and scripts
// Priority 1150 - after plugins-specific (1100), but before child theme (1200)
if ( ! function_exists( 'rhodos_skin_frontend_scripts' ) ) {
	add_action( 'wp_enqueue_scripts', 'rhodos_skin_frontend_scripts', 1150 );
	function rhodos_skin_frontend_scripts() {
		$rhodos_url = rhodos_get_file_url( RHODOS_SKIN_DIR . 'skin.css' );
		if ( '' != $rhodos_url ) {
			wp_enqueue_style( 'rhodos-skin-' . esc_attr( RHODOS_SKIN_NAME ), $rhodos_url, array(), null );
		}
		if ( rhodos_is_on( rhodos_get_theme_option( 'debug_mode' ) ) ) {
			$rhodos_url = rhodos_get_file_url( RHODOS_SKIN_DIR . 'skin.js' );
			if ( '' != $rhodos_url ) {
				wp_enqueue_script( 'rhodos-skin-' . esc_attr( RHODOS_SKIN_NAME ), $rhodos_url, array( 'jquery' ), null, true );
			}
		}
	}
}

// Enqueue skin-specific responsive styles
// Priority 2050 - after theme responsive 2000
if ( ! function_exists( 'rhodos_skin_styles_responsive' ) ) {
	add_action( 'wp_enqueue_scripts', 'rhodos_skin_styles_responsive', 2050 );
	function rhodos_skin_styles_responsive() {
		$rhodos_url = rhodos_get_file_url( RHODOS_SKIN_DIR . 'skin-responsive.css' );
		if ( '' != $rhodos_url ) {
			wp_enqueue_style( 'rhodos-skin-' . esc_attr( RHODOS_SKIN_NAME ) . '-responsive', $rhodos_url, array(), null );
		}
	}
}

// Merge custom scripts
if ( ! function_exists( 'rhodos_skin_merge_scripts' ) ) {
	add_filter( 'rhodos_filter_merge_scripts', 'rhodos_skin_merge_scripts' );
	function rhodos_skin_merge_scripts( $list ) {
		if ( rhodos_get_file_dir( RHODOS_SKIN_DIR . 'skin.js' ) != '' ) {
			$list[] = RHODOS_SKIN_DIR . 'skin.js';
		}
		return $list;
	}
}


// Add slin-specific colors and fonts to the custom CSS
require_once RHODOS_THEME_DIR . RHODOS_SKIN_DIR . 'skin-styles.php';

