<?php
// Add skin-specific colors and fonts to the custom CSS
if ( ! function_exists( 'rhodos_skin_get_css' ) ) {
	add_filter( 'rhodos_filter_get_css', 'rhodos_skin_get_css', 10, 2 );
	function rhodos_skin_get_css( $css, $args ) {

		if ( isset( $css['fonts'] ) && isset( $args['fonts'] ) ) {
			$fonts         = $args['fonts'];
			$css['fonts'] .= <<<CSS
			.sc_skills_decoration_counter .sc_skills_item_title,
			.sc_skills_decoration_counter .sc_skills_total  {
			    	{$fonts['h5_font-family']}
			}

CSS;
		}

		if ( isset( $css['vars'] ) && isset( $args['vars'] ) ) {
			$vars         = $args['vars'];
			$css['vars'] .= <<<CSS

CSS;
		}

		if ( isset( $css['colors'] ) && isset( $args['colors'] ) ) {
			$colors         = $args['colors'];
			$css['colors'] .= <<<CSS
			
		/* Footer */	
		.scheme_self.footer_wrap a:hover, .footer_wrap .scheme_self.vc_row a:hover {
            color: {$colors['alter_link2']};
        }
		.scheme_self.footer_wrap .widget_contacts .contacts_info span a:hover,
		.scheme_self.footer_wrap .widget_contacts .contacts_info > div > a:hover,
		.scheme_self.footer_wrap .widget_contacts .contacts_info > a:hover {
		    color: {$colors['alter_link2']};
		}
		.scheme_self.footer_wrap .socials_wrap .social_item:hover .social_icon {
			color: {$colors['alter_link2']};
		}
	
		/* Icons */	
		.sc_icons_extra .sc_icons_item {
		    border-color: {$colors['inverse_bd_color']};
		}
		/* Skills */
		.sc_blogger_extra .blogger_item_content_wrap {
		    background-color:  {$colors['bg_color']};
		}
		
		.sc_skills_counter .sc_skills_item_title {
			color: {$colors['text']};
		}
		.sc_skills_decoration_counter .sc_skills_icon {
		     color: {$colors['text_link']};
		}
	    .sc_skills_decoration_counter  .sc_skills_item_title {
	         border-color: {$colors['bd_color']};
	    }
					
		/* Revolution Slider */	
		/* bullets */
		rs-module .custom .tp-bullet {
		   background: {$colors['inverse_link']}!important;
		}
		rs-module .custom .tp-bullet:hover,
		rs-module .custom .tp-bullet.selected {
		    background: {$colors['text_link']}!important;
		}
		
		/* arrows */
		rs-module .custom.tparrows {
            background: {$colors['bg_color']}!important;
        }
		rs-module .custom.tp-leftarrow.tparrows {
            background: {$colors['alter_bg_color']}!important;
        }
        rs-module .custom.tparrows:hover {
            background: {$colors['text_link3']}!important;
        }
		rs-module .custom.tparrows:before {
            color: {$colors['text_dark']}!important;
        }
        rs-module .custom.tparrows:hover:before {
            color: {$colors['inverse_link']}!important;
        }
				
		/* MailChimp */	
		.mc4wp-form input[type="checkbox"] + label > a {
		    color: {$colors['text_dark']};
		}
		
		/* Single */	
		.scheme_self.author_info {
            color: {$colors['text_dark']};
            background-color: {$colors['text_link3']};
        }
        .scheme_self.author_info a  {
            color: {$colors['inverse_link']};
        }
        .scheme_self.author_info a:hover  {
            color: {$colors['inverse_link_08']};
        }
        /* Messages */
        .trx_addons_field_error, .wpcf7-not-valid {
             border-color: {$colors['text_link']} !important;
        }
        span.wpcf7-not-valid-tip {
            color: {$colors['text_link']};
        }
        div.wpcf7-validation-errors, div.wpcf7-acceptance-missing {
            border-color: {$colors['text_link']};
        }
        div.wpcf7-mail-sent-ok {
            border-color: {$colors['text_link2']};
        }
        .trx_addons_message_box_error {
            border-color: {$colors['text_link']};
        }
        .trx_addons_message_box_success {
            border-color: {$colors['text_link2']};
        }
        form .error_field {
            border-color: {$colors['text_link']} !important;
        }
        /* Wooc Message */
        .woocommerce .woocommerce-error {
	        border-top-color: {$colors['alter_link']};
        }
        .woocommerce .woocommerce-error:before {
	        color: {$colors['alter_link']};
        }   
        
        /* Services */ 
        .sc_services_extra  .sc_services_item_button .sc_button.sc_button_icon {
             color: {$colors['text_dark']} !important;
             background-color: transparent !important ;
             border-color: transparent !important;
        }
        .sc_services_extra  .sc_services_item_button .sc_button.sc_button_icon:hover {
             color: {$colors['text_link']} !important;
             background-color: transparent !important ;
             border-color: transparent !important;
        }
        .sc_services_extra .sc_services_item {
             background-color: {$colors['bg_color']};
        }   
        .sc_services_extra .sc_services_item_number {
             color: {$colors['text_dark']} !important;
        }
        .color_style_link2.sc_services_extra .sc_services_item:hover .sc_services_item_icon {
             color: {$colors['text_link2']} !important;
        }
        .color_style_link3.sc_services_extra .sc_services_item:hover .sc_services_item_icon {
             color: {$colors['text_link3']} !important;
        }
        .color_style_dark.sc_services_extra .sc_services_item:hover .sc_services_item_icon {
             color: {$colors['text_link']} !important;
        }
        /* Action */
        .sc_action_item_default.with_image::after {
            background: rgba(0, 0, 0, 0.5);
        }
        
}
        

CSS;
		}

		return $css;
	}
}

