<?php
/**
 * Skins support: Main skin file for the skin 'Designer CV'
 *
 * Setup skin-dependent fonts and colors, load scripts and styles,
 * and other operations that affect the appearance and behavior of the theme
 * when the skin is activated
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0.46
 */


// Theme init priorities:
// 3 - add/remove Theme Options elements
if ( ! function_exists( 'rhodos_skin_theme_setup3' ) ) {
	add_action( 'after_setup_theme', 'rhodos_skin_theme_setup3', 3 );
	function rhodos_skin_theme_setup3() {
		// ToDo: Add / Modify theme options, required plugins, etc.

        rhodos_storage_set(
            'schemes', array(

                // Color scheme: 'default'
                'default' => array(
                    'title'    => esc_html__( 'Default', 'rhodos' ),
                    'internal' => true,
                    'colors'   => array(

                        // Whole block border and background
                        'bg_color'         => '#ffffff', //ok
                        'bd_color'         => '#e0e0e0', //ok

                        // Text and links colors
                        'text'             => '#646464', //ok
                        'text_light'       => '#878787', //ok
                        'text_dark'        => '#121619', //ok
                        'text_link'        => '#f84c38', //ok light red
                        'text_hover'       => '#d43b2a', //ok dark red
                        'text_link2'       => '#2129cc', //ok light blue
                        'text_hover2'      => '#151db0', //ok dark blue
                        'text_link3'       => '#6dc579', //ok light green
                        'text_hover3'      => '#6eb678', //ok dark green

                        // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                        'alter_bg_color'   => '#f5f5fa', //ok
                        'alter_bg_hover'   => '#eaeaf0', //ok
                        'alter_bd_color'   => '#e0e0e0', //ok
                        'alter_bd_hover'   => '#dadada',
                        'alter_text'       => '#646464', //ok
                        'alter_light'      => '#878787', //ok
                        'alter_dark'       => '#121619', //ok
                        'alter_link'       => '#f84c38', //ok light red
                        'alter_hover'      => '#d43b2a', //ok dark red
                        'alter_link2'      => '#2129cc', //ok light blue
                        'alter_hover2'     => '#151db0', //ok dark blue
                        'alter_link3'      => '#6dc579', //ok light green
                        'alter_hover3'     => '#6eb678', //ok dark green

                        // Extra blocks (submenu, tabs, color blocks, etc.)
                        'extra_bg_color'   => '#121619', //ok dropdown bg
                        'extra_bg_hover'   => '#28272e',
                        'extra_bd_color'   => '#2e3337', //ok
                        'extra_bd_hover'   => '#3d3d3d',
                        'extra_text'       => '#646464', //ok
                        'extra_light'      => '#878787', //ok
                        'extra_dark'       => '#ffffff', //ok
                        'extra_link'       => '#121619', //ok menu main
                        'extra_hover'      => '#f84c38', //ok menu main
                        'extra_link2'      => '#cacaca', //ok menu dropdown
                        'extra_hover2'     => '#f84c38', //ok menu dropdown
                        'extra_link3'      => '#ddb837',
                        'extra_hover3'     => '#eec432',

                        // Input fields (form's fields and textarea)
                        'input_bg_color'   => '#ffffff', //ok
                        'input_bg_hover'   => '#ffffff', //ok
                        'input_bd_color'   => '#dfdfdf', //ok
                        'input_bd_hover'   => '#c5c5c5', //ok
                        'input_text'       => '#646464', //ok
                        'input_light'      => '#646464', //ok
                        'input_dark'       => '#646464', //ok

                        // Inverse blocks (text and links on the 'text_link' background)
                        'inverse_bg_color' => '#191e2d', //ok audio
                        'inverse_bg_hover' => '#191e2d', //ok pagination
                        'inverse_bd_color' => '#e0e0e0', //ok toggle border
                        'inverse_bd_hover' => '#2e3337', //ok table
                        'inverse_text'     => '#cfd0dc', //ok
                        'inverse_light'    => '#eff3f5', //ok
                        'inverse_dark'     => '#121619', //ok
                        'inverse_link'     => '#ffffff', //ok
                        'inverse_hover'    => '#ffffff', //ok
                        'inverse_link2'    => '#ffffff', //ok
                    ),
                ),

                // Color scheme: 'dark'
                'dark'    => array(
                    'title'    => esc_html__( 'Dark', 'rhodos' ),
                    'internal' => true,
                    'colors'   => array(

                        // Whole block border and background
                        'bg_color'         => '#07090e', //ok
                        'bd_color'         => '#2c3345', //ok

                        // Text and links colors
                        'text'             => '#cfd0dc', //ok
                        'text_light'       => '#eff3f5', //ok
                        'text_dark'        => '#ffffff', //ok
                        'text_link'        => '#f84c38', //ok light red
                        'text_hover'       => '#d43b2a', //ok dark red
                        'text_link2'       => '#2129cc', //ok light blue
                        'text_hover2'      => '#151db0', //ok dark blue
                        'text_link3'       => '#6dc579', //ok light green
                        'text_hover3'      => '#6eb678', //ok dark green

                        // Alternative blocks (sidebar, tabs, alternative blocks, etc.)
                        'alter_bg_color'   => '#191e2d', //ok
                        'alter_bg_hover'   => '#26292b', //ok
                        'alter_bd_color'   => '#2c3345', //ok
                        'alter_bd_hover'   => '#4a4a4a',
                        'alter_text'       => '#cfd0dc', //ok
                        'alter_light'      => '#eff3f5', //ok
                        'alter_dark'       => '#ffffff', //ok
                        'alter_link'       => '#f84c38', //ok light red
                        'alter_hover'      => '#d43b2a', //ok dark red
                        'alter_link2'      => '#2129cc', //ok light blue
                        'alter_hover2'     => '#151db0', //ok dark blue
                        'alter_link3'      => '#6dc579', //ok light green
                        'alter_hover3'     => '#6eb678', //ok dark green

                        // Extra blocks (submenu, tabs, color blocks, etc.)
                        'extra_bg_color'   => '#ffffff', //ok dropdown bg
                        'extra_bg_hover'   => '#f4f5f7', //ok
                        'extra_bd_color'   => '#ebebeb', //ok
                        'extra_bd_hover'   => '#4a4a4a',
                        'extra_text'       => '#646464', //ok
                        'extra_light'      => '#eff3f5', //ok
                        'extra_dark'       => '#121619', //ok
                        'extra_link'       => '#ffffff', //ok menu main
                        'extra_hover'      => '#ffffff', //ok menu main
                        'extra_link2'      => '#646464', //ok menu dropdown
                        'extra_hover2'     => '#f84c38', //ok menu dropdown
                        'extra_link3'      => '#ddb837',
                        'extra_hover3'     => '#eec432',

                        // Input fields (form's fields and textarea)
                        'input_bg_color'   => '#07090e', //ok
                        'input_bg_hover'   => '#191e2d', //ok
                        'input_bd_color'   => '#dadada', //ok
                        'input_bd_hover'   => '#dadada', //ok
                        'input_text'       => '#cfd0dc', //ok
                        'input_light'      => '#cfd0dc', //ok
                        'input_dark'       => '#ffffff', //ok

                        // Inverse blocks (text and links on the 'text_link' background)
                        'inverse_bg_color' => '#191e2d', //ok audio
                        'inverse_bg_hover' => '#f84c38', //ok pagination
                        'inverse_bd_color' => '#cfd8dc', //ok toggle border
                        'inverse_bd_hover' => '#2c3345', //ok table
                        'inverse_text'     => '#f4f4f4', //ok
                        'inverse_light'    => '#eff3f5', //ok
                        'inverse_dark'     => '#121619', //ok
                        'inverse_link'     => '#ffffff', //ok
                        'inverse_hover'    => '#121619', //ok
                        'inverse_link2'    => '#191e2d', //ok
                    ),
                ),

            )
        );
    }
}

// Shortcodes support
//------------------------------------------------------------------------

// Add new output types (layouts) in the shortcodes
if ( ! function_exists( 'rhodos_skin_trx_addons_sc_type' ) ) {
    add_filter( 'trx_addons_sc_type', 'rhodos_skin_trx_addons_sc_type', 10, 2 );
    function rhodos_skin_trx_addons_sc_type( $list, $sc ) {
        // To do: check shortcode slug and if correct - add new 'key' => 'title' to the list
        if ( 'trx_sc_icons' == $sc ) {
            $list['extra'] = 'Extra';
        }
        if ( 'trx_sc_testimonials' == $sc ) {
            $list['alter'] = 'Alter';
        }

        return $list;
    }
}

//------------------------------------------------------------------------
// One-click import support
//------------------------------------------------------------------------

// Set theme specific importer options
if ( ! function_exists( 'rhodos_skin_importer_set_options' ) ) {
    add_filter('trx_addons_filter_importer_options', 'rhodos_skin_importer_set_options', 9);
    function rhodos_skin_importer_set_options($options = array()) {
        if (is_array($options)) {
            // Designer CV demo
            $options['demo_type'] = 'designer-cv';
            $options['files']['designer-cv'] = $options['files']['default'];
            $options['files']['designer-cv']['title'] = esc_html__('Designer CV Demo', 'rhodos');
            $options['files']['designer-cv']['domain_demo'] = esc_url( rhodos_get_protocol() . '://designer-cv.rhodos.axiomthemes.com' );   // Demo-site domain
            unset($options['files']['default']);
        }
        return $options;
    }
}

// Hide Params in Elementor
if ( !function_exists('rhodos_skin_elm_hide_params_dependencies_in_section' ) ) {
    add_action('elementor/element/before_section_end', 'rhodos_skin_elm_hide_params_dependencies_in_section', 10, 3);
    function rhodos_skin_elm_hide_params_dependencies_in_section($element, $section_id, $args)    {

        if  ( 'trx_sc_testimonials' == $element->get_name() &&  'section_sc_testimonials' == $section_id ) {
            $element->update_control(
                'columns',
                [
                    'condition' => [
                        'type' => [ 'default', 'simple', 'alter'],
                    ],
                ]

            );
        }
    }
}
// Add new params to the default shortcode's atts
if ( ! function_exists( 'rhodos_skin_trx_addons_sc_atts' ) ) {
    add_filter( 'trx_addons_sc_atts', 'rhodos_skin_trx_addons_sc_atts', 10, 2 );
    function rhodos_skin_trx_addons_sc_atts( $atts, $sc ) {
        // Param 'noimage'
        if ( 'trx_sc_blogger' == $sc ) {
            $atts['noimage'] = '';
        }

        return $atts;
    }
}
// Add theme-specific controls to sections and columns
if ( ! function_exists( 'rhodos_skin_elm_add_hide_image_control' ) ) {
    add_action( 'elementor/element/before_section_end', 'rhodos_skin_elm_add_hide_image_control', 10, 3 );
    function rhodos_skin_elm_add_hide_image_control( $element, $section_id ) {
        if (!is_object($element)) return;
        $el_name = $element->get_name();

        if ( 'trx_sc_blogger' == $el_name && 'section_sc_blogger' === $section_id ) {
            $element->add_control(
                'noimage', array(
                    'type'         => \Elementor\Controls_Manager::SWITCHER,
                    'label'        => esc_html__( 'Featured Image', 'rhodos' ),
                    'label_off'    => esc_html__( 'Off', 'rhodos' ),
                    'label_on'     => esc_html__( 'On', 'rhodos' ),
                    'return_value' => '1',
                    'condition' => [
                        'type' => ['extra'],
                    ],
                )
            );
        }
    }
}


// Filter to add in the required plugins list
if ( ! function_exists( 'rhodos_skin_tgmpa_required_plugins' ) ) {
	add_filter( 'rhodos_filter_tgmpa_required_plugins', 'rhodos_skin_tgmpa_required_plugins' );
	function rhodos_skin_tgmpa_required_plugins( $list = array() ) {
		// ToDo: Check if plugin is in the 'required_plugins' and add his parameters to the TGMPA-list
		//       Replace 'skin-specific-plugin-slug' to the real slug of the plugin
		if ( rhodos_storage_isset( 'required_plugins', 'skin-specific-plugin-slug' ) ) {
			$list[] = array(
				'name'     => rhodos_storage_get_array( 'required_plugins', 'skin-specific-plugin-slug' ),
				'slug'     => 'skin-specific-plugin-slug',
				'required' => false,
			);
		}
		return $list;
	}
}

// Enqueue skin-specific styles and scripts
// Priority 1150 - after plugins-specific (1100), but before child theme (1200)
if ( ! function_exists( 'rhodos_skin_frontend_scripts' ) ) {
	add_action( 'wp_enqueue_scripts', 'rhodos_skin_frontend_scripts', 1150 );
	function rhodos_skin_frontend_scripts() {
		$rhodos_url = rhodos_get_file_url( RHODOS_SKIN_DIR . 'skin.css' );
		if ( '' != $rhodos_url ) {
			wp_enqueue_style( 'rhodos-skin-' . esc_attr( RHODOS_SKIN_NAME ), $rhodos_url, array(), null );
		}
		if ( rhodos_is_on( rhodos_get_theme_option( 'debug_mode' ) ) ) {
			$rhodos_url = rhodos_get_file_url( RHODOS_SKIN_DIR . 'skin.js' );
			if ( '' != $rhodos_url ) {
				wp_enqueue_script( 'rhodos-skin-' . esc_attr( RHODOS_SKIN_NAME ), $rhodos_url, array( 'jquery' ), null, true );
			}
		}
	}
}

// Enqueue skin-specific responsive styles
// Priority 2050 - after theme responsive 2000
if ( ! function_exists( 'rhodos_skin_styles_responsive' ) ) {
	add_action( 'wp_enqueue_scripts', 'rhodos_skin_styles_responsive', 2050 );
	function rhodos_skin_styles_responsive() {
		$rhodos_url = rhodos_get_file_url( RHODOS_SKIN_DIR . 'skin-responsive.css' );
		if ( '' != $rhodos_url ) {
			wp_enqueue_style( 'rhodos-skin-' . esc_attr( RHODOS_SKIN_NAME ) . '-responsive', $rhodos_url, array(), null );
		}
	}
}

// Merge custom scripts
if ( ! function_exists( 'rhodos_skin_merge_scripts' ) ) {
	add_filter( 'rhodos_filter_merge_scripts', 'rhodos_skin_merge_scripts' );
	function rhodos_skin_merge_scripts( $list ) {
		if ( rhodos_get_file_dir( RHODOS_SKIN_DIR . 'skin.js' ) != '' ) {
			$list[] = RHODOS_SKIN_DIR . 'skin.js';
		}
		return $list;
	}
}


// Add skin-specific colors and fonts to the custom CSS
require_once RHODOS_THEME_DIR . RHODOS_SKIN_DIR . 'skin-styles.php';

