<?php
// Add skin-specific colors and fonts to the custom CSS
if ( ! function_exists( 'rhodos_skin_get_css' ) ) {
	add_filter( 'rhodos_filter_get_css', 'rhodos_skin_get_css', 10, 2 );
	function rhodos_skin_get_css( $css, $args ) {

		if ( isset( $css['fonts'] ) && isset( $args['fonts'] ) ) {
			$fonts         = $args['fonts'];
			$css['fonts'] .= <<<CSS

CSS;
		}

		if ( isset( $css['vars'] ) && isset( $args['vars'] ) ) {
			$vars         = $args['vars'];
			$css['vars'] .= <<<CSS

CSS;
		}

		if ( isset( $css['colors'] ) && isset( $args['colors'] ) ) {
			$colors         = $args['colors'];
			$css['colors'] .= <<<CSS
			
			/* Menu  */
			.menu_mobile_inner a:hover,
            .menu_mobile_inner .current-menu-ancestor > a,
            .menu_mobile_inner .current-menu-item > a,
            .menu_mobile_inner .menu_mobile_nav_area li:hover:before,
            .menu_mobile_inner .menu_mobile_nav_area li.current-menu-ancestor:before,
            .menu_mobile_inner .menu_mobile_nav_area li.current-menu-item:before {
                color: {$colors['alter_link2']};
            }
            .menu_mobile_inner .social_item .social_icon {
                color: {$colors['alter_link2']};
            }
            .menu_mobile_close:hover:before,
            .menu_mobile_close:hover:after {
                border-color: {$colors['alter_link2']};
            }
			/* Sidebar  */
			.sidebar li > a {
                color: {$colors['alter_text']};
            }
            .sidebar li > a:hover {
                color: {$colors['alter_link']};
            }
			/* Scroll to top */
            .trx_addons_scroll_to_top,
            .trx_addons_cv .trx_addons_scroll_to_top {
                color: {$colors['inverse_link']};
                border-color: {$colors['text_link2']};
                background-color: {$colors['text_link2']};
            }
            .trx_addons_scroll_to_top:hover,
            .trx_addons_cv .trx_addons_scroll_to_top:hover {
                color: {$colors['inverse_link']};
                border-color: {$colors['text_hover2']};
                background-color: {$colors['text_hover2']};
            }
            /* Audio Player */
            .mejs-controls .mejs-button > button {
                color: {$colors['inverse_link']};
            }
            .mejs-controls .mejs-button > button:hover {
                color: {$colors['text_link2']};
            }
			
			/* Blog */
			.post_item_single .post_featured .post_meta_categories > a,
            .post_meta .post_categories > a,
            .post_layout_excerpt .post_meta_categories > a  {
                color: {$colors['inverse_link']};
                background-color: {$colors['text_link']};
            }
            .post_item_single .post_featured .post_meta_categories > a:hover,
            .post_meta .post_categories > a:hover,
            .post_layout_excerpt .post_meta_categories > a:hover  {
                color: {$colors['inverse_link']};
                background-color: {$colors['text_hover']};
            }
            .post_item .post_title a:hover {
                color: {$colors['text_link2']};
            }
            .post_meta_item.post_author:hover {
                color: {$colors['text_link2']};
            }
            .post_item_single .post_header .post_meta_item.post_author:hover {
                color: {$colors['text_link2']};
            }
            /* Woocommerce */
            /* Shop mode selector */
            .rhodos_shop_mode_buttons a {
                color: {$colors['text_dark']};
            }
            .rhodos_shop_mode_buttons a:hover {
                color: {$colors['text_link2']};
            }
            .shop_mode_thumbs .rhodos_shop_mode_buttons a.woocommerce_thumbs,
            .shop_mode_list .rhodos_shop_mode_buttons a.woocommerce_list {
                color: {$colors['text_link2']};
            }
            .post_featured.hover_shop .icons a {
                color: {$colors['inverse_link']} !important;
                border-color: {$colors['text_link2']} !important;
                background-color: {$colors['text_link2']} !important;
            }
            .post_featured.hover_shop .icons a:hover {
                color: {$colors['inverse_link']} !important;
                border-color: {$colors['text_hover2']} !important;
                background-color: {$colors['text_hover2']} !important;
            }
            aside.woocommerce .product-title:hover, aside.woocommerce .mini_cart_item > a:not(.remove):hover {
                color: {$colors['text_link2']};
            }
            .star-rating span,
            .star-rating:before {
                color: {$colors['text_link2']};
            }
            .woocommerce p.stars a {
                color: {$colors['text_link2']};
            }
            #review_form #respond p.form-submit input[type="submit"] {
                background-color: {$colors['text_link2']};
            }
            .trx_addons_attrib_item.trx_addons_attrib_selected {
                border-color: {$colors['text_link2']} !important;
            }
            /* WooCommerce */
            .woocommerce #respond input#submit,
            .woocommerce .button, .woocommerce-page .button,
            .woocommerce a.button, .woocommerce-page a.button,
            .woocommerce button.button, .woocommerce-page button.button,
            .woocommerce input.button, .woocommerce-page input.button,
            .woocommerce input[type="button"], .woocommerce-page input[type="button"],
            .woocommerce input[type="submit"], .woocommerce-page input[type="submit"],
            .woocommerce #respond input#submit.alt,
            .woocommerce a.button.alt,
            .woocommerce button.button.alt,
            .woocommerce input.button.alt {
                background-color: {$colors['text_link2']};
                -webkit-box-shadow: 0 9px 18px {$colors['text_link2_018']};
                -ms-box-shadow: 0 9px 18px {$colors['text_link2_018']};
                box-shadow: 0 9px 18px {$colors['text_link2_018']};
            }
            
            .woocommerce #respond input#submit:hover,
            .woocommerce .button:hover, .woocommerce-page .button:hover,
            .woocommerce a.button:hover, .woocommerce-page a.button:hover,
            .woocommerce button.button:hover, .woocommerce-page button.button:hover,
            .woocommerce input.button:hover, .woocommerce-page input.button:hover,
            .woocommerce input[type="button"]:hover, .woocommerce-page input[type="button"]:hover,
            .woocommerce input[type="submit"]:hover, .woocommerce-page input[type="submit"]:hover {
                background-color: {$colors['text_hover2']};
            }
            .woocommerce ul.cart_list li span .amount,
            .woocommerce ul.product_list_widget li span .amount, 
            .woocommerce-page ul.cart_list li span .amount,
            .woocommerce-page ul.product_list_widget li span .amount {
                color: {$colors['text_link2']};
            }
            .woocommerce .button.checkout,
            .woocommerce-page .button.checkout {
                background-color: {$colors['text_link']} !important;
                -webkit-box-shadow: 0 9px 18px {$colors['text_link_018']} !important;
                -ms-box-shadow: 0 9px 18px {$colors['text_link_018']} !important;
                box-shadow: 0 9px 18px {$colors['text_link_018']} !important;
            }
            .woocommerce .button.checkout:hover,
            .woocommerce-page .button.checkout:hover {
                background-color: {$colors['text_hover']} !important;
                -webkit-box-shadow: none !important;
                -ms-box-shadow: none !important;
                box-shadow: none !important;
            }
            
            .woocommerce .widget_price_filter .ui-slider .ui-slider-range,
            .woocommerce .widget_price_filter .ui-slider .ui-slider-handle {
                background-color: {$colors['text_link2']};
            }
            .woocommerce .price_slider_amount .button, 
            .woocommerce-page .price_slider_amount .button {
                background-color: {$colors['text_link2']};
            } 
            .woocommerce .price_slider_amount .button:hover, 
            .woocommerce-page .price_slider_amount .button:hover {
                background-color: {$colors['text_hover2']};
            }
            .woocommerce div.product p.price, .woocommerce div.product span.price {
                color: {$colors['text_link2']};
            } 
            .single-product ul.products li.product .post_data .price span.amount {
                color: {$colors['text_link2']};
            }
            
            .widget .product_list_widget li {
                color: {$colors['text_link2']};
            }
            .woocommerce ul.products li.product .post_header a {
                color: {$colors['alter_dark']};
            }
            .woocommerce ul.products li.product .post_header a:hover {
                color: {$colors['alter_link2']};
            }
            
            .woocommerce ul.products li.product .price, .woocommerce-page ul.products li.product .price,
            .woocommerce ul.products li.product .price ins, .woocommerce-page ul.products li.product .price ins {
                color: {$colors['alter_link2']};
            }
            .woocommerce span.amount, .woocommerce-page span.amount {
                color: {$colors['text_link2']};
            }

            /* Tag cloud */
            .sc_edd_details .downloads_page_tags .downloads_page_data > a,
            .widget_product_tag_cloud a,
            .widget_tag_cloud a {
                color: {$colors['inverse_hover']};
                background-color: {$colors['text_dark']};
            }
            .sc_edd_details .downloads_page_tags .downloads_page_data > a:hover,
            .widget_product_tag_cloud a:hover,
            .widget_tag_cloud a:hover {
                color: {$colors['inverse_link']} !important;
                background-color: {$colors['text_link']};
            }
            .scheme_self.sidebar .sc_edd_details .downloads_page_tags .downloads_page_data > a:hover,
            .scheme_self.sidebar .widget_product_tag_cloud a:hover,
            .scheme_self.sidebar .widget_tag_cloud a:hover {
                background-color: {$colors['alter_link']};
            }
            .widget_search input.search-submit,
            .woocommerce.widget_product_search .search_button,
            .widget_display_search #bbp_search_submit,
             #bbpress-forums #bbp-search-form #bbp_search_submit {
                 background-color: {$colors['text_link2']};
             }
			 .widget_search input.search-submit:hover,
             .woocommerce.widget_product_search .search_button:hover,
             .widget_display_search #bbp_search_submit:hover,
             #bbpress-forums #bbp-search-form #bbp_search_submit:hover {
                 background-color: {$colors['text_hover2']};
             }

			/* Cart */
            .sc_layouts_cart_items_short {
                background-color: {$colors['text_link2']};
                color: {$colors['inverse_link']};
            }
            .sc_layouts_cart_widget .sc_layouts_cart_widget_close:hover {
	            color: {$colors['text_link2']};
            }
            /* Compact Row */
            .sc_layouts_row_type_compact .sc_layouts_cart .sc_layouts_item_icon:hover,
            .scheme_self.sc_layouts_row_type_compact .sc_layouts_cart .sc_layouts_item_icon:hover {
                color: {$colors['text_link2']};
            }
            .sc_layouts_row_type_compact .search_style_fullscreen.search_opened .search_close:hover,
            .scheme_self.sc_layouts_row_type_compact .search_style_fullscreen.search_opened .search_close:hover {
             	color: {$colors['text_link2']} !important;
            }
            .sc_layouts_row_type_compact .sc_layouts_menu_mobile_button_burger .sc_layouts_item_link:hover .sc_layouts_item_icon,
            .scheme_self.sc_layouts_row_type_compact .sc_layouts_menu_mobile_button_burger .sc_layouts_item_link:hover .sc_layouts_item_icon {
                color: {$colors['text_link2']};
            }
            /* Search */
            .search_wrap .search_submit:hover:before {
	            color: {$colors['text_link2']};
            }
            /* MFP */
            .mfp-image-holder .mfp-close,
            .mfp-iframe-holder .mfp-close,
            .mfp-wrap .mfp-close {
                color: {$colors['text_link2']};
            }
            .mfp-image-holder .mfp-close:hover,
            .mfp-iframe-holder .mfp-close:hover,
            .mfp-close-btn-in .mfp-close:hover {
                color: {$colors['text_hover2']};
            }

			/* Revolution Slider */	
			/* bullets */
            rs-module .custom .tp-bullet {
               background: {$colors['inverse_link']};
            }
            rs-module .custom .tp-bullet:hover,
            rs-module .custom .tp-bullet.selected {
                background: {$colors['text_link2']};
            }
            rs-module .custom.tparrows {
                background: {$colors['alter_bg_color']};
            }
            rs-module .custom.tparrows:hover {
                background: {$colors['text_dark']};
            }   
            rs-module .custom.tparrows:before {
                 color:  {$colors['text_dark']};
            }
            rs-module .custom.tparrows:hover:before {
                color: {$colors['inverse_hover']};
            }
		
			/* Services */
			.sc_services_hover .sc_services_item_number,
			.sc_services_hover .sc_services_item_subtitle {
			    color: {$colors['inverse_light']};
			}
			.sc_services_hover .sc_services_item_icon {
			    color: {$colors['inverse_link']};
			}
			.sc_services_hover .sc_services_item_price {
			    color: {$colors['inverse_link']};
			}
			.sc_services_hover .sc_services_item_link:after {
			    border-color: {$colors['inverse_link']};
			}
			.sc_services_hover .sc_services_item.with_image .sc_services_item_header:before,
			.sc_services_hover .sc_services_item.with_image .sc_services_item_content:before {
                background: transparent;
            }
			.sc_services_hover .sc_services_item.with_image:hover .sc_services_item_header:before,
			.sc_services_hover .sc_services_item.with_image:hover .sc_services_item_content:before {
                background: transparent;
            }
            .sc_services_hover .sc_services_item.with_image .sc_services_item_header:after,
            .sc_services_hover .sc_services_item.with_image:hover .sc_services_item_header:after {
                background: {$colors['text_link']};
            }
            /* Specific Color */
            .sc_services_hover [class*="trx_addons_column-"]:nth-child(2n+1) .sc_services_item_header.specific_color:after {
                background: {$colors['text_link2']}; !important;
                color: {$colors['inverse_link']}; !important;;
            }
            
            /* MailChimp */
            form.mc4wp-form input[type="email"] {
                color: {$colors['input_text']};
                background-color:  {$colors['input_bg_color']};
                border-color: {$colors['input_bd_color']};
            }
            form.mc4wp-form input[type="email"].filled,
            form.mc4wp-form input[type="email"]:focus {
                color: {$colors['input_dark']};
                background-color: {$colors['input_bg_hover']};
                border-color:  {$colors['input_bd_hover']};
            }
            
            form.mc4wp-form input[type="checkbox"] + label:before {
                border-color:  {$colors['bd_color']} !important;
            }
            form.mc4wp-form input[type="checkbox"] + label {
                color: {$colors['text_dark']};
            }
            form.mc4wp-form input[type="checkbox"] + label > a {
                color: {$colors['text_dark']};
            }
            form.mc4wp-form input[type="checkbox"] + label > a:hover {
                color: {$colors['text_dark']};
            }
            
            .light_text_gdpr form.mc4wp-form input[type="checkbox"] + label:before {
              border-color:  {$colors['inverse_link']} !important;
            }
            .light_text_gdpr form.mc4wp-form input[type="checkbox"] + label {
                color: {$colors['inverse_link']};
            }
            .light_text_gdpr form.mc4wp-form input[type="checkbox"] + label > a {
                color: {$colors['inverse_link']};
            }
            .light_text_gdpr form.mc4wp-form input[type="checkbox"] + label > a:hover {
                color: {$colors['inverse_link']};
            }
            
            form.mc4wp-form .mc4wp_button {
                color: {$colors['text_dark']};
                background-color: transparent;
            }
            form.mc4wp-form .mc4wp_button:before {
                border-color:  {$colors['bd_color']};
            }
            form.mc4wp-form .mc4wp_button:after {
               color: {$colors['text_dark']};
            }
            form.mc4wp-form .mc4wp_button:hover:after {
               color: {$colors['text_link']};
            }
            /* Elementor Toggle */
            .elementor-toggle .elementor-tab-content {
                color: {$colors['text']};
            }
            .elementor-toggle .elementor-tab-title {
                color: {$colors['text_dark']};
                border-color: {$colors['alter_bg_color']};
                background-color: {$colors['alter_bg_color']};
            }
            .elementor-toggle .elementor-tab-title.elementor-active {
                color: {$colors['inverse_link']};
                border-color: {$colors['extra_bg_color']};
                background-color: {$colors['extra_bg_color']};
            }

            
		
CSS;
		}

		return $css;
	}
}

