<?php
/**
 * The template to display the widgets area in the header
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0
 */

// Header sidebar
$rhodos_header_name    = rhodos_get_theme_option( 'header_widgets' );
$rhodos_header_present = ! rhodos_is_off( $rhodos_header_name ) && is_active_sidebar( $rhodos_header_name );
if ( $rhodos_header_present ) {
	rhodos_storage_set( 'current_sidebar', 'header' );
	$rhodos_header_wide = rhodos_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $rhodos_header_name ) ) {
		dynamic_sidebar( $rhodos_header_name );
	}
	$rhodos_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $rhodos_widgets_output ) ) {
		$rhodos_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $rhodos_widgets_output );
		$rhodos_need_columns   = strpos( $rhodos_widgets_output, 'columns_wrap' ) === false;
		if ( $rhodos_need_columns ) {
			$rhodos_columns = max( 0, (int) rhodos_get_theme_option( 'header_columns' ) );
			if ( 0 == $rhodos_columns ) {
				$rhodos_columns = min( 6, max( 1, substr_count( $rhodos_widgets_output, '<aside ' ) ) );
			}
			if ( $rhodos_columns > 1 ) {
				$rhodos_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $rhodos_columns ) . ' widget', $rhodos_widgets_output );
			} else {
				$rhodos_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $rhodos_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $rhodos_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $rhodos_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'rhodos_action_before_sidebar' );
				rhodos_show_layout( $rhodos_widgets_output );
				do_action( 'rhodos_action_after_sidebar' );
				if ( $rhodos_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $rhodos_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
