<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0
 */

$rhodos_template_args = get_query_var( 'rhodos_template_args' );
if ( is_array( $rhodos_template_args ) ) {
	$rhodos_columns    = empty( $rhodos_template_args['columns'] ) ? 2 : max( 1, $rhodos_template_args['columns'] );
	$rhodos_blog_style = array( $rhodos_template_args['type'], $rhodos_columns );
} else {
	$rhodos_blog_style = explode( '_', rhodos_get_theme_option( 'blog_style' ) );
	$rhodos_columns    = empty( $rhodos_blog_style[1] ) ? 2 : max( 1, $rhodos_blog_style[1] );
}
$rhodos_post_format = get_post_format();
$rhodos_post_format = empty( $rhodos_post_format ) ? 'standard' : str_replace( 'post-format-', '', $rhodos_post_format );
$rhodos_animation   = rhodos_get_theme_option( 'blog_animation' );

?><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item'
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $rhodos_columns )
		. ' post_format_' . esc_attr( $rhodos_post_format )
		. ( is_sticky() && ! is_paged() ? ' sticky' : '' )
		. ( ! empty( $rhodos_template_args['slider'] ) ? ' slider-slide swiper-slide' : '' )
	);
	echo ( ! rhodos_is_off( $rhodos_animation ) && empty( $rhodos_template_args['slider'] ) ? ' data-animation="' . esc_attr( rhodos_get_animation_classes( $rhodos_animation ) ) . '"' : '' );
	?>
>
<?php

// Sticky label
if ( is_sticky() && ! is_paged() ) {
	?>
		<span class="post_label label_sticky"></span>
		<?php
}

	$rhodos_image_hover = ! empty( $rhodos_template_args['hover'] ) && ! rhodos_is_inherit( $rhodos_template_args['hover'] )
								? $rhodos_template_args['hover']
								: rhodos_get_theme_option( 'image_hover' );
	// Featured image
	rhodos_show_post_featured(
		array(
			'singular'      => false,
			'hover'         => $rhodos_image_hover,
			'no_links'      => ! empty( $rhodos_template_args['no_links'] ),
			'thumb_size'    => rhodos_get_thumb_size(
				strpos( rhodos_get_theme_option( 'body_style' ), 'full' ) !== false || $rhodos_columns < 3
								? 'masonry-big'
				: 'masonry'
			),
			'show_no_image' => true,
			'class'         => 'dots' == $rhodos_image_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $rhodos_image_hover ? '<div class="post_info">' . esc_html( get_the_title() ) . '</div>' : '',
		)
	);
	?>
</article><?php
// Need opening PHP-tag above, because article is a inline-block element (used as column)!