<?php
/**
 * The template for homepage posts with "Chess" style
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0
 */

rhodos_storage_set( 'blog_archive', true );

get_header();

if ( have_posts() ) {

	rhodos_blog_archive_start();

	$rhodos_stickies   = is_home() ? get_option( 'sticky_posts' ) : false;
	$rhodos_sticky_out = rhodos_get_theme_option( 'sticky_style' ) == 'columns'
							&& is_array( $rhodos_stickies ) && count( $rhodos_stickies ) > 0 && get_query_var( 'paged' ) < 1;
	if ( $rhodos_sticky_out ) {
		?>
		<div class="sticky_wrap columns_wrap">
		<?php
	}
	if ( ! $rhodos_sticky_out ) {
		?>
		<div class="chess_wrap posts_container">
		<?php
	}
	while ( have_posts() ) {
		the_post();
		if ( $rhodos_sticky_out && ! is_sticky() ) {
			$rhodos_sticky_out = false;
			?>
			</div><div class="chess_wrap posts_container">
			<?php
		}
		$rhodos_part = $rhodos_sticky_out && is_sticky() ? 'sticky' : 'chess';
		get_template_part( apply_filters( 'rhodos_filter_get_template_part', 'content', $rhodos_part ), $rhodos_part );
	}

	?>
	</div>
	<?php

	rhodos_show_pagination();

	rhodos_blog_archive_end();

} else {

	if ( is_search() ) {
		get_template_part( apply_filters( 'rhodos_filter_get_template_part', 'content', 'none-search' ), 'none-search' );
	} else {
		get_template_part( apply_filters( 'rhodos_filter_get_template_part', 'content', 'none-archive' ), 'none-archive' );
	}
}

get_footer();
