<?php
/* Revolution Slider support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'rhodos_revslider_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'rhodos_revslider_theme_setup9', 9 );
	function rhodos_revslider_theme_setup9() {

		add_filter( 'rhodos_filter_merge_styles', 'rhodos_revslider_merge_styles' );

		if ( is_admin() ) {
			add_filter( 'rhodos_filter_tgmpa_required_plugins', 'rhodos_revslider_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'rhodos_revslider_tgmpa_required_plugins' ) ) {
	
	function rhodos_revslider_tgmpa_required_plugins( $list = array() ) {
		if ( rhodos_storage_isset( 'required_plugins', 'revslider' ) && rhodos_is_theme_activated() ) {
			$path = rhodos_get_plugin_source_path( 'plugins/revslider/revslider.zip' );
			if ( ! empty( $path ) || rhodos_get_theme_setting( 'tgmpa_upload' ) ) {
				$list[] = array(
					'name'     => rhodos_storage_get_array( 'required_plugins', 'revslider' ),
					'slug'     => 'revslider',
					'version'   => '6.4.8',
					'source'   => ! empty( $path ) ? $path : 'upload://revslider.zip',
					'required' => false,
				);
			}
		}
		return $list;
	}
}

// Check if RevSlider installed and activated
if ( ! function_exists( 'rhodos_exists_revslider' ) ) {
	function rhodos_exists_revslider() {
		return function_exists( 'rev_slider_shortcode' );
	}
}

// Merge custom styles
if ( ! function_exists( 'rhodos_revslider_merge_styles' ) ) {
	
	function rhodos_revslider_merge_styles( $list ) {
		if ( rhodos_exists_revslider() ) {
			$list[] = 'plugins/revslider/_revslider.scss';
		}
		return $list;
	}
}

