<?php
/**
 * The style "default" of the Events
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.2
 */

$args = get_query_var('trx_addons_args_sc_events');

// Event's date
//start event date
$date = tribe_get_start_date(null, true, 'j M, Y');
$date_number = tribe_get_start_date(null, true, 'j');
$date_month = tribe_get_start_date(null, true, 'M');
$date_year = tribe_get_start_date(null, true, 'Y');
$time = tribe_get_start_time(null, 'g:iA');

if (empty($date)) $date = get_the_date('j M, Y');
if (empty($date_number)) $date_number = get_the_date('j');
if (empty($date_month)) $date_month = get_the_date('M');
if (empty($date_year)) $date_year = get_the_date('Y');

//end event date
$date2 = tribe_get_end_date(null, true, 'j M, Y');
$date2_number = tribe_get_end_date(null, true, 'j');
$date2_month = tribe_get_end_date(null, true, 'M');
$date2_year = tribe_get_end_date(null, true, 'Y');
$time2 = tribe_get_end_time(null, 'g:iA');

if (empty($date2)) $date2 = get_the_date('j M, Y');
if (empty($date2_number)) $date2_number = get_the_date('j');
if (empty($date2_month)) $date2_month = get_the_date('M');
if (empty($date2_year)) $date2_year = get_the_date('Y');


if ($args['slider']) {
	?><div class="slider-slide swiper-slide"><?php
} else if ($args['columns'] > 1) {
	?><div class="<?php echo esc_attr(trx_addons_get_column_class(1, $args['columns'])); ?>"><?php
}

    ?><div class="sc_events_item_wrap <?php echo  ( has_post_thumbnail() ? ' with_thumb' : ' without_thumb');?>"><?php
        if ( has_post_thumbnail()) {
            trx_addons_get_template_part('templates/tpl.featured.php',
                'trx_addons_args_featured',
                array(
                    'class' => 'sc_events_item_thumb',
                    'thumb_size' => apply_filters('trx_addons_filter_thumb_size', trx_addons_get_thumb_size($args['columns'] > 1 ? 'big' : 'extra') , 'events-default'),
                    'post_info' => '<div class="sc_events_item_date_start">'
                        . '<span class="sc_events_item_date_wrap">'
                        . '<span class="sc_events_item_date_month_number">'
                        . esc_html($date_number)
                        . '</span>'
                        . '<span class="sc_events_item_date_month">'
                        . esc_html($date_month)
                        . '</span>'
                        . '</span>'
                        . '</div>',
                )
            );
        }?>
        <div class="sc_events_item_content_wrapper">
            <div class="sc_events_item_content">
                <div class="sc_events_item_date"><?php
                    // Event's date
                    if ( $date === $date2 && !empty($time) ) { ?>
                        <span class="sc_events_item_time_date">
                            <span class="sc_events_item_date_start"><?php echo esc_html($time); ?></span>
                            <span class="sc_events_item_date_separator"><?php echo esc_html( ' - ' );?></span>
                            <span class="sc_events_item_date_end"><?php echo esc_html($time2); ?></span>
                        </span><?php

                    } elseif ( $date === $date2 && empty($time) ) {
                        ?><span class="sc_events_item_full_date">
                             <span class="sc_events_item_date_start"><?php echo esc_html($date);?></span>
                        </span><?php

                    } else {
                        ?><span class="sc_events_item_full_date">
                        <span class="sc_events_item_date_start"><?php echo esc_html($date. ' '); echo (esc_html($time) ? esc_html($time) : '');?></span>
                             <span class="sc_events_item_date_separator"><?php echo esc_html( ' - ' );?></span>
                             <span class="sc_events_item_date_end"><?php echo esc_html($date2. ' '); echo (esc_html($time2) ? esc_html($time2) : '');?></span>
                        </span><?php
                    } ?>
                </div>

                <h4 class="sc_events_item_title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4><?php

                if ( has_excerpt() ) { ?>
                    <div class="sc_events_item_content_inner"><?php
                        the_excerpt();
                    ?></div><?php
                }
            ?></div>
            <div class="sc_events_button_wrap">
                <a href="<?php the_permalink(); ?>" class="sc_events_item_link sc_button color_style_default"><?php esc_html_e('Read More','rhodos'); ?></a>
            </div>
        </div><?php

    ?></div><?php

if ($args['slider'] || $args['columns'] > 1) {
	?></div><?php
}

?>