<?php
// Add skin-specific colors and fonts to the custom CSS
if ( ! function_exists( 'rhodos_skin_get_css' ) ) {
	add_filter( 'rhodos_filter_get_css', 'rhodos_skin_get_css', 10, 2 );
	function rhodos_skin_get_css( $css, $args ) {

		if ( isset( $css['fonts'] ) && isset( $args['fonts'] ) ) {
			$fonts         = $args['fonts'];
			$css['fonts'] .= <<<CSS

CSS;
		}

		if ( isset( $css['vars'] ) && isset( $args['vars'] ) ) {
			$vars         = $args['vars'];
			$css['vars'] .= <<<CSS

CSS;
		}

		if ( isset( $css['colors'] ) && isset( $args['colors'] ) ) {
			$colors         = $args['colors'];
			$css['colors'] .= <<<CSS
			
			
			/* Blogger */
			.sc_blogger_extra .sc_blogger_item_content_wrapper .post_meta_bottom .post_meta .post_author .author_by {
				color: {$colors['text']};
			}
            .sc_blogger_extra .sc_blogger_item_content_wrapper .post_meta_bottom .post_meta .post_meta_item.post_author {
                color: {$colors['text_dark']};
            }
            .sc_blogger_extra .sc_blogger_item_content_wrapper .post_meta_bottom .post_meta .post_meta_item.post_author:hover {
                color: {$colors['text_link']};
            }
            .sc_blogger_extra .sc_blogger_item .sc_blogger_item_content_wrapper {
                border-color: {$colors['bd_color']};
            }
               /* Testimonials */
            .sc_testimonials_alter .sc_testimonials_item_content {
                background-color: {$colors['bg_color']};
            }
            .sc_testimonials_alter  .sc_testimonials_item_content:after {
                border-top-color: {$colors['bg_color']};
            }
            .sc_testimonials_alter .slider_container .sc_testimonials_item_content:before {
                color: {$colors['bd_color']};
            }
            .sc_testimonials_alter .slider_container .slider-slide.swiper-slide-active + .swiper-slide .sc_testimonials_item_content:before {
                color: {$colors['text_link']};
            }
            .sc_testimonials_alter.color_style_link2 .slider_container .slider-slide.swiper-slide-active + .swiper-slide .sc_testimonials_item_content:before {
                color: {$colors['text_link2']};
            }
            .sc_testimonials_alter.color_style_link2  .sc_testimonials_item_author_title {
                color: {$colors['text_dark']};
            }
            .sc_testimonials_alter.color_style_link3 .slider_container .slider-slide.swiper-slide-active + .swiper-slide .sc_testimonials_item_content:before {
                color: {$colors['text_link3']};
            }
            .sc_testimonials_alter.color_style_dark .slider_container .slider-slide.swiper-slide-active + .swiper-slide .sc_testimonials_item_content:before {
                color: {$colors['text_dark']};
            }
            
			/* Breadcrumbs  delimiter*/
			.sc_layouts_title_breadcrumbs .breadcrumbs_delimiter:before {
			    color: {$colors['text_link3']};
			}
			/* Excerpt */
			.post_item_single .post_featured .post_meta_categories > a,
			.post_meta .post_categories > a,
			.post_layout_excerpt .post_meta_categories > a {
			    background-color: {$colors['text_link3']};
			}
			.post_item_single .post_featured .post_meta_categories > a:hover,
			.post_meta .post_categories > a:hover,
			.post_layout_excerpt .post_meta_categories > a:hover {
			    background-color: {$colors['text_hover3']};
			}
			.post_item_single .post_header .post_meta_item.post_categories a {
			    background-color: {$colors['text_link3']};
			}
            .post_item_single .post_header .post_meta_item.post_categories a:hover {
			    background-color: {$colors['text_hover3']};
			}
			.sc_edd_details .downloads_page_tags .downloads_page_data > a:hover,
			.widget_product_tag_cloud a:hover,
			.widget_tag_cloud a:hover {
                background-color: {$colors['text_link3']};
            }
            .post_item_single .post_content .post_tags a:hover {
                background-color: {$colors['text_link3']};
            }
            /* Action */
            .sc_button.sc_action_item_link {
                color: {$colors['inverse_link']} !important;
                background-color: {$colors['text_link']} !important;
                -webkit-box-shadow: 0 9px 18px {$colors['text_link_018']} !important;
                -ms-box-shadow: 0 9px 18px {$colors['text_link_018']} !important;
                box-shadow: 0 9px 18px {$colors['text_link_018']} !important;
            }
            .sc_button.sc_action_item_link:hover {
                color: {$colors['inverse_link']} !important;
                background-color: {$colors['text_hover']} !important;
                -webkit-box-shadow: none !important;
                -ms-box-shadow: none !important;
                box-shadow: none !important;
            }
			
			/* MailChimp */
			form.mc4wp-form input[type="checkbox"] + label > a {
			    color: {$colors['inverse_link']};
			}
			
			/* Elementor Toggle */
            .elementor-toggle .elementor-tab-content {
                color: {$colors['text']};
            }
            .elementor-toggle .elementor-tab-title {
                color: {$colors['text_dark']};
                border-color: {$colors['alter_bg_color']};
                background-color: {$colors['alter_bg_color']};
            }
            .elementor-toggle .elementor-tab-title.elementor-active {
                color: {$colors['inverse_link']};
                border-color: {$colors['inverse_bg_color']};
                background-color: {$colors['inverse_bg_color']};
            }
            /* List Style */
            ul[class*="trx_addons_list"] > li:before {
                 color: {$colors['text_link3']};
            }
            .sc_price_item_link.sc_button {
                 color: {$colors['inverse_link']} !important;
                 background-color: {$colors['text_link']} !important;
                -webkit-box-shadow: 0 9px 18px {$colors['text_link_018']} !important;
                 -ms-box-shadow: 0 9px 18px {$colors['text_link_018']} !important;
                 box-shadow: 0 9px 18px {$colors['text_link_018']} !important;
               
            }
            .sc_price_item_link.sc_button:hover {
                 color: {$colors['inverse_link']} !important;
                 background-color: {$colors['text_hover']} !important;
                 -webkit-box-shadow: none !important;
                 -ms-box-shadow: none !important;
                 box-shadow: none !important;
            }

            /* Form Messages */
            span.wpcf7-not-valid-tip {
                color: {$colors['text_link']};
            }
             div.wpcf7-validation-errors, 
             div.wpcf7-acceptance-missing {
              border-color: {$colors['text_link']};
            }
            .trx_addons_field_error, 
            .wpcf7-not-valid {
                 border-color: {$colors['text_link']} !important;
            }  
            div.wpcf7-mail-sent-ok {
                 border-color: {$colors['text_link3']}
            }
            .trx_addons_message_box_error {
                border-color: {$colors['text_link']};
            }
            .trx_addons_message_box_success {
                border-color: {$colors['text_link3']};
            }
            form .error_field {
                border-color: {$colors['text_link']} !important;
            }
           

CSS;
		}

		return $css;
	}
}

