<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
if ( ! rhodos_is_inherit( rhodos_get_theme_option( 'copyright_scheme' ) ) ) {
	echo ' scheme_' . esc_attr( rhodos_get_theme_option( 'copyright_scheme' ) );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$rhodos_copyright = rhodos_get_theme_option( 'copyright' );
			if ( ! empty( $rhodos_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$rhodos_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $rhodos_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$rhodos_copyright = rhodos_prepare_macros( $rhodos_copyright );
				// Display copyright
				echo wp_kses( nl2br( $rhodos_copyright ), 'rhodos_kses_content' );
			}
			?>
			</div>
		</div>
	</div>
</div>
