<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0.06
 */

$rhodos_header_css   = '';
$rhodos_header_image = get_header_image();
$rhodos_header_video = rhodos_get_header_video();
if ( ! empty( $rhodos_header_image ) && rhodos_trx_addons_featured_image_override( is_singular() || rhodos_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$rhodos_header_image = rhodos_get_current_mode_image( $rhodos_header_image );
}

$rhodos_header_id = rhodos_get_custom_header_id();
$rhodos_header_meta = get_post_meta( $rhodos_header_id, 'trx_addons_options', true );
if ( ! empty( $rhodos_header_meta['margin'] ) ) {
	rhodos_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( rhodos_prepare_css_value( $rhodos_header_meta['margin'] ) ) ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $rhodos_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $rhodos_header_id ) ) ); ?>
				<?php
				echo ! empty( $rhodos_header_image ) || ! empty( $rhodos_header_video )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $rhodos_header_video ) {
					echo ' with_bg_video';
				}
				if ( '' != $rhodos_header_image ) {
					echo ' ' . esc_attr( rhodos_add_inline_css_class( 'background-image: url(' . esc_url( $rhodos_header_image ) . ');' ) );
				}
				if ( is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				if ( rhodos_is_on( rhodos_get_theme_option( 'header_fullheight' ) ) ) {
					echo ' header_fullheight rhodos-full-height';
				}
				if ( ! rhodos_is_inherit( rhodos_get_theme_option( 'header_scheme' ) ) ) {
					echo ' scheme_' . esc_attr( rhodos_get_theme_option( 'header_scheme' ) );
				}
				?>
">
	<?php

	// Background video
	if ( ! empty( $rhodos_header_video ) ) {
		get_template_part( apply_filters( 'rhodos_filter_get_template_part', 'templates/header-video' ) );
	}

	// Custom header's layout
	do_action( 'rhodos_action_show_layout', $rhodos_header_id );

	// Header widgets area
	get_template_part( apply_filters( 'rhodos_filter_get_template_part', 'templates/header-widgets' ) );

	?>
</header>
