<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0
 */
$rhodos_template_args = get_query_var( 'rhodos_template_args' );
if ( is_array( $rhodos_template_args ) ) {
	$rhodos_columns    = empty( $rhodos_template_args['columns'] ) ? 2 : max( 1, $rhodos_template_args['columns'] );
	$rhodos_blog_style = array( $rhodos_template_args['type'], $rhodos_columns );
	if ( ! empty( $rhodos_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $rhodos_columns > 1 ) {
		?>
		<div class="column-1_<?php echo esc_attr( $rhodos_columns ); ?>">
		<?php
	}
}
$rhodos_expanded    = ! rhodos_sidebar_present() && rhodos_is_on( rhodos_get_theme_option( 'expand_content' ) );
$rhodos_post_format = get_post_format();
$rhodos_post_format = empty( $rhodos_post_format ) ? 'standard' : str_replace( 'post-format-', '', $rhodos_post_format );
$rhodos_animation   = rhodos_get_theme_option( 'blog_animation' );

$rhodos_hover = ! empty( $rhodos_template_args['hover'] ) && ! rhodos_is_inherit( $rhodos_template_args['hover'] )
                    ? $rhodos_template_args['hover']
                    : rhodos_get_theme_option( 'image_hover' );


$has_thumb = has_post_thumbnail();
$extra_el = false;
if(!$has_thumb && in_array($rhodos_post_format, array('gallery')) && !rhodos_exists_trx_addons()) {
    $extra_el = true;
}

$cats = get_post_type()=='post' ? get_the_category_list(' ') : apply_filters('rhodos_filter_get_post_categories', '');
if (in_array($rhodos_post_format, array('gallery')) || (!in_array($rhodos_post_format, array('audio')) && has_post_thumbnail() && !empty($cats) ) ) {
    $cats = '<span class="post_meta_categories">'.$cats.'</span>';
} else {
    $cats = '';
}

if($extra_el) {
    $cats = '';
}

?>
<article id="post-<?php the_ID(); ?>"
    <?php post_class( 'post_item post_layout_excerpt post_format_' . esc_attr( $rhodos_post_format ).esc_attr((!empty($cats) ? ' cat-on' : ' cat-off')) ); ?>
	<?php echo ( ! rhodos_is_off( $rhodos_animation ) && empty( $rhodos_template_args['slider'] ) ? ' data-animation="' . esc_attr( rhodos_get_animation_classes( $rhodos_animation ) ) . '"' : '' ); ?>
	>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

		// Title and post meta
	if ( get_the_title() != '' && in_array($rhodos_post_format, array('audio')) ) {
		?>
		<div class="post_header entry-header">
			<?php

			do_action( 'rhodos_action_before_post_meta' );

			// Post meta
			$rhodos_components = rhodos_array_get_keys_by_value( rhodos_get_theme_option( 'meta_parts' ) );
			$rhodos_counters   = rhodos_array_get_keys_by_value( rhodos_get_theme_option( 'counters' ) );

			if ( ! empty( $rhodos_components ) && ! in_array( $rhodos_hover, array( 'border', 'pull', 'slide', 'fade' ) ) ) {
				rhodos_show_post_meta(
					apply_filters(
						'rhodos_filter_post_meta_args', array(
							'components' => $rhodos_components,
							'counters'   => $rhodos_counters,
							'seo'        => false,
						), 'excerpt', 1
					)
				);
			}

			do_action( 'rhodos_action_before_post_title' );

			// Post title
			if ( empty( $rhodos_template_args['no_links'] ) ) {
				the_title( sprintf( '<h2 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
			} else {
				the_title( '<h2 class="post_title entry-title">', '</h2>' );
			}
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Featured image
	rhodos_show_post_featured(
		array(
			'singular'   => false,
			'no_links'   => ! empty( $rhodos_template_args['no_links'] ),
			'hover'      => $rhodos_hover,
			'thumb_size' => rhodos_get_thumb_size( strpos( rhodos_get_theme_option( 'body_style' ), 'full' ) !== false ? 'full' : ( $rhodos_expanded ? 'huge' : 'big' ) ),
			'post_info' => $cats,
		)
	);



	// Title and post meta
	if ( get_the_title() != '' && !in_array($rhodos_post_format, array('audio')) ) {
		?>
		<div class="post_header entry-header">
			<?php

			do_action( 'rhodos_action_before_post_meta' );

			// Post meta
			$rhodos_components = rhodos_array_get_keys_by_value( rhodos_get_theme_option( 'meta_parts' ) );
			$rhodos_counters   = rhodos_array_get_keys_by_value( rhodos_get_theme_option( 'counters' ) );

			if ( ! empty( $rhodos_components ) && ! in_array( $rhodos_hover, array( 'border', 'pull', 'slide', 'fade' ) ) ) {
				rhodos_show_post_meta(
					apply_filters(
						'rhodos_filter_post_meta_args', array(
							'components' => $rhodos_components,
							'counters'   => $rhodos_counters,
							'seo'        => false,
						), 'excerpt', 1
					)
				);
			}

			do_action( 'rhodos_action_before_post_title' );

			// Post title
			if ( empty( $rhodos_template_args['no_links'] ) ) {
				the_title( sprintf( '<h2 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
			} else {
				the_title( '<h2 class="post_title entry-title">', '</h2>' );
			}
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	if ( empty( $rhodos_template_args['hide_excerpt'] ) ) {

		?>
		<div class="post_content entry-content">
		<?php
		if ( rhodos_get_theme_option( 'blog_content' ) == 'fullpost' ) {
			// Post content area
			?>
				<div class="post_content_inner">
				<?php
				the_content( '' );
				?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'rhodos' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'rhodos' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
		} else {
			// Post content area
			?>
				<div class="post_content_inner">
				<?php
				if ( has_excerpt() ) {
						the_excerpt();
				} elseif ( strpos( get_the_content( '!--more' ), '!--more' ) !== false ) {
						the_content( '' );
				} elseif ( in_array( $rhodos_post_format, array( 'link', 'aside', 'status' ) ) ) {
						the_content();
				} else if (in_array($rhodos_post_format, array('audio'))) {

				} elseif ( 'quote' == $rhodos_post_format ) {
					$quote = rhodos_get_tag( get_the_content(), '<blockquote>', '</blockquote>' );
					if ( ! empty( $quote ) ) {
						rhodos_show_layout( wpautop( $quote ) );
					} else {
						the_excerpt();
					}
				} elseif ( substr( get_the_content(), 0, 4 ) != '[vc_' ) {
					the_excerpt();
				}
				?>
				</div>
				<?php
				// More button
				if ( get_the_title() == '' && empty( $rhodos_template_args['no_links'] ) && ! in_array( $rhodos_post_format, array( 'link', 'aside', 'status', 'quote' ) ) ) {
					?>
					<p><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e( 'Read more', 'rhodos' ); ?></a></p>
					<?php
				}
		}
		?>
		</div><!-- .entry-content -->
		<?php
	}
	?>
	</article>
<?php

if ( is_array( $rhodos_template_args ) ) {
	if ( ! empty( $rhodos_template_args['slider'] ) || $rhodos_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
