<?php
/**
 * The Gallery template to display posts
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0
 */

$rhodos_template_args = get_query_var( 'rhodos_template_args' );
if ( is_array( $rhodos_template_args ) ) {
	$rhodos_columns    = empty( $rhodos_template_args['columns'] ) ? 2 : max( 1, $rhodos_template_args['columns'] );
	$rhodos_blog_style = array( $rhodos_template_args['type'], $rhodos_columns );
} else {
	$rhodos_blog_style = explode( '_', rhodos_get_theme_option( 'blog_style' ) );
	$rhodos_columns    = empty( $rhodos_blog_style[1] ) ? 2 : max( 1, $rhodos_blog_style[1] );
}
$rhodos_post_format = get_post_format();
$rhodos_post_format = empty( $rhodos_post_format ) ? 'standard' : str_replace( 'post-format-', '', $rhodos_post_format );
$rhodos_animation   = rhodos_get_theme_option( 'blog_animation' );
$rhodos_image       = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );

?><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item'
		. ' post_layout_portfolio'
		. ' post_layout_gallery'
		. ' post_layout_gallery_' . esc_attr( $rhodos_columns )
		. ' post_format_' . esc_attr( $rhodos_post_format )
		. ( ! empty( $rhodos_template_args['slider'] ) ? ' slider-slide swiper-slide' : '' )
	);
	echo ( ! rhodos_is_off( $rhodos_animation ) && empty( $rhodos_template_args['slider'] ) ? ' data-animation="' . esc_attr( rhodos_get_animation_classes( $rhodos_animation ) ) . '"' : '' );
	?>
	data-size="
		<?php
		if ( ! empty( $rhodos_image[1] ) && ! empty( $rhodos_image[2] ) ) {
			echo intval( $rhodos_image[1] ) . 'x' . intval( $rhodos_image[2] );}
		?>
	"
	data-src="
		<?php
		if ( ! empty( $rhodos_image[0] ) ) {
			echo esc_url( $rhodos_image[0] );}
		?>
	"
>
<?php

	// Sticky label
if ( is_sticky() && ! is_paged() ) {
	?>
		<span class="post_label label_sticky"></span>
		<?php
}

	// Featured image
	$rhodos_image_hover = 'icon'; 
if ( in_array( $rhodos_image_hover, array( 'icons', 'zoom' ) ) ) {
	$rhodos_image_hover = 'dots';
}
$rhodos_components = rhodos_array_get_keys_by_value( rhodos_get_theme_option( 'meta_parts' ) );
$rhodos_counters   = rhodos_array_get_keys_by_value( rhodos_get_theme_option( 'counters' ) );
rhodos_show_post_featured(
	array(
		'hover'         => $rhodos_image_hover,
		'singular'      => false,
		'no_links'      => ! empty( $rhodos_template_args['no_links'] ),
		'thumb_size'    => rhodos_get_thumb_size( strpos( rhodos_get_theme_option( 'body_style' ), 'full' ) !== false || $rhodos_columns < 3 ? 'masonry-big' : 'masonry' ),
		'thumb_only'    => true,
		'show_no_image' => true,
		'post_info'     => '<div class="post_details">'
						. '<h2 class="post_title">'
							. ( empty( $rhodos_template_args['no_links'] )
								? '<a href="' . esc_url( get_permalink() ) . '">' . esc_html( get_the_title() ) . '</a>'
								: esc_html( get_the_title() )
								)
						. '</h2>'
						. '<div class="post_description">'
							. ( ! empty( $rhodos_components )
								? rhodos_show_post_meta(
									apply_filters(
										'rhodos_filter_post_meta_args', array(
											'components' => $rhodos_components,
											'counters' => $rhodos_counters,
											'seo'      => false,
											'echo'     => false,
										), $rhodos_blog_style[0], $rhodos_columns
									)
								)
								: ''
								)
							. ( empty( $rhodos_template_args['hide_excerpt'] )
								? '<div class="post_description_content">' . get_the_excerpt() . '</div>'
								: ''
								)
							. ( empty( $rhodos_template_args['no_links'] )
								? '<a href="' . esc_url( get_permalink() ) . '" class="theme_button post_readmore"><span class="post_readmore_label">' . esc_html__( 'Learn more', 'rhodos' ) . '</span></a>'
								: ''
								)
						. '</div>'
					. '</div>',
	)
);
?>
</article><?php
// Need opening PHP-tag above, because article is a inline-block element (used as column)!
