<?php
/**
 * Theme storage manipulations
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) {
	exit; }

// Get theme variable
if ( ! function_exists( 'rhodos_storage_get' ) ) {
	function rhodos_storage_get( $var_name, $default = '' ) {
		global $RHODOS_STORAGE;
		return isset( $RHODOS_STORAGE[ $var_name ] ) ? $RHODOS_STORAGE[ $var_name ] : $default;
	}
}

// Set theme variable
if ( ! function_exists( 'rhodos_storage_set' ) ) {
	function rhodos_storage_set( $var_name, $value ) {
		global $RHODOS_STORAGE;
		$RHODOS_STORAGE[ $var_name ] = $value;
	}
}

// Check if theme variable is empty
if ( ! function_exists( 'rhodos_storage_empty' ) ) {
	function rhodos_storage_empty( $var_name, $key = '', $key2 = '' ) {
		global $RHODOS_STORAGE;
		if ( ! empty( $key ) && ! empty( $key2 ) ) {
			return empty( $RHODOS_STORAGE[ $var_name ][ $key ][ $key2 ] );
		} elseif ( ! empty( $key ) ) {
			return empty( $RHODOS_STORAGE[ $var_name ][ $key ] );
		} else {
			return empty( $RHODOS_STORAGE[ $var_name ] );
		}
	}
}

// Check if theme variable is set
if ( ! function_exists( 'rhodos_storage_isset' ) ) {
	function rhodos_storage_isset( $var_name, $key = '', $key2 = '' ) {
		global $RHODOS_STORAGE;
		if ( ! empty( $key ) && ! empty( $key2 ) ) {
			return isset( $RHODOS_STORAGE[ $var_name ][ $key ][ $key2 ] );
		} elseif ( ! empty( $key ) ) {
			return isset( $RHODOS_STORAGE[ $var_name ][ $key ] );
		} else {
			return isset( $RHODOS_STORAGE[ $var_name ] );
		}
	}
}

// Inc/Dec theme variable with specified value
if ( ! function_exists( 'rhodos_storage_inc' ) ) {
	function rhodos_storage_inc( $var_name, $value = 1 ) {
		global $RHODOS_STORAGE;
		if ( empty( $RHODOS_STORAGE[ $var_name ] ) ) {
			$RHODOS_STORAGE[ $var_name ] = 0;
		}
		$RHODOS_STORAGE[ $var_name ] += $value;
	}
}

// Concatenate theme variable with specified value
if ( ! function_exists( 'rhodos_storage_concat' ) ) {
	function rhodos_storage_concat( $var_name, $value ) {
		global $RHODOS_STORAGE;
		if ( empty( $RHODOS_STORAGE[ $var_name ] ) ) {
			$RHODOS_STORAGE[ $var_name ] = '';
		}
		$RHODOS_STORAGE[ $var_name ] .= $value;
	}
}

// Get array (one or two dim) element
if ( ! function_exists( 'rhodos_storage_get_array' ) ) {
	function rhodos_storage_get_array( $var_name, $key, $key2 = '', $default = '' ) {
		global $RHODOS_STORAGE;
		if ( empty( $key2 ) ) {
			return ! empty( $var_name ) && ! empty( $key ) && isset( $RHODOS_STORAGE[ $var_name ][ $key ] ) ? $RHODOS_STORAGE[ $var_name ][ $key ] : $default;
		} else {
			return ! empty( $var_name ) && ! empty( $key ) && isset( $RHODOS_STORAGE[ $var_name ][ $key ][ $key2 ] ) ? $RHODOS_STORAGE[ $var_name ][ $key ][ $key2 ] : $default;
		}
	}
}

// Set array element
if ( ! function_exists( 'rhodos_storage_set_array' ) ) {
	function rhodos_storage_set_array( $var_name, $key, $value ) {
		global $RHODOS_STORAGE;
		if ( ! isset( $RHODOS_STORAGE[ $var_name ] ) ) {
			$RHODOS_STORAGE[ $var_name ] = array();
		}
		if ( '' === $key ) {
			$RHODOS_STORAGE[ $var_name ][] = $value;
		} else {
			$RHODOS_STORAGE[ $var_name ][ $key ] = $value;
		}
	}
}

// Set two-dim array element
if ( ! function_exists( 'rhodos_storage_set_array2' ) ) {
	function rhodos_storage_set_array2( $var_name, $key, $key2, $value ) {
		global $RHODOS_STORAGE;
		if ( ! isset( $RHODOS_STORAGE[ $var_name ] ) ) {
			$RHODOS_STORAGE[ $var_name ] = array();
		}
		if ( ! isset( $RHODOS_STORAGE[ $var_name ][ $key ] ) ) {
			$RHODOS_STORAGE[ $var_name ][ $key ] = array();
		}
		if ( '' === $key2 ) {
			$RHODOS_STORAGE[ $var_name ][ $key ][] = $value;
		} else {
			$RHODOS_STORAGE[ $var_name ][ $key ][ $key2 ] = $value;
		}
	}
}

// Merge array elements
if ( ! function_exists( 'rhodos_storage_merge_array' ) ) {
	function rhodos_storage_merge_array( $var_name, $key, $value ) {
		global $RHODOS_STORAGE;
		if ( ! isset( $RHODOS_STORAGE[ $var_name ] ) ) {
			$RHODOS_STORAGE[ $var_name ] = array();
		}
		if ( '' === $key ) {
			$RHODOS_STORAGE[ $var_name ] = array_merge( $RHODOS_STORAGE[ $var_name ], $value );
		} else {
			$RHODOS_STORAGE[ $var_name ][ $key ] = array_merge( $RHODOS_STORAGE[ $var_name ][ $key ], $value );
		}
	}
}

// Add array element after the key
if ( ! function_exists( 'rhodos_storage_set_array_after' ) ) {
	function rhodos_storage_set_array_after( $var_name, $after, $key, $value = '' ) {
		global $RHODOS_STORAGE;
		if ( ! isset( $RHODOS_STORAGE[ $var_name ] ) ) {
			$RHODOS_STORAGE[ $var_name ] = array();
		}
		if ( is_array( $key ) ) {
			rhodos_array_insert_after( $RHODOS_STORAGE[ $var_name ], $after, $key );
		} else {
			rhodos_array_insert_after( $RHODOS_STORAGE[ $var_name ], $after, array( $key => $value ) );
		}
	}
}

// Add array element before the key
if ( ! function_exists( 'rhodos_storage_set_array_before' ) ) {
	function rhodos_storage_set_array_before( $var_name, $before, $key, $value = '' ) {
		global $RHODOS_STORAGE;
		if ( ! isset( $RHODOS_STORAGE[ $var_name ] ) ) {
			$RHODOS_STORAGE[ $var_name ] = array();
		}
		if ( is_array( $key ) ) {
			rhodos_array_insert_before( $RHODOS_STORAGE[ $var_name ], $before, $key );
		} else {
			rhodos_array_insert_before( $RHODOS_STORAGE[ $var_name ], $before, array( $key => $value ) );
		}
	}
}

// Push element into array
if ( ! function_exists( 'rhodos_storage_push_array' ) ) {
	function rhodos_storage_push_array( $var_name, $key, $value ) {
		global $RHODOS_STORAGE;
		if ( ! isset( $RHODOS_STORAGE[ $var_name ] ) ) {
			$RHODOS_STORAGE[ $var_name ] = array();
		}
		if ( '' === $key ) {
			array_push( $RHODOS_STORAGE[ $var_name ], $value );
		} else {
			if ( ! isset( $RHODOS_STORAGE[ $var_name ][ $key ] ) ) {
				$RHODOS_STORAGE[ $var_name ][ $key ] = array();
			}
			array_push( $RHODOS_STORAGE[ $var_name ][ $key ], $value );
		}
	}
}

// Pop element from array
if ( ! function_exists( 'rhodos_storage_pop_array' ) ) {
	function rhodos_storage_pop_array( $var_name, $key = '', $defa = '' ) {
		global $RHODOS_STORAGE;
		$rez = $defa;
		if ( '' === $key ) {
			if ( isset( $RHODOS_STORAGE[ $var_name ] ) && is_array( $RHODOS_STORAGE[ $var_name ] ) && count( $RHODOS_STORAGE[ $var_name ] ) > 0 ) {
				$rez = array_pop( $RHODOS_STORAGE[ $var_name ] );
			}
		} else {
			if ( isset( $RHODOS_STORAGE[ $var_name ][ $key ] ) && is_array( $RHODOS_STORAGE[ $var_name ][ $key ] ) && count( $RHODOS_STORAGE[ $var_name ][ $key ] ) > 0 ) {
				$rez = array_pop( $RHODOS_STORAGE[ $var_name ][ $key ] );
			}
		}
		return $rez;
	}
}

// Inc/Dec array element with specified value
if ( ! function_exists( 'rhodos_storage_inc_array' ) ) {
	function rhodos_storage_inc_array( $var_name, $key, $value = 1 ) {
		global $RHODOS_STORAGE;
		if ( ! isset( $RHODOS_STORAGE[ $var_name ] ) ) {
			$RHODOS_STORAGE[ $var_name ] = array();
		}
		if ( empty( $RHODOS_STORAGE[ $var_name ][ $key ] ) ) {
			$RHODOS_STORAGE[ $var_name ][ $key ] = 0;
		}
		$RHODOS_STORAGE[ $var_name ][ $key ] += $value;
	}
}

// Concatenate array element with specified value
if ( ! function_exists( 'rhodos_storage_concat_array' ) ) {
	function rhodos_storage_concat_array( $var_name, $key, $value ) {
		global $RHODOS_STORAGE;
		if ( ! isset( $RHODOS_STORAGE[ $var_name ] ) ) {
			$RHODOS_STORAGE[ $var_name ] = array();
		}
		if ( empty( $RHODOS_STORAGE[ $var_name ][ $key ] ) ) {
			$RHODOS_STORAGE[ $var_name ][ $key ] = '';
		}
		$RHODOS_STORAGE[ $var_name ][ $key ] .= $value;
	}
}

// Call object's method
if ( ! function_exists( 'rhodos_storage_call_obj_method' ) ) {
	function rhodos_storage_call_obj_method( $var_name, $method, $param = null ) {
		global $RHODOS_STORAGE;
		if ( null === $param ) {
			return ! empty( $var_name ) && ! empty( $method ) && isset( $RHODOS_STORAGE[ $var_name ] ) ? $RHODOS_STORAGE[ $var_name ]->$method() : '';
		} else {
			return ! empty( $var_name ) && ! empty( $method ) && isset( $RHODOS_STORAGE[ $var_name ] ) ? $RHODOS_STORAGE[ $var_name ]->$method( $param ) : '';
		}
	}
}

// Get object's property
if ( ! function_exists( 'rhodos_storage_get_obj_property' ) ) {
	function rhodos_storage_get_obj_property( $var_name, $prop, $default = '' ) {
		global $RHODOS_STORAGE;
		return ! empty( $var_name ) && ! empty( $prop ) && isset( $RHODOS_STORAGE[ $var_name ]->$prop ) ? $RHODOS_STORAGE[ $var_name ]->$prop : $default;
	}
}
