<?php
/**
 * The template for homepage posts with custom style
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0.50
 */

rhodos_storage_set( 'blog_archive', true );

get_header();

if ( have_posts() ) {

	$rhodos_blog_style = rhodos_get_theme_option( 'blog_style' );
	$rhodos_parts      = explode( '_', $rhodos_blog_style );
	$rhodos_columns    = ! empty( $rhodos_parts[1] ) ? max( 1, min( 6, (int) $rhodos_parts[1] ) ) : 1;
	$rhodos_blog_id    = rhodos_get_custom_blog_id( $rhodos_blog_style );
	$rhodos_blog_meta  = rhodos_get_custom_layout_meta( $rhodos_blog_id );
	if ( ! empty( $rhodos_blog_meta['margin'] ) ) {
		rhodos_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( rhodos_prepare_css_value( $rhodos_blog_meta['margin'] ) ) ) );
	}
	$rhodos_custom_style = ! empty( $rhodos_blog_meta['scripts_required'] ) ? $rhodos_blog_meta['scripts_required'] : 'none';

	rhodos_blog_archive_start();

	$rhodos_classes    = 'posts_container blog_custom_wrap' 
							. ( ! rhodos_is_off( $rhodos_custom_style )
								? sprintf( ' %s_wrap', $rhodos_custom_style )
								: ( $rhodos_columns > 1 
									? ' columns_wrap columns_padding_bottom' 
									: ''
									)
								);
	$rhodos_stickies   = is_home() ? get_option( 'sticky_posts' ) : false;
	$rhodos_sticky_out = rhodos_get_theme_option( 'sticky_style' ) == 'columns'
							&& is_array( $rhodos_stickies ) && count( $rhodos_stickies ) > 0 && get_query_var( 'paged' ) < 1;
	if ( $rhodos_sticky_out ) {
		?>
		<div class="sticky_wrap columns_wrap">
		<?php
	}
	if ( ! $rhodos_sticky_out ) {
		if ( rhodos_get_theme_option( 'first_post_large' ) && ! is_paged() && ! in_array( rhodos_get_theme_option( 'body_style' ), array( 'fullwide', 'fullscreen' ) ) ) {
			the_post();
			get_template_part( apply_filters( 'rhodos_filter_get_template_part', 'content', 'excerpt' ), 'excerpt' );
		}
		?>
		<div class="<?php echo esc_attr( $rhodos_classes ); ?>">
		<?php
	}
	while ( have_posts() ) {
		the_post();
		if ( $rhodos_sticky_out && ! is_sticky() ) {
			$rhodos_sticky_out = false;
			?>
			</div><div class="<?php echo esc_attr( $rhodos_classes ); ?>">
			<?php
		}
		$rhodos_part = $rhodos_sticky_out && is_sticky() ? 'sticky' : 'custom';
		get_template_part( apply_filters( 'rhodos_filter_get_template_part', 'content', $rhodos_part ), $rhodos_part );
	}
	?>
	</div>
	<?php

	rhodos_show_pagination();

	rhodos_blog_archive_end();

} else {

	if ( is_search() ) {
		get_template_part( apply_filters( 'rhodos_filter_get_template_part', 'content', 'none-search' ), 'none-search' );
	} else {
		get_template_part( apply_filters( 'rhodos_filter_get_template_part', 'content', 'none-archive' ), 'none-archive' );
	}
}

get_footer();
