<?php
// Add plugin-specific colors and fonts to the custom CSS
if ( ! function_exists( 'rhodos_booked_get_css' ) ) {
    add_filter( 'rhodos_filter_get_css', 'rhodos_booked_get_css', 10, 2 );
    function rhodos_booked_get_css( $css, $args ) {

        if ( isset( $css['fonts'] ) && isset( $args['fonts'] ) ) {
            $fonts         = $args['fonts'];
            $css['fonts'] .= <<<CSS



body .booked-form .field input[type="text"],
body .booked-form .field input[type="password"], 
body .booked-form .field input[type="tel"],
body .booked-form .field input[type="email"],
body .booked-form .field textarea {
	{$fonts['input_font-family']}
	{$fonts['input_font-size']}
	{$fonts['input_font-weight']}
	{$fonts['input_font-style']}
	{$fonts['input_line-height']}
	{$fonts['input_text-decoration']}
	{$fonts['input_text-transform']}
	{$fonts['input_letter-spacing']}
}

.booked-calendar-wrap .booked-appt-list .timeslot .timeslot-people button,
body #booked-profile-page input[type="submit"],
body #booked-profile-page button,
body .booked-list-view input[type="submit"],
body .booked-list-view button,
body table.booked-calendar input[type="submit"],
body table.booked-calendar button,
body .booked-modal input[type="submit"],
body .booked-modal button {
	{$fonts['button_font-family']}
	{$fonts['button_font-size']}
	{$fonts['button_font-weight']}
	{$fonts['button_font-style']}
	{$fonts['button_line-height']}
	{$fonts['button_text-decoration']}
	{$fonts['button_text-transform']}
	{$fonts['button_letter-spacing']}
}
body .booked-form .field label.field-label,
body table.booked-calendar tr.days th,
body table.booked-calendar th .monthName {
	{$fonts['h5_font-family']}
}

CSS;
        }

        if ( isset( $css['colors'] ) && isset( $args['colors'] ) ) {
            $colors         = $args['colors'];
            $css['colors'] .= <<<CSS

/* Form fields */
#booked-page-form {
	color: {$colors['text']};
	border-color: {$colors['bd_color']};
}

#booked-profile-page .booked-profile-header {
	background-color: {$colors['bg_color']} !important;
	border-color: transparent !important;
	color: {$colors['text']};
}
#booked-profile-page .booked-user h3 {
	color: {$colors['text_dark']};
}
#booked-profile-page .booked-profile-header .booked-logout-button:hover {
	color: {$colors['text_link']};
}
#booked-profile-page .booked-tabs {
	border-color: {$colors['alter_bd_color']} !important;
}
.booked-modal .bm-window p.booked-title-bar {
	color: {$colors['alter_dark']} !important;
	background-color: {$colors['alter_bg_color']} !important;
}
.booked-modal .bm-window .close i {
	color: {$colors['alter_dark']};
}
.booked-modal .bm-window .booked-scrollable {
	color: {$colors['alter_text']};
	background-color: {$colors['bg_color']} !important;
}
body .booked-modal .bm-window a {
	color: {$colors['text_link2']};
}
body .booked-modal .bm-window a:hover,
body .booked-modal .bm-window a:focus {
	color: {$colors['text_hover2']};
}
.booked-modal .bm-window .booked-scrollable em {
	color: {$colors['alter_dark']};
}
.booked-modal .bm-window #customerChoices {
	background-color: {$colors['bg_color']};
	border-color: {$colors['bd_color']};
}
.booked-form .booked-appointments {
	color: {$colors['alter_text']};
	background-color: {$colors['alter_bg_color']} !important;	
}
.booked-modal .bm-window p.appointment-title {
	color: {$colors['alter_dark']};	
}
body .booked-modal .bm-window p.calendar-name {
	color: {$colors['alter_dark']};	
}
body .booked-form input[type="submit"].button:disabled,
body .booked-form input[type="submit"].button:disabled:focus,
body .booked-form input[type="submit"].button:disabled:hover {
	color: {$colors['inverse_link']} !important;
	border-color:  {$colors['text_dark_05']} !important;
	background-color: {$colors['text_dark_05']} !important;
	box-shadow: none !important;
}
body .booked-modal input[type="submit"].button-primary {
	color: {$colors['inverse_link']};
	border-color:  {$colors['text_link2']} !important;
	background-color: {$colors['text_link2']} !important;
	box-shadow: none !important;	
}
body .booked-modal input[type="submit"].button-primary:hover,
body .booked-modal input[type="submit"].button-primary:focus {
	color: {$colors['inverse_link']};
	border-color:  {$colors['text_hover2']} !important;
	background-color: {$colors['text_hover2']} !important;
	box-shadow: none !important;	
}
body .booked-modal .bm-window button.cancel {
	color: {$colors['inverse_hover']} !important;
	border-color:  {$colors['text_dark']} !important;
	background-color: {$colors['text_dark']} !important;
	box-shadow: none !important;
}
body .booked-modal .bm-window button.cancel:hover,
body .booked-modal .bm-window button.cancel:focus {
	color: {$colors['inverse_link']} !important;
	border-color:  {$colors['text_link2']} !important;
	background-color: {$colors['text_link2']} !important;
	box-shadow: none !important;
}
body .booked-form .field label.field-label {
	color: {$colors['text_dark']};
}
body .booked-form .field input[type="text"],
body .booked-form .field input[type="password"],
body .booked-form .field input[type="tel"],
body .booked-form .field input[type="email"],
body .booked-form .field textarea {
	color: {$colors['input_text']};
}

/* Profile page and tabs */
.booked-calendarSwitcher.calendar,
.booked-calendarSwitcher.calendar select,
#booked-profile-page .booked-tabs {
	background-color: {$colors['alter_bg_color']} !important;
}
#booked-profile-page .booked-tabs li a {
	background-color: {$colors['extra_bg_hover']};
	color: {$colors['extra_dark']};
}
#booked-profile-page .booked-tabs li a i {
	color: {$colors['extra_dark']};
}
#booked-profile-page .booked-tabs li.active a,
#booked-profile-page .booked-tabs li.active a:hover,
#booked-profile-page .booked-tabs li a:hover {
	color: {$colors['extra_dark']} !important;
	background-color: {$colors['extra_bg_color']} !important;
}
#booked-profile-page .booked-tab-content {
	background-color: {$colors['bg_color']};
	border-color: {$colors['alter_bd_color']};
}

/* Calendar */
 table.booked-calendar th {
 	border-color: {$colors['alter_link2']} !important;
 }
table.booked-calendar th,
table.booked-calendar thead th {
	background-color: {$colors['alter_link2']} !important;
}
table.booked-calendar thead tr {
	background-color: {$colors['text_link2']} !important;
}
table.booked-calendar thead tr th {
	color: {$colors['inverse_link']} !important;
}
table.booked-calendar thead th i {
	color: {$colors['inverse_link']} !important;
}
table.booked-calendar td .date {
	background-color: {$colors['bg_color']} !important;
}
table.booked-calendar td:hover .date {
	background-color: {$colors['text_link2']} !important;
}
table.booked-calendar td .date span {
	color: {$colors['alter_light']} !important;
}
table.booked-calendar td:hover .date span {
	color: {$colors['inverse_link']} !important;
	background-color: transparent !important;
}
table.booked-calendar tr.days {
	background-color: {$colors['bg_color']} !important;
}
body table.booked-calendar td.next-month .date,
body table.booked-calendar td.prev-month .date {
    background-color: {$colors['bg_color']} !important;
}
body table.booked-calendar td.next-month:hover .date,
body table.booked-calendar td.prev-month:hover .date {
    background-color: {$colors['alter_link2']} !important;
}

body table.booked-calendar td.prev-month.prev-date .date {
    background-color: {$colors['alter_bg_color']} !important;
}
table.booked-calendar tr.days th {
	background-color: transparent !important;
	border-color: {$colors['alter_bd_color']};
}
table.booked-calendar td.prev-date .date,
table.booked-calendar td.prev-date:hover .date,
table.booked-calendar td.prev-date:hover .date span {
	background-color: {$colors['alter_bg_color']} !important;
}
table.booked-calendar td.prev-month.prev-date .date span {
	background-color: transparent !important;
}
table.booked-calendar td.next-month .date span,
table.booked-calendar td.prev-month .date span {
	color: {$colors['alter_light']} !important;
}
table.booked-calendar td.prev-month:not(.prev-date):hover .date span,
table.booked-calendar td.next-month:hover .date span {
	color: {$colors['inverse_link']} !important;
}
table.booked-calendar tr.days th {
	color: {$colors['alter_dark']} !important;
}
table.booked-calendar thead th .monthName a {
	color: {$colors['inverse_link']};
}
table.booked-calendar thead th .monthName a:hover {
	color: {$colors['inverse_link']};
	opacity: .9;
}
table.booked-calendar tbody tr {
	background-color: {$colors['alter_bg_color']} !important;
}
table.booked-calendar tbody tr td {
	color: {$colors['alter_light']} !important;
	border-color: {$colors['alter_bd_color']} !important;
}
body table.booked-calendar tr.days th,
body #booked-profile-page .booked-tabs {
	border-color: {$colors['alter_bd_color']} !important;	
}

table.booked-calendar tbody tr td:hover {
	color: {$colors['alter_light']} !important;
}
table.booked-calendar tbody tr td.today .date {
	color: {$colors['alter_light']} !important;
	background-color: {$colors['alter_bg_hover']} !important;
}
table.booked-calendar tbody tr td.today:hover .date {
	color: {$colors['inverse_link']} !important;
	background-color: {$colors['alter_link2']} !important;
}
table.booked-calendar tbody td.today .date span {
	border-color: {$colors['alter_link2']};
}
table.booked-calendar tbody td.today:hover .date span {
	background-color: transparent !important;
	color: {$colors['inverse_link']} !important;
}
body table.booked-calendar tr.week td.active .date .number {
	color: {$colors['inverse_link']} !important;
	background-color: transparent !important;
}
table.booked-calendar tr.week td.active .date,
table.booked-calendar tr.week td.active:hover .date {
    color: {$colors['inverse_link']} !important;
	background-color: {$colors['alter_link2']} !important;
}
.booked-calendar-wrap .booked-appt-list {
    border-color: {$colors['alter_link2']};
}

.booked-calendar-wrap .booked-appt-list h2 {
	color: {$colors['text_dark']};
}
.booked-calendar-wrap .booked-appt-list .timeslot {
	border-color: {$colors['alter_bd_color']};	
}
.booked-calendar-wrap .booked-appt-list .timeslot:hover {
	background-color: transparent;	
}
.booked-calendar-wrap .booked-appt-list .timeslot .timeslot-title {
	color: {$colors['text_link']};
}
.booked-calendar-wrap .booked-appt-list .timeslot .timeslot-time {
	color: {$colors['text_dark']};
}
body .booked-calendar-wrap .booked-calendar .booked-appt-list .timeslot + .timeslot {
	border-color: {$colors['alter_bd_color']};	
}
body .booked-calendar-wrap .booked-appt-list .timeslot .spots-available {
	color: {$colors['text_light']};
}

body table.booked-calendar .booked-appt-list .timeslot .timeslot-people button {
	color: {$colors['inverse_hover']};
	border-color:  {$colors['text_dark']} !important;
	background-color: {$colors['text_dark']} !important;	
	box-shadow: none !important;
}
body table.booked-calendar .booked-appt-list .timeslot .timeslot-people button:hover,
body table.booked-calendar .booked-appt-list .timeslot .timeslot-people button:focus {
	color: {$colors['inverse_link']};
	border-color:  {$colors['text_link2']} !important;
	background-color: {$colors['text_link2']} !important;
	box-shadow: none !important;	
}

body .booked-calendar-wrap .booked-appt-list .timeslot .timeslot-people button[disabled],
body .booked-calendar-wrap .booked-appt-list .timeslot .timeslot-people button[disabled]:hover {
	color: {$colors['inverse_link']} !important;
	border-color:  {$colors['text_dark_05']} !important;
	background-color: {$colors['text_dark_05']} !important;
	box-shadow: none !important;
}


/* Small Calendar */
.booked-calendar-wrap.small table.booked-calendar tr.week td.active .date,
.booked-calendar-wrap.small .booked-calendar tr.week td.active .date span,
.booked-calendar-wrap.small table.booked-calendar td.today.active:hover .date span {
	color: {$colors['inverse_link']} !important;
	background-color: {$colors['alter_link2']} !important;
}
.booked-calendar-wrap.small table.booked-calendar .booked-appt-list .timeslot .spots-available {
	color: {$colors['inverse_hover']};
	opacity: .9;
}
.booked-calendar-wrap.small table.booked-calendar .booked-appt-list .timeslot .timeslot-people button {
	color: {$colors['inverse_hover']};
	border-color:  {$colors['text_dark']} !important;
	background-color: {$colors['text_dark']} !important;	
	box-shadow: none !important;
}
.booked-calendar-wrap.small table.booked-calendar .booked-appt-list .timeslot .timeslot-people button:hover,
.booked-calendar-wrap.small table.booked-calendar .booked-appt-list .timeslot .timeslot-people button:focus {
	color: {$colors['inverse_link']};
	border-color:  {$colors['text_link2']} !important;
	background-color: {$colors['text_link2']} !important;
	box-shadow: none !important;	
}
.booked-calendar-wrap.small table.booked-calendar .booked-appt-list .timeslot .timeslot-people button:hover .spots-available,
.booked-calendar-wrap.small table.booked-calendar .booked-appt-list .timeslot .timeslot-people button:focus .spots-available {
	color: {$colors['inverse_link']};
}
.booked-calendar-wrap.small table.booked-calendar .booked-appt-list .timeslot .timeslot-people button[disabled], 
.booked-calendar-wrap.small table.booked-calendar .booked-appt-list .timeslot .timeslot-people button[disabled]:hover {
	color: {$colors['inverse_link']} !important;
	border-color:  {$colors['text_dark_05']} !important;
	background-color: {$colors['text_dark_05']} !important;
	box-shadow: none !important;
}
.booked-calendar-wrap.small table.booked-calendar .booked-appt-list .timeslot .timeslot-people button[disabled] .spots-available {
	color: {$colors['inverse_link']} !important;
}
.booked-calendar-wrap.small table.booked-calendar td:hover .date span {
	color: {$colors['alter_light']} !important;
}
.booked-calendar-wrap.small table.booked-calendar td:hover .date span {
	color: {$colors['inverse_link']} !important;
	background-color: {$colors['alter_link2']} !important;
}
.booked-calendar-wrap.small table.booked-calendar td.prev-date .date span,
.booked-calendar-wrap.small table.booked-calendar td.prev-date:hover .date span,
.booked-calendar-wrap.small table.booked-calendar td.prev-month.prev-date .date span,
.booked-calendar-wrap.small table.booked-calendar td.prev-month.prev-date:hover .date span {
    color: {$colors['alter_light']} !important;
 	background-color: {$colors['alter_bg_color']} !important;
}


CSS;
        }

        return $css;
    }
}

