<?php
/* Booked Appointments support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'rhodos_booked_theme_setup9' ) ) {
    add_action( 'after_setup_theme', 'rhodos_booked_theme_setup9', 9 );
    function rhodos_booked_theme_setup9() {
        add_filter( 'rhodos_filter_merge_styles', 'rhodos_booked_merge_styles' );
        add_filter( 'rhodos_filter_merge_styles_responsive', 'rhodos_booked_merge_styles_responsive' );

        if ( is_admin() ) {
            add_filter( 'rhodos_filter_tgmpa_required_plugins', 'rhodos_booked_tgmpa_required_plugins' );
        }
    }
}

// Filter to add in the required plugins list
if ( ! function_exists( 'rhodos_booked_tgmpa_required_plugins' ) ) {
    function rhodos_booked_tgmpa_required_plugins( $list = array() ) {
        if ( rhodos_storage_isset( 'required_plugins', 'booked' ) && rhodos_is_theme_activated() ) {
            $path = rhodos_get_plugin_source_path( 'plugins/booked/booked.zip' );
            if ( ! empty( $path ) || rhodos_get_theme_setting( 'tgmpa_upload' ) ) {
                $list[] = array(
                    'name'     => rhodos_storage_get_array( 'required_plugins', 'booked' ),
                    'slug'     => 'booked',
                    'source'   => ! empty( $path ) ? $path : 'upload://booked.zip',
                    'version'  => '2.3.5',
                    'required' => false,
                );
            }

        }
        return $list;
    }
}


// Check if plugin installed and activated
if ( ! function_exists( 'rhodos_exists_booked' ) ) {
    function rhodos_exists_booked() {
        return class_exists( 'booked_plugin' );
    }
}

// Merge custom styles
if ( ! function_exists( 'rhodos_booked_merge_styles' ) ) {
    function rhodos_booked_merge_styles( $list ) {
        if ( rhodos_exists_booked() ) {
            $list[] = 'plugins/booked/_booked.scss';
        }
        return $list;
    }
}

// Merge responsive styles
if ( ! function_exists( 'rhodos_booked_merge_styles_responsive' ) ) {

    function rhodos_booked_merge_styles_responsive( $list ) {
        if ( rhodos_exists_booked() ) {
            $list[] = 'plugins/booked/_booked-responsive.scss';
        }
        return $list;
    }
}


// Add plugin-specific colors and fonts to the custom CSS
if ( rhodos_exists_booked() ) {
    require_once RHODOS_THEME_DIR . 'plugins/booked/booked-styles.php'; }

