<?php
/* Essential Grid support functions
------------------------------------------------------------------------------- */


// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'rhodos_essential_grid_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'rhodos_essential_grid_theme_setup9', 9 );
	function rhodos_essential_grid_theme_setup9() {

		add_filter( 'rhodos_filter_merge_styles', 'rhodos_essential_grid_merge_styles' );

		if ( is_admin() ) {
			add_filter( 'rhodos_filter_tgmpa_required_plugins', 'rhodos_essential_grid_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'rhodos_essential_grid_tgmpa_required_plugins' ) ) {
	
	function rhodos_essential_grid_tgmpa_required_plugins( $list = array() ) {
		if ( rhodos_storage_isset( 'required_plugins', 'essential-grid' ) && rhodos_is_theme_activated() ) {
			$path = rhodos_get_plugin_source_path( 'plugins/essential-grid/essential-grid.zip' );
			if ( ! empty( $path ) || rhodos_get_theme_setting( 'tgmpa_upload' ) ) {
				$list[] = array(
					'name'     => rhodos_storage_get_array( 'required_plugins', 'essential-grid' ),
					'slug'     => 'essential-grid',
                    'version'   => '3.0.11',
					'source'   => ! empty( $path ) ? $path : 'upload://essential-grid.zip',
					'required' => false,
				);
			}
		}
		return $list;
	}
}

// Check if plugin installed and activated
if ( ! function_exists( 'rhodos_exists_essential_grid' ) ) {
	function rhodos_exists_essential_grid() {
		return defined( 'EG_PLUGIN_PATH' );
	}
}

// Merge custom styles
if ( ! function_exists( 'rhodos_essential_grid_merge_styles' ) ) {
	
	function rhodos_essential_grid_merge_styles( $list ) {
		if ( rhodos_exists_essential_grid() ) {
			$list[] = 'plugins/essential-grid/_essential-grid.scss';
		}
		return $list;
	}
}

