<?php
// Add skin-specific colors and fonts to the custom CSS
if ( ! function_exists( 'rhodos_skin_get_css' ) ) {
	add_filter( 'rhodos_filter_get_css', 'rhodos_skin_get_css', 10, 2 );
	function rhodos_skin_get_css( $css, $args ) {

		if ( isset( $css['fonts'] ) && isset( $args['fonts'] ) ) {
			$fonts         = $args['fonts'];
			$css['fonts'] .= <<<CSS
			
			.sc_icons_extra .sc_icons_item_description,
			.sc_services_hover .sc_services_item_price,
			.sc_events_default .sc_events_item_wrap .sc_events_item_date,
			.sc_events_default .sc_events_item_wrap .sc_events_item_thumb .sc_events_item_date_start .sc_events_item_date_wrap {
			    {$fonts['h5_font-family']}
			}
			
			.sc_icons_extra .sc_icons_item_title {
			    {$fonts['p_font-family']}
			}
            
CSS;
		}

		if ( isset( $css['vars'] ) && isset( $args['vars'] ) ) {
			$vars         = $args['vars'];
			$css['vars'] .= <<<CSS

CSS;
		}

		if ( isset( $css['colors'] ) && isset( $args['colors'] ) ) {
			$colors         = $args['colors'];
			$css['colors'] .= <<<CSS
			
			ul[class*="trx_addons_list"] > li:before {
			    color: {$colors['text_link2']};
			}
			
			  /* Messages */
            .trx_addons_field_error, .wpcf7-not-valid {
                 border-color: {$colors['text_link']} !important;
            }
            span.wpcf7-not-valid-tip {
                color: {$colors['text_link']};
            }
            div.wpcf7-validation-errors, div.wpcf7-acceptance-missing {
                border-color: {$colors['text_link']};
            }
            div.wpcf7-mail-sent-ok {
                border-color: {$colors['text_link2']};
            }
            .trx_addons_message_box_error {
                border-color: {$colors['text_link']};
            }
            .trx_addons_message_box_success {
                border-color: {$colors['text_link2']};
            }
            form .error_field {
                border-color: {$colors['text_link']} !important;
            }
            /* Elementor Toggle */
            .elementor-toggle .elementor-tab-content {
                color: {$colors['text']};
            }
            .elementor-toggle .elementor-tab-title {
                color: {$colors['text_dark']};
                border-color: {$colors['alter_bg_color']};
                background-color: {$colors['alter_bg_color']};
            }
            .elementor-toggle .elementor-tab-title.elementor-active {
                color: {$colors['inverse_link']};
                border-color: {$colors['inverse_bg_hover']};
                background-color: {$colors['inverse_bg_hover']};
            }
            /* MailChimp */
            .mc4wp-form input[type="checkbox"] + label > a {
                 color: {$colors['text_dark']};
            }
            .mc4wp-form input[type="checkbox"] + label > a:hover {
                 color: {$colors['text_dark']};
            }
            /* Services */
            .sc_services_extra  .sc_services_item_button .sc_button.sc_button_icon {
                 color: {$colors['text_dark']} !important;
                 background-color: transparent !important ;
                 border-color: transparent !important;
            }
            .sc_services_extra  .sc_services_item_button .sc_button.sc_button_icon:hover {
                 color: {$colors['text_link']} !important;
                 background-color: transparent !important ;
                 border-color: transparent !important;
            }
            .sc_services_extra .sc_services_item {
                 background-color: {$colors['bg_color']};
            }
            .sc_services .sc_services_item_number {
                 color: {$colors['text_dark']};
            }
            .sc_services_list .sc_services_item_featured_left .sc_services_item_number,
            .sc_services_list .sc_services_item_featured_right .sc_services_item_number {
                color: {$colors['text_dark']};
            }
            .sc_services_default .sc_services_item_featured_left,
            .sc_services_default .sc_services_item_featured_right,
            .sc_services_list .sc_services_item {
                color: {$colors['extra_text']};
                background-color: transparent;
            }    
            .sc_services_list.sc_services_featured_top .sc_services_item.with_number .sc_services_item_title:before {
                background-color: {$colors['extra_text']};
            }
            .sc_services_hover .sc_services_item_number {
                 color: {$colors['inverse_link']};
            }
            
            /* Testimonials */
             .color_style_link2 .sc_testimonials_item_author_title {
                color: {$colors['text_dark']};   
             }
             /* Blogger */
            .sc_blogger_extra .sc_blogger_item {
                background-color: transparent;
                -webkit-box-shadow:  0 0 24px {$colors['inverse_bg_color_008']};
                -moz-box-shadow:  0 0 24px {$colors['inverse_bg_color_008']};
                box-shadow: 0 0 24px {$colors['inverse_bg_color_008']};
            }
            .sc_blogger_extra .sc_blogger_item .sc_blogger_item_content_wrapper {
                background-color: {$colors['bg_color']};
            }
            /* Event */
            #tribe-bar-form.tribe-bar-views-open button#tribe-bar-views-toggle:hover, 
            #tribe-bar-form button#tribe-bar-views-toggle {
                -webkit-box-shadow: 0 9px 18px {$colors['inverse_dark_018']};
                -moz-box-shadow: 0 9px 18px {$colors['inverse_dark_018']};
                box-shadow:  0 9px 18px {$colors['inverse_dark_018']};
            }

            .sc_events_default .sc_events_item_wrap {
                 background-color: {$colors['bg_color']};
            }

            .sc_events_default .sc_events_item_wrap .sc_events_item_thumb .sc_events_item_date_start .sc_events_item_date_wrap {
                 color: {$colors['inverse_link']};   
                 background-color: {$colors['inverse_dark']};
            }
            .sc_events_default .sc_events_item_wrap  .sc_events_button_wrap .sc_events_item_link {
                 color: {$colors['text_link']};  
                 border-color: {$colors['bd_color']};
                 background-color: transparent;
            }
            .sc_events_default .sc_events_item_wrap  .sc_events_button_wrap .sc_events_item_link:hover {
                 color: {$colors['inverse_hover']};  
                 border-color: {$colors['text_dark']};
                 background-color: {$colors['text_dark']};
            }
            .sc_events_default .sc_events_columns [class*="trx_addons_column-"] .sc_events_button_wrap .sc_events_item_link {
                 color: {$colors['inverse_link']};  
                 border-color: {$colors['text_link']};
                 background-color:  {$colors['text_link']};   
            }
            .sc_events_default .sc_events_columns [class*="trx_addons_column-"] .sc_events_button_wrap .sc_events_item_link:hover {
                 color: {$colors['inverse_link']};  
                 border-color: {$colors['text_hover']};
                 background-color:  {$colors['text_hover']};   
            }
            /* Icons */
            .sc_icons_extra .sc_icons_icon {
                background-color:  {$colors['bg_color']};   
            }
            .sc_icons_extra .sc_icons_icon.alter_icon_bg {
                background-color:  {$colors['alter_bg_color']};   
            }
            
            .sc_icons_extra .sc_icons_item_description {
                color: {$colors['text_dark']};
            }
            .sc_icons_extra .sc_icons_item_description a {
                color: {$colors['text_link']};
            }
            .sc_icons_extra .sc_icons_item_description a:hover {
                color: {$colors['text_hover']};
            }
            .sc_icons_extra .sc_icons_item_linked .sc_icons_item_description {
                 color: {$colors['text_link']};
            }
            .sc_icons_extra .sc_icons_item_linked:hover .sc_icons_item_description {
                 color: {$colors['text_hover']};
            }
            .sc_icons_extra  .sc_icons_item_linked .sc_icons_icon {
                 color: {$colors['text_dark']};
            }
            .sc_icons_extra  .sc_icons_item_linked:hover .sc_icons_icon  {
                color: {$colors['text_link']};
            }
            .sc_icons_extra .sc_icons_item_title {
                color: {$colors['text']};
            }
            .sc_icons_extra .sc_icons_icon {
                
            }
            
            /* Actions */
            .sc_button.sc_action_item_link {
                color: {$colors['inverse_link']} !important;
                background-color: {$colors['text_link']} !important;
                -webkit-box-shadow: 0 9px 18px {$colors['text_link_018']} !important;
                -ms-box-shadow: 0 9px 18px {$colors['text_link_018']} !important;
                box-shadow: 0 9px 18px {$colors['text_link_018']} !important;
            }
            .sc_button.sc_action_item_link:hover {
                color: {$colors['inverse_link']} !important;
                background-color: {$colors['text_hover']} !important;
                -webkit-box-shadow: none !important;
                -ms-box-shadow: none !important;
                box-shadow: none !important;
            }

CSS;
		}

		return $css;
	}
}

