<?php
// Add skin-specific colors and fonts to the custom CSS
if ( ! function_exists( 'rhodos_skin_get_css' ) ) {
	add_filter( 'rhodos_filter_get_css', 'rhodos_skin_get_css', 10, 2 );
	function rhodos_skin_get_css( $css, $args ) {

		if ( isset( $css['fonts'] ) && isset( $args['fonts'] ) ) {
			$fonts         = $args['fonts'];
			$css['fonts'] .= <<<CSS

CSS;
		}

		if ( isset( $css['vars'] ) && isset( $args['vars'] ) ) {
			$vars         = $args['vars'];
			$css['vars'] .= <<<CSS

CSS;
		}

		if ( isset( $css['colors'] ) && isset( $args['colors'] ) ) {
			$colors         = $args['colors'];
			$css['colors'] .= <<<CSS
			
			ul[class*="trx_addons_list"] > li:before {
			    color: {$colors['text_link2']};
			}
			
			  /* Messages */
            .trx_addons_field_error, .wpcf7-not-valid {
                 border-color: {$colors['text_link']} !important;
            }
            span.wpcf7-not-valid-tip {
                color: {$colors['text_link']};
            }
            div.wpcf7-validation-errors, div.wpcf7-acceptance-missing {
                border-color: {$colors['text_link']};
            }
            div.wpcf7-mail-sent-ok {
                border-color: {$colors['text_link2']};
            }
            .trx_addons_message_box_error {
                border-color: {$colors['text_link']};
            }
            .trx_addons_message_box_success {
                border-color: {$colors['text_link2']};
            }
            form .error_field {
                border-color: {$colors['text_link']} !important;
            }
            /* MailChimp */
            .mc4wp-form input[type="checkbox"] + label > a {
                 color: {$colors['text_dark']};
            }
            .mc4wp-form input[type="checkbox"] + label > a:hover {
                 color: {$colors['text_dark']};
            }
            /* Services */
            .sc_services .sc_services_item_number {
                 color: {$colors['text_dark']};
            }
            .sc_services_list .sc_services_item_featured_left .sc_services_item_number,
            .sc_services_list .sc_services_item_featured_right .sc_services_item_number {
                color: {$colors['text_dark']};
            }
            .sc_services_default .sc_services_item_featured_left,
            .sc_services_default .sc_services_item_featured_right,
            .sc_services_list .sc_services_item {
                color: {$colors['extra_text']};
                background-color: transparent;
            }    
            .sc_services_list.sc_services_featured_top .sc_services_item.with_number .sc_services_item_title:before {
                background-color: {$colors['extra_text']};
            }
            /* Testimonials */
             .color_style_link2 .sc_testimonials_item_author_title {
                color: {$colors['text_dark']};   
             }
             /* Blogger */
            .sc_blogger_extra .sc_blogger_item {
                background-color: transparent;
                -webkit-box-shadow:  0 0 24px {$colors['inverse_bg_color_008']};
                -moz-box-shadow:  0 0 24px {$colors['inverse_bg_color_008']};
                box-shadow: 0 0 24px {$colors['inverse_bg_color_008']};
            }
            .sc_blogger_extra .sc_blogger_item .sc_blogger_item_content_wrapper {
                background-color: {$colors['bg_color']};
            }
            
            .wpcf7 form.invalid .wpcf7-response-output{
                border-color: {$colors['text_link']};
            }
            
            .wpcf7 form.sent div.wpcf7-response-output{
                border-color: {$colors['text_link2']};
            }


CSS;
		}

		return $css;
	}
}

