<?php
/**
 * The template to display the Author bio
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0
 */
?>

<div class="author_info scheme_dark author vcard" itemprop="author" itemscope itemtype="//schema.org/Person">
    <div class="author_avatar" itemprop="image">
        <?php
        $rhodos_mult = rhodos_get_retina_multiplier();
        echo get_avatar( get_the_author_meta( 'user_email' ), 240 * $rhodos_mult );
        ?>
    </div><!-- .author_avatar -->
    <div class="author_title_container">
        <span class="about_author"><?php echo esc_html__('About', 'rhodos' )?></span>
        <h5 class="author_title" itemprop="name"><?php echo wp_kses_data( get_the_author() ); ?></h5>
    </div>

	<div class="author_description">
		<div class="author_bio" itemprop="description">
			<?php echo wp_kses( wpautop( get_the_author_meta( 'description' ) ), 'rhodos_kses_content' ); ?>
            <a class="author_link" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author"><?php esc_html_e('View More', 'rhodos');?></a>

			<?php do_action( 'rhodos_action_user_meta' ); ?>
		</div><!-- .author_bio -->

	</div><!-- .author_description -->

</div><!-- .author_info -->
