<?php
/**
 * The template to display the site logo in the footer
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0.10
 */

// Logo
if ( rhodos_is_on( rhodos_get_theme_option( 'logo_in_footer' ) ) ) {
    $rhodos_logo_image = rhodos_get_logo_image( 'footer' );
    $rhodos_logo_text  = get_bloginfo( 'name' );
    if ( ! empty( $rhodos_logo_image['logo'] ) || ! empty( $rhodos_logo_text ) ) {
        ?>
        <div class="footer_logo_wrap">
            <div class="footer_logo_inner">
                <?php
                if ( ! empty( $rhodos_logo_image['logo'] ) ) {
                    $rhodos_attr = rhodos_getimagesize( $rhodos_logo_image['logo'] );
                    echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
                        . '<img src="' . esc_url( $rhodos_logo_image['logo'] ) . '"'
                        . ( ! empty( $rhodos_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $rhodos_logo_image['logo_retina'] ) . ' 2x"' : '' )
                        . ' class="logo_footer_image"'
                        . ' alt="' . esc_attr__( 'Site logo', 'rhodos' ) . '"'
                        . ( ! empty( $rhodos_attr[3] ) ? ' ' . wp_kses_data( $rhodos_attr[3] ) : '' )
                        . '>'
                        . '</a>';
                } elseif ( ! empty( $rhodos_logo_text ) ) {
                    echo '<h1 class="logo_footer_text">'
                        . '<a href="' . esc_url( home_url( '/' ) ) . '">'
                        . esc_html( $rhodos_logo_text )
                        . '</a>'
                        . '</h1>';
                }
                ?>
            </div>
        </div>
        <?php
    }
}
