<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package WordPress
 * @subpackage RHODOS
 * @since RHODOS 1.0
 */

$rhodos_args = get_query_var( 'rhodos_logo_args' );

// Site logo
$rhodos_logo_type   = isset( $rhodos_args['type'] ) ? $rhodos_args['type'] : '';
$rhodos_logo_image  = rhodos_get_logo_image( $rhodos_logo_type );
$rhodos_logo_text   = rhodos_is_on( rhodos_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$rhodos_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $rhodos_logo_image['logo'] ) || ! empty( $rhodos_logo_text ) ) {
    ?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
    <?php
    if ( ! empty( $rhodos_logo_image['logo'] ) ) {
        if ( empty( $rhodos_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric( $rhodos_logo_image['logo'] ) && $rhodos_logo_image['logo'] > 0 ) {
            the_custom_logo();
        } else {
            $rhodos_attr = rhodos_getimagesize( $rhodos_logo_image['logo'] );
            echo '<img src="' . esc_url( $rhodos_logo_image['logo'] ) . '"'
                . ( ! empty( $rhodos_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $rhodos_logo_image['logo_retina'] ) . ' 2x"' : '' )
                . ' alt="' . esc_attr( $rhodos_logo_text ) . '"'
                . ( ! empty( $rhodos_attr[3] ) ? ' ' . wp_kses_data( $rhodos_attr[3] ) : '' )
                . '>';
        }
    } else {
        rhodos_show_layout( rhodos_prepare_macros( $rhodos_logo_text ), '<span class="logo_text">', '</span>' );
        rhodos_show_layout( rhodos_prepare_macros( $rhodos_logo_slogan ), '<span class="logo_slogan">', '</span>' );
    }
    ?>
    </a>
    <?php
}