<?php
/**
 * The style "default" of the Events
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.2
 */

$args = get_query_var('trx_addons_args_sc_events');

if ($args['slider']) {
	?><div class="slider-slide swiper-slide"><?php
} else if ($args['columns'] > 1) {
	?><div class="<?php echo esc_attr(trx_addons_get_column_class(1, $args['columns'])); ?>"><?php
}

    ?><div class="sc_events_item_wrap"><?php
        if ( has_post_thumbnail()) {
            trx_addons_get_template_part('templates/tpl.featured.php',
                'trx_addons_args_featured',
                array(
                    'class' => 'sc_events_item_thumb',
                    'thumb_size' => apply_filters('trx_addons_filter_thumb_size', trx_addons_get_thumb_size($args['columns'] > 1 ? 'big' : 'quadratic'), 'events-default'),
                )
            );
        }
        ?><div class="sc_events_item_content">
            <h4 class="sc_events_item_title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>

            <div class="sc_events_item_date"><?php
                // Event's date
                $date = tribe_get_start_date(null, true, 'j F, Y');
                $date2 = tribe_get_end_date(null, true, 'j F, Y');
                if (empty($date)) $date = get_the_date('j F, Y');
                if (empty($date2)) $date2 = get_the_date('j F, Y');
                $time = tribe_get_start_time(null, 'g:ia');
                $time2 = tribe_get_end_time(null, 'g:ia');
                // Event's date
                ?><span class="sc_events_item_date_start"><?php echo esc_html($date. ' '); echo  (esc_html($time) ? esc_html($time) : esc_html(' - ' .$date2)); ?></span><?php
                if ( !empty($date2) && !empty($time2) )  {?>
                    <span class="sc_events_item_date_separator"><?php echo esc_html( ' - ' );?></span>
                    <span class="sc_events_item_date_end"><?php echo esc_html($date2. ' '); echo  esc_html($time2) ?></span><?php
                }
            ?></div><?php
            if ( has_excerpt() ) { ?>
                <div class="sc_events_item_content_inner"><?php
                    the_excerpt();
                ?></div><?php
            }
?></div>
        <div class="sc_events_button_wrap">
            <a href="<?php the_permalink(); ?>" class="sc_events_item_link sc_button color_style_default"><?php esc_html_e('Read More','rhodos'); ?></a>
        </div>

    </div><?php

if ($args['slider'] || $args['columns'] > 1) {
	?></div><?php
}

?>